/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.wih;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.ClassObjectFilter;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.casemgmt.api.CaseService;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.jbpm.runtime.manager.impl.PerCaseRuntimeManager;
import org.jbpm.services.api.service.ServiceRegistry;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.CaseAssignment;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.task.api.TaskModelFactory;
import org.kie.internal.task.api.TaskModelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartCaseWorkItemHandler
implements WorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(StartCaseWorkItemHandler.class);
    private static final String DEPLOYMENT_ID = "DeploymentId";
    private static final String CASE_DEFINITION_ID = "CaseDefinitionId";
    private static final String DATA_PREFIX = "Data_";
    private static final String USER_ROLE_PREFIX = "UserRole_";
    private static final String GROUP_ROLE_PREFIX = "GroupRole_";
    private static final String DATA_ACCESS_PREFIX = "DataAccess_";
    private static final String INDEPENDENT = "Independent";
    private static final String DESTROY_ON_ABORT = "DestroyOnAbort";
    private static final String CASE_ID = "CaseId";
    private KieSession ksession;

    public StartCaseWorkItemHandler(KieSession ksession) {
        this.ksession = ksession;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        RuntimeManager targetRuntimeManager;
        String deploymentId = (String)workItem.getParameter(DEPLOYMENT_ID);
        if (deploymentId == null) {
            deploymentId = ((org.drools.core.process.instance.WorkItem)workItem).getDeploymentId();
        }
        if ((targetRuntimeManager = RuntimeManagerRegistry.get().getManager(deploymentId)) == null || !(targetRuntimeManager instanceof PerCaseRuntimeManager)) {
            throw new IllegalArgumentException("Requested target deployment does not exist or is not per case strategy");
        }
        String caseDefinitionId = (String)workItem.getParameter(CASE_DEFINITION_ID);
        if (caseDefinitionId == null || caseDefinitionId.trim().isEmpty()) {
            throw new IllegalArgumentException("CaseDefinitionId is a required parameter for StartCaseWorkItemHandler");
        }
        HashMap<String, Object> caseFileData = new HashMap<String, Object>();
        HashMap<String, List<String>> accessRestrictions = new HashMap<String, List<String>>();
        HashMap<String, OrganizationalEntity> roleAssignments = new HashMap<String, OrganizationalEntity>();
        this.parseParameters(workItem, caseFileData, roleAssignments, accessRestrictions);
        long processInstanceId = ((WorkItemImpl)workItem).getProcessInstanceId();
        long workItemId = workItem.getId();
        logger.debug("Parent process instance id {} and work item instance id {} for new case instance", (Object)processInstanceId, (Object)workItemId);
        CaseService caseService = (CaseService)ServiceRegistry.get().service("CaseService");
        CaseFileInstance subCaseFile = caseService.newCaseFileInstanceWithRestrictions(deploymentId, caseDefinitionId, caseFileData, roleAssignments, accessRestrictions);
        ((CaseFileInstanceImpl)subCaseFile).setParentInstanceId(processInstanceId);
        ((CaseFileInstanceImpl)subCaseFile).setParentWorkItemId(workItemId);
        String caseId = caseService.startCase(deploymentId, caseDefinitionId, subCaseFile);
        logger.debug("Case with id {} has been successfully started");
        boolean independent = Boolean.parseBoolean((String)workItem.getParameter(INDEPENDENT));
        if (independent) {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put(CASE_ID, caseId);
            try {
                CaseFileInstance snapshot = caseService.getCaseFileInstance(caseId);
                results.putAll(snapshot.getData());
            }
            catch (CaseNotFoundException e) {
                logger.debug("Case is already completed, not possible to fetch case file data any more");
            }
            logger.debug("Completing directly (without waiting for case instance {} completion) work item with id {}", (Object)caseId, (Object)workItem.getId());
            ((CaseFileInstanceImpl)subCaseFile).setParentInstanceId(null);
            ((CaseFileInstanceImpl)subCaseFile).setParentWorkItemId(null);
            manager.completeWorkItem(workItem.getId(), results);
        } else {
            ((WorkItemImpl)workItem).setParameter(CASE_ID, (Object)caseId);
            logger.debug("Waiting for case instance {} completion before completing work item with id {}", (Object)caseId, (Object)workItem.getId());
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        String caseId = (String)workItem.getParameter(CASE_ID);
        boolean destroy = true;
        if (workItem.getParameter(DESTROY_ON_ABORT) != null) {
            destroy = Boolean.parseBoolean((String)workItem.getParameter(DESTROY_ON_ABORT));
        }
        CaseService caseService = (CaseService)ServiceRegistry.get().service("CaseService");
        try {
            if (destroy) {
                logger.debug("Case {} is going to be destroyed", (Object)caseId);
                caseService.destroyCase(caseId);
            } else {
                logger.debug("Case {} is going to be canceled", (Object)caseId);
                caseService.cancelCase(caseId);
            }
        }
        catch (CaseNotFoundException e) {
            logger.warn("Case instance {} was not found", (Object)caseId);
        }
        catch (Exception e) {
            logger.error("Unexpected error during canceling case instance {}", (Object)caseId, (Object)e);
        }
    }

    protected CaseFileInstance getCaseFile(KieSession ksession) {
        if (ksession == null) {
            logger.debug("No ksession available returning null as case file");
            return null;
        }
        Collection caseFiles = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CaseFileInstance.class));
        if (caseFiles.size() == 0) {
            logger.debug("No case file available in working memory returning null as case file");
            return null;
        }
        CaseFileInstance caseFile = (CaseFileInstance)caseFiles.iterator().next();
        return caseFile;
    }

    protected void parseParameters(WorkItem workItem, Map<String, Object> caseFileData, Map<String, OrganizationalEntity> roleAssignments, Map<String, List<String>> accessRestrictions) {
        TaskModelFactory taskModelFactory = TaskModelProvider.getFactory();
        CaseFileInstance caseFile = this.getCaseFile(this.ksession);
        for (Map.Entry entry : workItem.getParameters().entrySet()) {
            Collection caseAssignments;
            String name;
            if (((String)entry.getKey()).startsWith(DATA_PREFIX)) {
                name = ((String)entry.getKey()).replaceFirst(DATA_PREFIX, "");
                caseFileData.put(name, entry.getValue());
                logger.debug("Added {} item to case file with value {}", (Object)name, entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).startsWith(USER_ROLE_PREFIX)) {
                name = ((String)entry.getKey()).replaceFirst(USER_ROLE_PREFIX, "");
                User user = taskModelFactory.newUser((String)entry.getValue());
                if (caseFile != null) {
                    try {
                        caseAssignments = ((CaseAssignment)caseFile).getAssignments(name);
                        user = (User)caseAssignments.stream().filter(oe -> oe instanceof User).findFirst().orElseThrow(() -> new IllegalArgumentException());
                    }
                    catch (IllegalArgumentException e) {
                        logger.debug("no such role {} or there is no user found for given role name", (Object)name);
                    }
                }
                roleAssignments.put(name, (OrganizationalEntity)user);
                logger.debug("Added user {} as assignment to the role {}", entry.getValue(), entry.getKey());
                continue;
            }
            if (((String)entry.getKey()).startsWith(GROUP_ROLE_PREFIX)) {
                name = ((String)entry.getKey()).replaceFirst(GROUP_ROLE_PREFIX, "");
                Group group = taskModelFactory.newGroup((String)entry.getValue());
                if (caseFile != null) {
                    try {
                        caseAssignments = ((CaseAssignment)caseFile).getAssignments(name);
                        group = (Group)caseAssignments.stream().filter(oe -> oe instanceof Group).findFirst().orElseThrow(() -> new IllegalArgumentException());
                    }
                    catch (IllegalArgumentException e) {
                        logger.debug("no such role {} or there is no group found for given role name", (Object)name);
                    }
                }
                roleAssignments.put(name, (OrganizationalEntity)group);
                logger.debug("Added group {} as assignment to the role {}", entry.getValue(), entry.getKey());
                continue;
            }
            if (!((String)entry.getKey()).startsWith(DATA_ACCESS_PREFIX)) continue;
            name = ((String)entry.getKey()).replaceFirst(DATA_ACCESS_PREFIX, "");
            String[] roles = ((String)entry.getValue()).split(",");
            ArrayList<String> restrictedTo = new ArrayList<String>(Arrays.asList(roles));
            accessRestrictions.put(name, restrictedTo);
            logger.debug("Added access restriction for {} with following roles {}", (Object)name, restrictedTo);
        }
    }
}

