/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.concurrent;

import java.util.Date;
import org.jbpm.executor.impl.AvailableJobsExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrioritisedRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PrioritisedRunnable.class);
    private long id;
    private int priority;
    private Date fireDate;
    private AvailableJobsExecutor availableJobsExecutor;

    public PrioritisedRunnable(long id, int priority, Date fireDate, AvailableJobsExecutor availableJobsExecutor) {
        this.id = id;
        this.priority = priority;
        this.fireDate = fireDate;
        this.availableJobsExecutor = availableJobsExecutor;
    }

    @Override
    public void run() {
        try {
            logger.debug("About to execute jobs...");
            this.availableJobsExecutor.executeJob(this.id);
        }
        catch (Throwable e) {
            logger.warn("Error while executing jobs  with id {} due to {}", new Object[]{this.id, e.getMessage(), e});
        }
    }

    public long getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    public Date getFireDate() {
        return this.fireDate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrioritisedRunnable other = (PrioritisedRunnable)obj;
        return this.id == other.id;
    }
}

