/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.jpa;

import java.util.Date;
import java.util.List;
import org.jbpm.executor.impl.jpa.ExecutorJPAAuditService;
import org.jbpm.query.jpa.builder.impl.AbstractQueryBuilderImpl;
import org.jbpm.query.jpa.data.QueryWhere;
import org.kie.api.executor.ErrorInfo;
import org.kie.internal.query.ParametrizedQuery;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.runtime.manager.audit.query.ErrorInfoQueryBuilder;

public class ErrorInfoQueryBuilderImpl
extends AbstractQueryBuilderImpl<ErrorInfoQueryBuilder>
implements ErrorInfoQueryBuilder {
    private final ExecutorJPAAuditService jpaAuditService;

    public ErrorInfoQueryBuilderImpl(ExecutorJPAAuditService jpaAuditService) {
        this.jpaAuditService = jpaAuditService;
    }

    public ErrorInfoQueryBuilder message(String ... message) {
        this.addObjectParameter(QueryParameterIdentifiers.MESSAGE_LIST, "message", message);
        return this;
    }

    public ErrorInfoQueryBuilder id(long ... id) {
        this.addLongParameter(QueryParameterIdentifiers.ID_LIST, "id", id);
        return this;
    }

    public ErrorInfoQueryBuilder time(Date ... time) {
        this.addObjectParameter(QueryParameterIdentifiers.EXECUTOR_TIME_LIST, "time", time);
        return this;
    }

    public ErrorInfoQueryBuilder timeRange(Date timeMin, Date timeMax) {
        this.addRangeParameters(QueryParameterIdentifiers.EXECUTOR_TIME_LIST, "time", timeMin, timeMax);
        return this;
    }

    public ErrorInfoQueryBuilder stackTraceRegex(String ... stackTraceRegex) {
        QueryWhere queryWhere = this.getQueryWhere();
        QueryWhere.QueryCriteriaType origCriteriaType = queryWhere.getCriteriaType();
        queryWhere.setToLike();
        this.addObjectParameter(QueryParameterIdentifiers.STACK_TRACE_LIST, "stack trace regex", stackTraceRegex);
        switch (origCriteriaType) {
            case NORMAL: {
                queryWhere.setToNormal();
                break;
            }
            case RANGE: {
                queryWhere.setToRange();
                break;
            }
            case GROUP: {
                queryWhere.setToGroup();
                break;
            }
        }
        return this;
    }

    public ErrorInfoQueryBuilder ascending(ErrorInfoQueryBuilder.OrderBy field) {
        String listId = this.convertOrderByToListId(field);
        this.queryWhere.setAscending(listId);
        return this;
    }

    public ErrorInfoQueryBuilder descending(ErrorInfoQueryBuilder.OrderBy field) {
        String listId = this.convertOrderByToListId(field);
        this.queryWhere.setDescending(listId);
        return this;
    }

    private String convertOrderByToListId(ErrorInfoQueryBuilder.OrderBy field) {
        String listId;
        switch (field) {
            case id: {
                listId = QueryParameterIdentifiers.ID_LIST;
                break;
            }
            case time: {
                listId = QueryParameterIdentifiers.EXECUTOR_TIME_LIST;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown 'order-by' field: " + field.toString());
            }
        }
        return listId;
    }

    public ParametrizedQuery<ErrorInfo> build() {
        return new ParametrizedQuery<ErrorInfo>(){
            private QueryWhere queryData;
            {
                this.queryData = new QueryWhere(ErrorInfoQueryBuilderImpl.this.getQueryWhere());
            }

            public List<ErrorInfo> getResultList() {
                return ErrorInfoQueryBuilderImpl.this.jpaAuditService.queryLogs(this.queryData, org.jbpm.executor.entities.ErrorInfo.class, ErrorInfo.class);
            }
        };
    }
}

