/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml.processes;

import java.util.Map;
import org.drools.compiler.xml.XmlDumper;
import org.drools.xml.ExtensibleXmlParser;
import org.jbpm.compiler.xml.processes.AbstractNodeHandler;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.StateNode;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class StateNodeHandler
extends AbstractNodeHandler {
    protected Node createNode() {
        return new StateNode();
    }

    public Class generateNodeFor() {
        return StateNode.class;
    }

    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        StateNode stateNode = (StateNode)node;
        for (String eventType : stateNode.getActionTypes()) {
            this.handleAction((ExtendedNodeImpl)stateNode, element, eventType);
        }
    }

    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        StateNode stateNode = (StateNode)node;
        this.writeNode("state", (Node)stateNode, xmlDump, includeMeta);
        xmlDump.append(">\n");
        if (includeMeta) {
            this.writeMetaData((Node)stateNode, xmlDump);
        }
        for (String eventType : stateNode.getActionTypes()) {
            this.writeActions(eventType, stateNode.getActions(eventType), xmlDump);
        }
        this.writeTimers(stateNode.getTimers(), xmlDump);
        if (!stateNode.getConstraints().isEmpty()) {
            xmlDump.append("      <constraints>" + EOL);
            for (Map.Entry entry : stateNode.getConstraints().entrySet()) {
                String constraintString;
                int priority;
                ConnectionRef connection = (ConnectionRef)entry.getKey();
                Constraint constraint = (Constraint)entry.getValue();
                xmlDump.append("        <constraint toNodeId=\"" + connection.getNodeId() + "\" ");
                String name = constraint.getName();
                if (name != null && !"".equals(name)) {
                    xmlDump.append("name=\"" + XmlDumper.replaceIllegalChars((String)constraint.getName()) + "\" ");
                }
                if ((priority = constraint.getPriority()) != 0) {
                    xmlDump.append("priority=\"" + constraint.getPriority() + "\" ");
                }
                if ((constraintString = constraint.getConstraint()) != null) {
                    xmlDump.append(">" + XmlDumper.replaceIllegalChars((String)constraintString) + "</constraint>" + EOL);
                    continue;
                }
                xmlDump.append("/>" + EOL);
            }
            xmlDump.append("      </constraints>" + EOL);
        }
        this.endNode("state", xmlDump);
    }
}

