/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder.dialect.java;

import org.drools.compiler.builder.impl.errors.ErrorHandler;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ProcessDescr;
import org.drools.compiler.rule.builder.dialect.java.JavaDialect;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.jbpm.process.builder.ActionBuilder;
import org.jbpm.process.builder.AssignmentBuilder;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.ProcessClassBuilder;
import org.jbpm.process.builder.ProcessErrorHandler;
import org.jbpm.process.builder.ProcessInvokerErrorHandler;
import org.jbpm.process.builder.ReturnValueEvaluatorBuilder;
import org.jbpm.process.builder.dialect.ProcessDialect;
import org.jbpm.process.builder.dialect.java.JavaActionBuilder;
import org.jbpm.process.builder.dialect.java.JavaProcessClassBuilder;
import org.jbpm.process.builder.dialect.java.JavaReturnValueEvaluatorBuilder;
import org.kie.api.definition.process.Process;

public class JavaProcessDialect
implements ProcessDialect {
    private static final ActionBuilder actionBuilder = new JavaActionBuilder();
    private static final ProcessClassBuilder processClassBuilder = new JavaProcessClassBuilder();
    private static final ReturnValueEvaluatorBuilder returnValueBuilder = new JavaReturnValueEvaluatorBuilder();

    @Override
    public void addProcess(ProcessBuildContext context) {
        JavaDialect javaDialect = (JavaDialect)context.getDialectRegistry().getDialect("java");
        String processClass = processClassBuilder.buildRule(context);
        if (processClass == null) {
            return;
        }
        Process process = context.getProcess();
        ProcessDescr processDescr = context.getProcessDescr();
        javaDialect.addClassCompileTask(context.getPkg().getName() + "." + processDescr.getClassName(), (BaseDescr)processDescr, processClass, null, (ErrorHandler)new ProcessErrorHandler((BaseDescr)processDescr, process, "Process Compilation error"));
        JavaDialectRuntimeData data = (JavaDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData(javaDialect.getId());
        for (String className : context.getInvokers().keySet()) {
            Object invoker = context.getInvokerLookup(className);
            if (invoker != null) {
                data.putInvoker(className, invoker);
            }
            String text = (String)context.getInvokers().get(className);
            BaseDescr descr = context.getDescrLookup(className);
            javaDialect.addClassCompileTask(className, descr, text, null, (ErrorHandler)new ProcessInvokerErrorHandler((BaseDescr)processDescr, process, "Unable to generate action invoker."));
        }
    }

    @Override
    public ActionBuilder getActionBuilder() {
        return actionBuilder;
    }

    @Override
    public ProcessClassBuilder getProcessClassBuilder() {
        return processClassBuilder;
    }

    @Override
    public ReturnValueEvaluatorBuilder getReturnValueEvaluatorBuilder() {
        return returnValueBuilder;
    }

    @Override
    public AssignmentBuilder getAssignmentBuilder() {
        throw new UnsupportedOperationException("Java assignments not supported");
    }
}

