/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.SAXParser;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.SemanticModules;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.kie.api.definition.process.Process;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlProcessReader {
    private ExtensibleXmlParser parser;
    private final MessageFormat message = new MessageFormat("Node Info: id:{0} name:{1} \nParser message: {2}");
    private final MessageFormat messageWithProcessInfo = new MessageFormat("Process Info: id:{0}, pkg:{1}, name:{2}, version:{3} \nNode Info: id:{4} name:{5} \nParser message: {6}");
    private List<Process> processes;

    public XmlProcessReader(SemanticModules modules, ClassLoader classLoader) {
        this(modules, classLoader, null);
    }

    public XmlProcessReader(SemanticModules modules, ClassLoader classLoader, SAXParser parser) {
        this.parser = new ExtensibleXmlParser(){

            protected String buildPrintMessage(SAXParseException x) {
                return XmlProcessReader.this.processParserMessage(super.getParents(), super.getAttrs(), super.buildPrintMessage(x));
            }
        };
        if (parser != null) {
            this.parser.setParser(parser);
        }
        this.parser.setSemanticModules(modules);
        this.parser.setData((Object)new ProcessBuildData());
        this.parser.setClassLoader(classLoader);
    }

    public List<Process> read(Reader reader) throws SAXException, IOException {
        this.processes = ((ProcessBuildData)this.parser.read(reader)).getProcesses();
        return this.processes;
    }

    public List<Process> read(InputStream inputStream) throws SAXException, IOException {
        this.processes = ((ProcessBuildData)this.parser.read(inputStream)).getProcesses();
        return this.processes;
    }

    public List<Process> read(InputSource in) throws SAXException, IOException {
        this.processes = ((ProcessBuildData)this.parser.read(in)).getProcesses();
        return this.processes;
    }

    void setProcesses(List<Process> processes) {
        this.processes = processes;
    }

    public List<Process> getProcess() {
        return this.processes;
    }

    public ProcessBuildData getProcessBuildData() {
        return (ProcessBuildData)this.parser.getData();
    }

    protected String processParserMessage(Collection<Object> parents, Attributes attr, String errorMessage) {
        String nodeId = attr == null || attr.getValue("id") == null ? "" : attr.getValue("id");
        String nodeName = attr == null || attr.getValue("name") == null ? "" : attr.getValue("name");
        for (Object parent : parents) {
            if (parent == null || !(parent instanceof RuleFlowProcess)) continue;
            RuleFlowProcess process = (RuleFlowProcess)parent;
            return this.messageWithProcessInfo.format(new Object[]{process.getId(), process.getPackageName(), process.getName(), process.getVersion(), nodeId, nodeName, errorMessage});
        }
        return this.message.format(new Object[]{nodeId, nodeName, errorMessage});
    }
}

