/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.service;

import java.util.Date;
import java.util.List;
import org.jbpm.services.task.audit.commands.TaskVariableQueryCommand;
import org.jbpm.services.task.audit.impl.model.TaskVariableImpl;
import org.jbpm.services.task.audit.service.AbstractTaskAuditQueryBuilderImpl;
import org.jbpm.services.task.audit.service.TaskJPAAuditService;
import org.jbpm.services.task.commands.TaskCommand;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.TaskVariable;
import org.kie.internal.task.query.TaskVariableQueryBuilder;

public class TaskVariableQueryBuilderImpl
extends AbstractTaskAuditQueryBuilderImpl<TaskVariableQueryBuilder, TaskVariable>
implements TaskVariableQueryBuilder {
    public TaskVariableQueryBuilderImpl(InternalTaskService taskService) {
        super(taskService);
    }

    public TaskVariableQueryBuilderImpl(TaskJPAAuditService jpaService) {
        super(jpaService);
    }

    public TaskVariableQueryBuilder taskId(long ... taskId) {
        this.addLongParameter(QueryParameterIdentifiers.TASK_ID_LIST, "task id", taskId);
        return this;
    }

    public TaskVariableQueryBuilder taskIdRange(Long taskIdMin, Long taskIdMax) {
        this.addRangeParameters(QueryParameterIdentifiers.TASK_ID_LIST, "task id range", taskIdMin, taskIdMax);
        return this;
    }

    public TaskVariableQueryBuilder id(long ... id) {
        this.addLongParameter(QueryParameterIdentifiers.ID_LIST, "task id", id);
        return this;
    }

    public TaskVariableQueryBuilder modificationDate(Date ... modDate) {
        this.addObjectParameter(QueryParameterIdentifiers.DATE_LIST, "log time", modDate);
        return this;
    }

    public TaskVariableQueryBuilder modificationDateRange(Date modDateMin, Date modDateMax) {
        this.addRangeParameters(QueryParameterIdentifiers.DATE_LIST, "log time range", modDateMin, modDateMax);
        return this;
    }

    public TaskVariableQueryBuilder name(String ... name) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_VARIABLE_NAME_ID_LIST, "name", name);
        return this;
    }

    public TaskVariableQueryBuilder value(String ... value) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_VARIABLE_VALUE_ID_LIST, "value", value);
        return this;
    }

    public TaskVariableQueryBuilder type(TaskVariable.VariableType ... type) {
        this.addObjectParameter(QueryParameterIdentifiers.TYPE_LIST, "task variable type", type);
        return this;
    }

    public TaskVariableQueryBuilder ascending(TaskVariableQueryBuilder.OrderBy field) {
        String listId = this.convertOrderByToListId(field);
        this.queryWhere.setAscending(listId);
        return this;
    }

    public TaskVariableQueryBuilder descending(TaskVariableQueryBuilder.OrderBy field) {
        String listId = this.convertOrderByToListId(field);
        this.queryWhere.setDescending(listId);
        return this;
    }

    private String convertOrderByToListId(TaskVariableQueryBuilder.OrderBy field) {
        String listId;
        switch (field) {
            case id: {
                listId = QueryParameterIdentifiers.ID_LIST;
                break;
            }
            case taskId: {
                listId = QueryParameterIdentifiers.TASK_ID_LIST;
                break;
            }
            case modificationDate: {
                listId = QueryParameterIdentifiers.DATE_LIST;
                break;
            }
            case processInstanceId: {
                listId = QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown 'order-by' field: " + field.toString());
            }
        }
        return listId;
    }

    @Override
    protected Class<TaskVariableImpl> getQueryType() {
        return TaskVariableImpl.class;
    }

    @Override
    protected Class<TaskVariable> getResultType() {
        return TaskVariable.class;
    }

    @Override
    protected TaskCommand<List<TaskVariable>> getCommand() {
        return new TaskVariableQueryCommand(this.queryWhere);
    }
}

