/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.assignment.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jbpm.services.task.assignment.UserTaskLoad;
import org.jbpm.services.task.assignment.impl.AbstractLoadCalculator;
import org.jbpm.services.task.assignment.impl.TaskAverageDuration;
import org.jbpm.services.task.assignment.impl.TaskInfo;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotalCompletionTimeLoadCalculator
extends AbstractLoadCalculator {
    private static final Logger logger = LoggerFactory.getLogger(TotalCompletionTimeLoadCalculator.class);
    private static final String IDENTIFIER = "TotalCompletionTime";
    private static Long timeToLive;
    private static Cache<String, Double> taskDurations;
    private static String TASK_LIST_QUERY;
    private static String TASK_AVG_DURATION;
    private Function<TaskInfo, String> getTaskKey = ti -> ti.getProcessId() + "_" + ti.getDeploymentId() + "_" + ti.getTaskName();

    public TotalCompletionTimeLoadCalculator() {
        super(IDENTIFIER);
    }

    private synchronized List<TaskInfo> getUserActiveTaskLists(List<User> users, org.kie.api.task.TaskContext context) {
        TaskPersistenceContext taskContext = ((TaskContext)context).getPersistenceContext();
        HashMap<String, List<User>> params = new HashMap<String, List<User>>();
        params.put("owners", users);
        return (List)taskContext.queryStringWithParametersInTransaction(TASK_LIST_QUERY, params, ClassUtil.castClass(List.class));
    }

    public UserTaskLoad getUserTaskLoad(User user, org.kie.api.task.TaskContext context) {
        UserTaskLoad load = new UserTaskLoad(IDENTIFIER, user);
        List<User> users = Arrays.asList(user);
        List<TaskInfo> userTasks = this.getUserActiveTaskLists(users, context);
        if (userTasks == null || userTasks.isEmpty()) {
            load.setCalculatedLoad(new Double(0.0));
        } else {
            Double loadForUser = new Double(0.0);
            for (TaskInfo ti : userTasks) {
                loadForUser = loadForUser + this.getTaskDuration(ti, context) * (double)ti.getCount();
            }
            load.setCalculatedLoad(loadForUser);
        }
        return load;
    }

    public Collection<UserTaskLoad> getUserTaskLoads(List<User> users, org.kie.api.task.TaskContext context) {
        ArrayList<UserTaskLoad> loads = new ArrayList<UserTaskLoad>();
        List<TaskInfo> usersTasks = this.getUserActiveTaskLists(users, context);
        if (usersTasks == null || usersTasks.isEmpty()) {
            users.forEach(u -> loads.add(new UserTaskLoad(IDENTIFIER, u, new Double(0.0))));
        } else {
            users.forEach(u -> {
                Double loadForUser = new Double(0.0);
                List tasksForUser = usersTasks.stream().filter(ut -> ut.getOwnerId().equals(u.getId())).collect(Collectors.toList());
                for (TaskInfo ti : tasksForUser) {
                    loadForUser = loadForUser + this.getTaskDuration(ti, context) * (double)ti.getCount();
                }
                UserTaskLoad load = new UserTaskLoad(IDENTIFIER, u, loadForUser);
                logger.debug("User load: {}", (Object)load);
                loads.add(load);
            });
        }
        return loads;
    }

    public static Long getTimeToLive() {
        return timeToLive;
    }

    private Double calculateAverageDuration(org.kie.api.task.TaskContext context, String processId, String deploymentId, String name) {
        Double avgDur = new Double(1.0);
        TaskPersistenceContext taskContext = ((TaskContext)context).getPersistenceContext();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("procid", processId);
        params.put("depid", deploymentId);
        params.put("taskname", name);
        List durations = (List)taskContext.queryStringWithParametersInTransaction(TASK_AVG_DURATION, params, ClassUtil.castClass(List.class));
        if (durations != null && !durations.isEmpty()) {
            avgDur = ((TaskAverageDuration)durations.get(0)).getAverageDuration();
            logger.debug("Retrieved duration is {}", (Object)avgDur);
        }
        return avgDur;
    }

    private synchronized Double getTaskDuration(TaskInfo taskInfo, org.kie.api.task.TaskContext taskContext) {
        Double duration = new Double(1.0);
        String taskKey = this.getTaskKey.apply(taskInfo);
        duration = (Double)taskDurations.getIfPresent((Object)taskKey);
        if (duration == null) {
            duration = this.calculateAverageDuration(taskContext, taskInfo.getProcessId(), taskInfo.getDeploymentId(), taskInfo.getTaskName());
            taskDurations.put((Object)taskKey, (Object)duration);
            logger.debug("Newly calculated duration of {} is {}", (Object)taskKey, taskDurations.asMap().get(taskKey));
        }
        return duration;
    }

    static {
        TASK_LIST_QUERY = "select new org.jbpm.services.task.assignment.impl.TaskInfo(t.taskData.actualOwner.id, t.name, t.taskData.processId, t.taskData.deploymentId, count(t)) from TaskImpl t where t.taskData.actualOwner in (:owners) and t.taskData.status in ('Reserved', 'InProgress', 'Suspended') group by t.taskData.actualOwner, t.name, t.taskData.processId, t.taskData.deploymentId";
        TASK_AVG_DURATION = "select new org.jbpm.services.task.assignment.impl.TaskAverageDuration(avg(bts.duration),t.taskData.deploymentId,t.taskData.processId,bts.taskName) from BAMTaskSummaryImpl bts left join TaskImpl t on (bts.taskId = t.id) where (bts.duration is not null) and t.taskData.processId = :procid and t.taskData.deploymentId = :depid and t.name = :taskname group by t.taskData.deploymentId, t.taskData.processId, t.name";
        timeToLive = Long.valueOf(System.getProperty("org.jbpm.services.task.assignment.taskduration.timetolive", "1800000"));
        taskDurations = CacheBuilder.newBuilder().expireAfterWrite(timeToLive.longValue(), TimeUnit.MILLISECONDS).build();
    }
}

