/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.jms;

import com.thoughtworks.xstream.XStream;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import org.jbpm.services.task.audit.impl.model.AuditTaskData;
import org.jbpm.services.task.audit.impl.model.AuditTaskImpl;
import org.jbpm.services.task.audit.impl.model.TaskEventImpl;
import org.jbpm.services.task.audit.impl.model.TaskVariableImpl;
import org.kie.internal.task.api.TaskVariable;
import org.kie.soup.xstream.XStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTaskLifeCycleEventReceiver
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(AsyncTaskLifeCycleEventReceiver.class);
    private EntityManagerFactory entityManagerFactory;
    private XStream xstream;

    public AsyncTaskLifeCycleEventReceiver(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        this.initXStream();
    }

    private void initXStream() {
        if (this.xstream == null) {
            this.xstream = XStreamUtils.createTrustingXStream();
            String[] voidDeny = new String[]{"void.class", "Void.class"};
            this.xstream.denyTypes(voidDeny);
        }
    }

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            EntityManager em = this.getEntityManager();
            TextMessage textMessage = (TextMessage)message;
            try {
                String messageContent = textMessage.getText();
                AuditTaskData auditTaskData = (AuditTaskData)this.xstream.fromXML(messageContent);
                if (auditTaskData.getAuditTask() != null) {
                    AuditTaskImpl updatedTask = auditTaskData.getAuditTask();
                    AuditTaskImpl existingTask = this.getAuditTask(em, updatedTask.getTaskId());
                    if (existingTask == null) {
                        em.persist(updatedTask);
                    } else {
                        existingTask.setActivationTime(updatedTask.getActivationTime());
                        existingTask.setActualOwner(updatedTask.getActualOwner());
                        existingTask.setCreatedBy(updatedTask.getCreatedBy());
                        existingTask.setCreatedOn(updatedTask.getCreatedOn());
                        existingTask.setDeploymentId(updatedTask.getDeploymentId());
                        existingTask.setDescription(updatedTask.getDescription());
                        existingTask.setDueDate(updatedTask.getDueDate());
                        existingTask.setLastModificationDate(updatedTask.getLastModificationDate());
                        existingTask.setName(updatedTask.getName());
                        existingTask.setParentId(updatedTask.getParentId());
                        existingTask.setPriority(updatedTask.getPriority());
                        existingTask.setProcessId(updatedTask.getProcessId());
                        existingTask.setProcessInstanceId(updatedTask.getProcessInstanceId());
                        existingTask.setProcessSessionId(updatedTask.getProcessSessionId());
                        existingTask.setStatus(updatedTask.getStatus());
                        existingTask.setTaskId(updatedTask.getTaskId());
                        existingTask.setWorkItemId(updatedTask.getWorkItemId());
                        em.merge((Object)existingTask);
                    }
                }
                if (auditTaskData.getTaskEvents() != null) {
                    for (TaskEventImpl taskEvent : auditTaskData.getTaskEvents()) {
                        em.persist((Object)taskEvent);
                    }
                }
                if (auditTaskData.getTaskInputs() != null) {
                    for (TaskVariableImpl variable : auditTaskData.getTaskInputs()) {
                        em.persist((Object)variable);
                    }
                }
                if (auditTaskData.getTaskOutputs() != null) {
                    int removed = em.createNamedQuery("DeleteTaskVariableForTask").setParameter("taskId", (Object)auditTaskData.getAuditTask().getTaskId()).setParameter("type", (Object)TaskVariable.VariableType.OUTPUT).executeUpdate();
                    logger.debug("Deleted {} output variables logs for task id {}", (Object)removed, (Object)auditTaskData.getAuditTask().getTaskId());
                    for (TaskVariableImpl variable : auditTaskData.getTaskOutputs()) {
                        em.persist((Object)variable);
                    }
                }
            }
            catch (JMSException e) {
                logger.error("Unexpected JMS error while processing task logs");
                throw new RuntimeException("Exception when receiving audit event event", e);
            }
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public EntityManager getEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    protected AuditTaskImpl getAuditTask(EntityManager em, long taskId) {
        try {
            AuditTaskImpl auditTaskImpl = (AuditTaskImpl)em.createNamedQuery("getAuditTaskById").setParameter("taskId", (Object)taskId).getSingleResult();
            return auditTaskImpl;
        }
        catch (NoResultException | NonUniqueResultException e) {
            return null;
        }
    }
}

