/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.kie.internal.task.api.model.InternalContent;

@Entity
@Table(name="Content")
@SequenceGenerator(name="contentIdSeq", sequenceName="CONTENT_ID_SEQ", allocationSize=1)
public class ContentImpl
implements InternalContent {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="contentIdSeq")
    private Long id = 0L;
    @Lob
    @Column(length=0x7FFFFFFF)
    private byte[] content;

    public ContentImpl() {
    }

    public ContentImpl(byte[] content) {
        this.content = content;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeInt(this.content.length);
        out.write(this.content);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.content = new byte[in.readInt()];
        in.readFully(this.content);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.content);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentImpl)) {
            return false;
        }
        ContentImpl other = (ContentImpl)obj;
        return Arrays.equals(this.content, other.content);
    }
}

