/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.kie.services.impl.admin.commands.CancelNodeInstanceCommand;
import org.jbpm.kie.services.impl.admin.commands.ListNodesCommand;
import org.jbpm.kie.services.impl.admin.commands.ListTimersCommand;
import org.jbpm.kie.services.impl.admin.commands.RetriggerNodeInstanceCommand;
import org.jbpm.kie.services.impl.admin.commands.TriggerNodeCommand;
import org.jbpm.process.instance.command.RelativeUpdateTimerCommand;
import org.jbpm.process.instance.command.UpdateTimerCommand;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.services.api.NodeInstanceNotFoundException;
import org.jbpm.services.api.NodeNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.admin.ExecutionErrorNotFoundException;
import org.jbpm.services.api.admin.ProcessInstanceAdminService;
import org.jbpm.services.api.admin.ProcessNode;
import org.jbpm.services.api.admin.TimerInstance;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.service.ServiceRegistry;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.runtime.error.ExecutionError;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class ProcessInstanceAdminServiceImpl
implements ProcessInstanceAdminService {
    private ProcessService processService;
    private RuntimeDataService runtimeDataService;
    private IdentityProvider identityProvider;
    private TransactionalCommandService commandService;

    public ProcessInstanceAdminServiceImpl() {
        ServiceRegistry.get().register(ProcessInstanceAdminService.class.getSimpleName(), (Object)this);
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        this.runtimeDataService = runtimeDataService;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public Collection<ProcessNode> getProcessNodes(long processInstanceId) throws ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " not found");
        }
        Collection nodes = (Collection)this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new ListNodesCommand(processInstanceId));
        return nodes;
    }

    public void cancelNodeInstance(long processInstanceId, long nodeInstanceId) throws NodeInstanceNotFoundException, ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " not found");
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new CancelNodeInstanceCommand(processInstanceId, nodeInstanceId));
    }

    public void retriggerNodeInstance(long processInstanceId, long nodeInstanceId) throws NodeInstanceNotFoundException, ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " not found");
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new RetriggerNodeInstanceCommand(processInstanceId, nodeInstanceId));
    }

    public void updateTimer(long processInstanceId, long timerId, long delay, long period, int repeatLimit) throws NodeInstanceNotFoundException, ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " not found");
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new UpdateTimerCommand(processInstanceId, timerId, delay, period, repeatLimit));
    }

    public void updateTimerRelative(long processInstanceId, long timerId, long delay, long period, int repeatLimit) throws NodeInstanceNotFoundException, ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " not found");
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new RelativeUpdateTimerCommand(processInstanceId, timerId, delay, period, repeatLimit));
    }

    public Collection<TimerInstance> getTimerInstances(long processInstanceId) throws ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " not found");
        }
        Collection timers = (Collection)this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new ListTimersCommand(processInstanceId));
        return timers;
    }

    public void triggerNode(long processInstanceId, long nodeId) throws NodeNotFoundException, ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " not found");
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new TriggerNodeCommand(processInstanceId, nodeId));
    }

    public Collection<NodeInstanceDesc> getActiveNodeInstances(long processInstanceId) throws ProcessInstanceNotFoundException {
        return this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext(Integer.valueOf(0), Integer.valueOf(1000)));
    }

    public void acknowledgeError(String ... errorId) throws ExecutionErrorNotFoundException {
        for (String error : errorId) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("errorId", error);
            params.put("ack", new Short("0"));
            List execErrors = (List)this.commandService.execute((Command)new QueryNameCommand("getErrorById", params));
            if (execErrors.isEmpty()) {
                throw new ExecutionErrorNotFoundException("No execution error found for id " + errorId);
            }
            ExecutionError errorInstance = (ExecutionError)execErrors.get(0);
            RuntimeManager runtimeManager = RuntimeManagerRegistry.get().getManager(errorInstance.getDeploymentId());
            if (runtimeManager == null) continue;
            ((AbstractRuntimeManager)runtimeManager).getExecutionErrorManager().getStorage().acknowledge(this.identityProvider.getName(), new String[]{errorInstance.getErrorId()});
        }
    }

    public ExecutionError getError(String errorId) throws ExecutionErrorNotFoundException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("errorId", errorId);
        List execErrors = (List)this.commandService.execute((Command)new QueryNameCommand("getErrorByIdSkipAckCheck", params));
        if (execErrors.isEmpty()) {
            throw new ExecutionErrorNotFoundException("No execution error found for id " + errorId);
        }
        ExecutionError error = (ExecutionError)execErrors.get(0);
        return error;
    }

    public List<ExecutionError> getErrors(boolean includeAcknowledged, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ack", this.getAckMode(includeAcknowledged));
        this.applyQueryContext(params, queryContext);
        List execErrors = (List)this.commandService.execute((Command)new QueryNameCommand("getErrors", params));
        return execErrors;
    }

    public List<ExecutionError> getErrorsByProcessId(String deploymentId, String processId, boolean includeAcknowledged, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deploymentId", deploymentId);
        params.put("processId", processId);
        params.put("ack", this.getAckMode(includeAcknowledged));
        this.applyQueryContext(params, queryContext);
        List execErrors = (List)this.commandService.execute((Command)new QueryNameCommand("getErrorsByProcessId", params));
        return execErrors;
    }

    public List<ExecutionError> getErrorsByProcessInstanceId(long processInstanceId, boolean includeAcknowledged, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processInstanceId", processInstanceId);
        params.put("ack", this.getAckMode(includeAcknowledged));
        this.applyQueryContext(params, queryContext);
        List execErrors = (List)this.commandService.execute((Command)new QueryNameCommand("getErrorsByProcessInstanceId", params));
        return execErrors;
    }

    public List<ExecutionError> getErrorsByProcessInstanceId(long processInstanceId, String nodeName, boolean includeAcknowledged, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processInstanceId", processInstanceId);
        params.put("nodeName", nodeName);
        params.put("ack", this.getAckMode(includeAcknowledged));
        this.applyQueryContext(params, queryContext);
        List execErrors = (List)this.commandService.execute((Command)new QueryNameCommand("getErrorsByProcessInstanceIdNodeName", params));
        return execErrors;
    }

    protected void applyQueryContext(Map<String, Object> params, QueryContext queryContext) {
        if (queryContext != null) {
            params.put("firstResult", queryContext.getOffset());
            params.put("maxResults", queryContext.getCount());
            if (queryContext.getOrderBy() != null && !queryContext.getOrderBy().isEmpty()) {
                params.put("orderby", queryContext.getOrderBy());
                if (queryContext.isAscending().booleanValue()) {
                    params.put("asc", "true");
                } else {
                    params.put("desc", "true");
                }
            }
        }
    }

    protected List<Short> getAckMode(boolean includeAcknowledged) {
        ArrayList<Short> ackMode = new ArrayList<Short>();
        ackMode.add(new Short("0"));
        if (includeAcknowledged) {
            ackMode.add(new Short("1"));
        }
        return ackMode;
    }
}

