/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.utils;

import javax.persistence.EntityManagerFactory;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.kie.services.impl.FormManagerServiceImpl;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.ProcessServiceImpl;
import org.jbpm.kie.services.impl.RuntimeDataServiceImpl;
import org.jbpm.kie.services.impl.UserTaskServiceImpl;
import org.jbpm.kie.services.impl.admin.ProcessInstanceAdminServiceImpl;
import org.jbpm.kie.services.impl.bpmn2.BPMN2DataServiceImpl;
import org.jbpm.kie.services.impl.query.QueryServiceImpl;
import org.jbpm.runtime.manager.impl.RuntimeManagerFactoryImpl;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.admin.ProcessInstanceAdminService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.api.utils.KieServiceConfigurator;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.audit.TaskAuditServiceFactory;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.identity.IdentityProvider;

public class DefaultKieServiceConfigurator
implements KieServiceConfigurator {
    protected EntityManagerFactory emf;
    protected DeploymentService deploymentService;
    protected DefinitionService bpmn2Service;
    protected RuntimeDataService runtimeDataService;
    protected ProcessService processService;
    protected UserTaskService userTaskService;
    protected QueryService queryService;
    protected ProcessInstanceAdminService processAdminService;
    protected IdentityProvider identityProvider;
    protected UserGroupCallback userGroupCallback;
    protected FormManagerService formManagerService;

    public void configureServices(String puName, IdentityProvider identityProvider, UserGroupCallback userGroupCallback) {
        this.emf = EntityManagerFactoryManager.get().getOrCreate(puName);
        this.identityProvider = identityProvider;
        this.userGroupCallback = userGroupCallback;
        this.formManagerService = new FormManagerServiceImpl();
        this.bpmn2Service = new BPMN2DataServiceImpl();
        this.queryService = new QueryServiceImpl();
        ((QueryServiceImpl)this.queryService).setIdentityProvider(identityProvider);
        ((QueryServiceImpl)this.queryService).setUserGroupCallback(userGroupCallback);
        ((QueryServiceImpl)this.queryService).setCommandService(new TransactionalCommandService(this.emf));
        ((QueryServiceImpl)this.queryService).init();
        this.deploymentService = new KModuleDeploymentService();
        ((KModuleDeploymentService)this.deploymentService).setBpmn2Service(this.bpmn2Service);
        ((KModuleDeploymentService)this.deploymentService).setEmf(this.emf);
        ((KModuleDeploymentService)this.deploymentService).setIdentityProvider(identityProvider);
        ((KModuleDeploymentService)this.deploymentService).setManagerFactory((RuntimeManagerFactory)new RuntimeManagerFactoryImpl());
        ((KModuleDeploymentService)this.deploymentService).setFormManagerService(this.formManagerService);
        TaskService taskService = HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(this.emf).getTaskService();
        this.runtimeDataService = new RuntimeDataServiceImpl();
        ((RuntimeDataServiceImpl)this.runtimeDataService).setCommandService(new TransactionalCommandService(this.emf));
        ((RuntimeDataServiceImpl)this.runtimeDataService).setIdentityProvider(identityProvider);
        ((RuntimeDataServiceImpl)this.runtimeDataService).setTaskService(taskService);
        ((RuntimeDataServiceImpl)this.runtimeDataService).setTaskAuditService(TaskAuditServiceFactory.newTaskAuditServiceConfigurator().setTaskService(taskService).getTaskAuditService());
        ((KModuleDeploymentService)this.deploymentService).setRuntimeDataService(this.runtimeDataService);
        ((KModuleDeploymentService)this.deploymentService).addListener((RuntimeDataServiceImpl)this.runtimeDataService);
        ((KModuleDeploymentService)this.deploymentService).addListener((BPMN2DataServiceImpl)this.bpmn2Service);
        ((KModuleDeploymentService)this.deploymentService).addListener((QueryServiceImpl)this.queryService);
        this.processService = new ProcessServiceImpl();
        ((ProcessServiceImpl)this.processService).setDataService(this.runtimeDataService);
        ((ProcessServiceImpl)this.processService).setDeploymentService(this.deploymentService);
        this.userTaskService = new UserTaskServiceImpl();
        ((UserTaskServiceImpl)this.userTaskService).setDataService(this.runtimeDataService);
        ((UserTaskServiceImpl)this.userTaskService).setDeploymentService(this.deploymentService);
        this.processAdminService = new ProcessInstanceAdminServiceImpl();
        ((ProcessInstanceAdminServiceImpl)this.processAdminService).setProcessService(this.processService);
        ((ProcessInstanceAdminServiceImpl)this.processAdminService).setRuntimeDataService(this.runtimeDataService);
        ((ProcessInstanceAdminServiceImpl)this.processAdminService).setCommandService(new TransactionalCommandService(this.emf));
        ((ProcessInstanceAdminServiceImpl)this.processAdminService).setIdentityProvider(identityProvider);
    }

    public DeploymentUnit createDeploymentUnit(String groupId, String artifactid, String version) {
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit(groupId, artifactid, version);
        return deploymentUnit;
    }

    public void close() {
        if (this.emf != null && this.emf.isOpen()) {
            this.emf.close();
        }
    }

    public EntityManagerFactory getEmf() {
        return this.emf;
    }

    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public DefinitionService getBpmn2Service() {
        return this.bpmn2Service;
    }

    public RuntimeDataService getRuntimeDataService() {
        return this.runtimeDataService;
    }

    public ProcessService getProcessService() {
        return this.processService;
    }

    public UserTaskService getUserTaskService() {
        return this.userTaskService;
    }

    public QueryService getQueryService() {
        return this.queryService;
    }

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    public UserGroupCallback getUserGroupCallback() {
        return this.userGroupCallback;
    }

    public ProcessInstanceAdminService getProcessAdminService() {
        return this.processAdminService;
    }

    public FormManagerService getFormManagerService() {
        return this.formManagerService;
    }
}

