/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.preprocessor;

import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.def.DataSetPreprocessor;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserTasksPreprocessor
implements DataSetPreprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTasksPreprocessor.class);
    private DataSetMetadata metadata;

    public UserTasksPreprocessor(DataSetMetadata metadata) {
        this.metadata = metadata;
    }

    public void preprocess(DataSetLookup lookup) {
        if (lookup.getLastGroupOp() == null) {
            LOGGER.debug("There is no group operation, adding one to eliminate duplicated tasks");
            DataSetGroup gOp = new DataSetGroup();
            gOp.setColumnGroup(new ColumnGroup("TASKID", "TASKID"));
            for (String columnId : this.metadata.getColumnIds()) {
                gOp.addGroupFunction(new GroupFunction[]{new GroupFunction(columnId, columnId, null)});
            }
            LOGGER.debug("Group operation {} added to dataset lookup {}", (Object)gOp, (Object)lookup);
            lookup.addOperation(new DataSetOp[]{gOp});
        }
    }
}

