/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.timer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.command.CommandService;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.SelfRemovalJob;
import org.drools.core.time.SelfRemovalJobContext;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.core.time.impl.TimerJobInstance;
import org.jbpm.persistence.timer.GlobalJpaTimerJobInstance;
import org.jbpm.process.instance.timer.TimerManager;

public class GlobalJPATimerJobFactoryManager
implements TimerJobFactoryManager {
    private Map<Long, TimerJobInstance> emptyStore = new HashMap<Long, TimerJobInstance>();
    private CommandService commandService;
    private Map<Long, Map<Long, TimerJobInstance>> timerInstances = new ConcurrentHashMap<Long, Map<Long, TimerJobInstance>>();
    private Map<Long, TimerJobInstance> singleTimerInstances = new ConcurrentHashMap<Long, TimerJobInstance>();

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public TimerJobInstance createTimerJobInstance(Job job, JobContext ctx, Trigger trigger, JobHandle handle, InternalSchedulerService scheduler) {
        Map<Long, TimerJobInstance> instances;
        long sessionId = -1L;
        if (ctx instanceof TimerManager.ProcessJobContext && (instances = this.timerInstances.get(sessionId = ((TimerManager.ProcessJobContext)ctx).getSessionId().longValue())) == null) {
            instances = new ConcurrentHashMap<Long, TimerJobInstance>();
            this.timerInstances.put(sessionId, instances);
        }
        ctx.setJobHandle(handle);
        GlobalJpaTimerJobInstance jobInstance = new GlobalJpaTimerJobInstance((Job)new SelfRemovalJob(job), (JobContext)new SelfRemovalJobContext(ctx, this.emptyStore), trigger, handle, scheduler);
        return jobInstance;
    }

    public void addTimerJobInstance(TimerJobInstance instance) {
        JobContext ctx = instance.getJobContext();
        if (ctx instanceof SelfRemovalJobContext) {
            ctx = ((SelfRemovalJobContext)ctx).getJobContext();
        }
        Map<Long, TimerJobInstance> instances = null;
        if (ctx instanceof TimerManager.ProcessJobContext) {
            long sessionId = ((TimerManager.ProcessJobContext)ctx).getSessionId();
            instances = this.timerInstances.get(sessionId);
            if (instances == null) {
                instances = new ConcurrentHashMap<Long, TimerJobInstance>();
                this.timerInstances.put(sessionId, instances);
            }
        } else {
            instances = this.singleTimerInstances;
        }
        instances.put(instance.getJobHandle().getId(), instance);
    }

    public void removeTimerJobInstance(TimerJobInstance instance) {
        JobContext ctx = instance.getJobContext();
        if (ctx instanceof SelfRemovalJobContext) {
            ctx = ((SelfRemovalJobContext)ctx).getJobContext();
        }
        Map<Long, TimerJobInstance> instances = null;
        if (ctx instanceof TimerManager.ProcessJobContext) {
            long sessionId = ((TimerManager.ProcessJobContext)ctx).getSessionId();
            instances = this.timerInstances.get(sessionId);
            if (instances == null) {
                instances = new ConcurrentHashMap<Long, TimerJobInstance>();
                this.timerInstances.put(sessionId, instances);
            }
        } else {
            instances = this.singleTimerInstances;
        }
        instances.remove(instance.getJobHandle().getId());
    }

    public Collection<TimerJobInstance> getTimerJobInstances() {
        return this.singleTimerInstances.values();
    }

    public Collection<TimerJobInstance> getTimerJobInstances(Integer sessionId) {
        Map<Long, TimerJobInstance> sessionTimerJobs = this.timerInstances.get(sessionId);
        if (sessionTimerJobs == null) {
            return Collections.EMPTY_LIST;
        }
        return sessionTimerJobs.values();
    }

    public CommandService getCommandService() {
        return this.commandService;
    }
}

