/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.email;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jbpm.process.workitem.email.Connection;
import org.jbpm.process.workitem.email.Email;
import org.jbpm.process.workitem.email.Message;
import org.jbpm.process.workitem.email.Recipient;

public class SendHtml {
    private static final String MAIL_JNDI_KEY = System.getProperty("org.kie.mail.session", "mail/jbpmMailSession");
    private static boolean debug = Boolean.parseBoolean(System.getProperty("org.kie.mail.debug", "false"));

    public static void sendHtml(Email email) {
        SendHtml.sendHtml(email, email.getConnection());
    }

    public static void sendHtml(Email email, boolean debug) {
        SendHtml.sendHtml(email, email.getConnection(), debug);
    }

    public static void sendHtml(Email email, Connection connection) {
        SendHtml.sendHtml(email, connection, debug);
    }

    public static void sendHtml(Email email, Connection connection, boolean debug) {
        Session session = SendHtml.getSession(connection);
        session.setDebug(debug);
        try {
            javax.mail.Message msg = SendHtml.fillMessage(email, session);
            try (Transport t = null;){
                if (connection != null) {
                    t = session.getTransport("smtp");
                    int port = Integer.parseInt(connection.getPort());
                    String mailhost = connection.getHost();
                    String username = connection.getUserName();
                    String password = connection.getPassword();
                    t.connect(mailhost, port, username, password);
                    t.sendMessage(msg, msg.getAllRecipients());
                } else {
                    Transport.send((javax.mail.Message)msg, (Address[])msg.getAllRecipients());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to send email", e);
        }
    }

    private static javax.mail.Message fillMessage(Email email, Session session) {
        Message message = email.getMessage();
        String subject = message.getSubject();
        String from = message.getFrom();
        String replyTo = message.getReplyTo();
        String displayName = message.getDisplayName();
        String mailer = "sendhtml";
        if (from == null) {
            throw new RuntimeException("Email must have 'from' address");
        }
        if (replyTo == null) {
            replyTo = from;
        }
        MimeMessage msg = null;
        try {
            msg = new MimeMessage(session);
            if (null != displayName) {
                msg.setFrom((Address)new InternetAddress(from, displayName));
            } else {
                msg.setFrom((Address)new InternetAddress(from));
            }
            msg.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(replyTo)});
            for (Recipient recipient : message.getRecipients().getRecipients()) {
                Message.RecipientType type = null;
                if ("To".equals(recipient.getType())) {
                    type = Message.RecipientType.TO;
                } else if ("Cc".equals(recipient.getType())) {
                    type = Message.RecipientType.CC;
                } else if ("Bcc".equals(recipient.getType())) {
                    type = Message.RecipientType.BCC;
                } else {
                    throw new RuntimeException("Unable to determine recipient type");
                }
                msg.addRecipients(type, (Address[])InternetAddress.parse((String)recipient.getEmail(), (boolean)false));
            }
            if (message.hasAttachment()) {
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(message.getBody(), "text/html")));
                multipart.addBodyPart((BodyPart)messageBodyPart);
                List<String> attachments = message.getAttachments();
                for (String attachment : attachments) {
                    MimeBodyPart attachementBodyPart = new MimeBodyPart();
                    URL attachmentUrl = SendHtml.getAttachemntURL(attachment);
                    String contentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(attachmentUrl.getFile());
                    attachementBodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(attachmentUrl.openStream(), contentType)));
                    String fileName = new File(attachmentUrl.getFile()).getName();
                    attachementBodyPart.setFileName(fileName);
                    attachementBodyPart.setContentID("<" + fileName + ">");
                    multipart.addBodyPart((BodyPart)attachementBodyPart);
                }
                msg.setContent((Multipart)multipart);
            } else {
                msg.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(message.getBody(), "text/html")));
            }
            msg.setSubject(subject);
            msg.setHeader("X-Mailer", mailer);
            msg.setSentDate(new Date());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to send email", e);
        }
        return msg;
    }

    public static void collect(String body, javax.mail.Message msg) throws MessagingException, IOException {
        StringBuffer sb = new StringBuffer();
        sb.append(body);
    }

    private static Session getSession(Connection connection) {
        Session session = null;
        try {
            session = (Session)InitialContext.doLookup(MAIL_JNDI_KEY);
        }
        catch (NamingException e1) {
            if (connection == null) {
                throw new RuntimeException("Connection details are not given and mail session was not found in JNDI - " + MAIL_JNDI_KEY, e1);
            }
            String username = connection.getUserName();
            String password = connection.getPassword();
            Properties properties = new Properties();
            properties.setProperty("mail.smtp.host", connection.getHost());
            properties.setProperty("mail.smtp.port", connection.getPort());
            if (connection.getStartTls() != null && connection.getStartTls().booleanValue()) {
                properties.put("mail.smtp.starttls.enable", "true");
            }
            if (username != null) {
                properties.setProperty("mail.smtp.submitter", username);
                if (password != null) {
                    Authenticator authenticator = new Authenticator(username, password);
                    properties.setProperty("mail.smtp.auth", "true");
                    session = Session.getInstance((Properties)properties, (javax.mail.Authenticator)authenticator);
                } else {
                    session = Session.getInstance((Properties)properties);
                }
            }
            session = Session.getInstance((Properties)properties);
        }
        return session;
    }

    protected static URL getAttachemntURL(String attachment) throws MalformedURLException {
        if (attachment.startsWith("classpath:")) {
            String location = attachment.replaceFirst("classpath:", "");
            return SendHtml.class.getResource(location);
        }
        URL attachmentUrl = new URL(attachment);
        return attachmentUrl;
    }

    private static class Authenticator
    extends javax.mail.Authenticator {
        private PasswordAuthentication authentication;

        public Authenticator(String username, String password) {
            this.authentication = new PasswordAuthentication(username, password);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }
    }
}

