/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sshj;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.inject.Named;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.keyprovider.OpenSSHKeyFile;
import net.schmizz.sshj.xfer.InMemorySourceFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.apache.commons.io.input.ProxyInputStream;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.crypto.SshKeys;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.logging.Logger;
import org.jclouds.net.IPSocket;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.SshException;
import org.jclouds.util.Throwables2;

public class SshjSshClient
implements SshClient {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String toString;
    @Inject(optional=true)
    @Named(value="jclouds.ssh.max-retries")
    @VisibleForTesting
    int sshRetries = 5;
    @Inject(optional=true)
    @Named(value="jclouds.ssh.retry-auth")
    @VisibleForTesting
    boolean retryAuth;
    @Inject(optional=true)
    @Named(value="jclouds.ssh.retryable-messages")
    @VisibleForTesting
    String retryableMessages = "";
    @Inject(optional=true)
    @Named(value="jclouds.ssh.retry-predicate")
    private Predicate<Throwable> retryPredicate = Predicates.or((Predicate[])new Predicate[]{Predicates.instanceOf(ConnectionException.class), Predicates.instanceOf(ConnectException.class), Predicates.instanceOf(SocketTimeoutException.class), Predicates.instanceOf(TransportException.class), Predicates.instanceOf(SFTPException.class)});
    @Resource
    @Named(value="jclouds.ssh")
    protected Logger logger = Logger.NULL;
    @VisibleForTesting
    SSHClient ssh;
    private final byte[] privateKey;
    final byte[] emptyPassPhrase = new byte[0];
    private final int timeoutMillis;
    private final BackoffLimitedRetryHandler backoffLimitedRetryHandler;
    Connection<SSHClient> sshConnection = new Connection<SSHClient>(){

        @Override
        public void clear() {
            if (SshjSshClient.this.ssh != null && SshjSshClient.this.ssh.isConnected()) {
                try {
                    SshjSshClient.this.ssh.disconnect();
                }
                catch (IOException e) {
                    SshjSshClient.this.logger.warn((Throwable)e, "<< exception disconnecting from %s: %s", new Object[]{e, e.getMessage()});
                }
                SshjSshClient.this.ssh = null;
            }
        }

        @Override
        public SSHClient create() throws Exception {
            SSHClient ssh = new SSHClient();
            ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            if (SshjSshClient.this.timeoutMillis != 0) {
                ssh.setTimeout(SshjSshClient.this.timeoutMillis);
                ssh.setConnectTimeout(SshjSshClient.this.timeoutMillis);
            }
            ssh.connect(SshjSshClient.this.host, SshjSshClient.this.port);
            if (SshjSshClient.this.password != null) {
                ssh.authPassword(SshjSshClient.this.username, SshjSshClient.this.password);
            } else {
                OpenSSHKeyFile key = new OpenSSHKeyFile();
                key.init(new String(SshjSshClient.this.privateKey), null);
                ssh.authPublickey(SshjSshClient.this.username, new KeyProvider[]{key});
            }
            return ssh;
        }

        public String toString() {
            return String.format("SSHClient(timeout=%d)", SshjSshClient.this.timeoutMillis);
        }
    };
    Connection<SFTPClient> sftpConnection = new Connection<SFTPClient>(){
        private SFTPClient sftp;

        @Override
        public void clear() {
            if (this.sftp != null) {
                try {
                    this.sftp.close();
                }
                catch (IOException e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        }

        @Override
        public SFTPClient create() throws IOException {
            SshjSshClient.this.checkConnected();
            this.sftp = SshjSshClient.this.ssh.newSFTPClient();
            return this.sftp;
        }

        public String toString() {
            return "SFTPClient()";
        }
    };

    public SshjSshClient(BackoffLimitedRetryHandler backoffLimitedRetryHandler, IPSocket socket, int timeout, String username, String password, byte[] privateKey) {
        this.host = ((IPSocket)Preconditions.checkNotNull((Object)socket, (Object)"socket")).getAddress();
        Preconditions.checkArgument((socket.getPort() > 0 ? 1 : 0) != 0, (Object)("ssh port must be greater then zero" + socket.getPort()));
        Preconditions.checkArgument((password != null || privateKey != null ? 1 : 0) != 0, (Object)"you must specify a password or a key");
        this.port = socket.getPort();
        this.username = (String)Preconditions.checkNotNull((Object)username, (Object)"username");
        this.backoffLimitedRetryHandler = (BackoffLimitedRetryHandler)Preconditions.checkNotNull((Object)backoffLimitedRetryHandler, (Object)"backoffLimitedRetryHandler");
        this.timeoutMillis = timeout;
        this.password = password;
        this.privateKey = privateKey;
        if (privateKey == null) {
            this.toString = String.format("%s:pw[%s]@%s:%d", username, CryptoStreams.hex((byte[])CryptoStreams.md5((byte[])password.getBytes())), this.host, this.port);
        } else {
            String fingerPrint = SshKeys.fingerprintPrivateKey((String)new String(privateKey));
            String sha1 = SshKeys.sha1PrivateKey((String)new String(privateKey));
            this.toString = String.format("%s:rsa[fingerprint(%s),sha1(%s)]@%s:%d", username, fingerPrint, sha1, this.host, this.port);
        }
    }

    public void put(String path, String contents) {
        this.put(path, (Payload)Payloads.newStringPayload((String)((String)Preconditions.checkNotNull((Object)contents, (Object)"contents"))));
    }

    private void checkConnected() {
        Preconditions.checkState((this.ssh != null && this.ssh.isConnected() ? 1 : 0) != 0, (Object)String.format("(%s) ssh not connected!", this.toString()));
    }

    private void backoffForAttempt(int retryAttempt, String message) {
        this.backoffLimitedRetryHandler.imposeBackoffExponentialDelay(200L, 2, retryAttempt, this.sshRetries, message);
    }

    protected <T, C extends Connection<T>> T acquire(C connection) {
        String errorMessage = String.format("(%s) error acquiring %s", this.toString(), connection);
        for (int i = 0; i < this.sshRetries; ++i) {
            try {
                connection.clear();
                this.logger.debug(">> (%s) acquiring %s", new Object[]{this.toString(), connection});
                T returnVal = connection.create();
                this.logger.debug("<< (%s) acquired %s", new Object[]{this.toString(), returnVal});
                return returnVal;
            }
            catch (Exception from) {
                try {
                    this.disconnect();
                }
                catch (Exception e1) {
                    this.logger.warn((Throwable)from, "<< (%s) error closing connection", new Object[]{this.toString()});
                }
                if (i + 1 == this.sshRetries) {
                    throw this.propagate(from, errorMessage + " (out of retries - max " + this.sshRetries + ")");
                }
                if (this.shouldRetry(from) || Throwables2.getFirstThrowableOfType((Throwable)from, IllegalStateException.class) != null) {
                    this.logger.info("<< " + errorMessage + " (attempt " + (i + 1) + " of " + this.sshRetries + "): " + from.getMessage(), new Object[0]);
                    this.backoffForAttempt(i + 1, errorMessage + ": " + from.getMessage());
                    if (connection == this.sshConnection) continue;
                    this.connect();
                    continue;
                }
                throw this.propagate(from, errorMessage + " (not retryable)");
            }
        }
        assert (false) : "should not reach here";
        return null;
    }

    public void connect() {
        try {
            this.ssh = (SSHClient)this.acquire(this.sshConnection);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public Payload get(String path) {
        return (Payload)this.acquire(new GetConnection(path));
    }

    public void put(String path, Payload contents) {
        this.acquire(new PutConnection(path, contents));
    }

    @VisibleForTesting
    boolean shouldRetry(Exception from) {
        Predicate predicate;
        Predicate predicate2 = predicate = this.retryAuth ? Predicates.or((Predicate[])new Predicate[]{this.retryPredicate, Predicates.instanceOf(AuthorizationException.class), Predicates.instanceOf(UserAuthException.class)}) : this.retryPredicate;
        if (Iterables.any((Iterable)Throwables.getCausalChain((Throwable)from), predicate)) {
            return true;
        }
        if (!this.retryableMessages.equals("")) {
            return Iterables.any((Iterable)Splitter.on((String)",").split((CharSequence)this.retryableMessages), this.causalChainHasMessageContaining(from));
        }
        return false;
    }

    @VisibleForTesting
    Predicate<String> causalChainHasMessageContaining(final Exception from) {
        return new Predicate<String>(){

            public boolean apply(final String input) {
                return Iterables.any((Iterable)Throwables.getCausalChain((Throwable)from), (Predicate)new Predicate<Throwable>(){

                    public boolean apply(Throwable arg0) {
                        return arg0.toString().indexOf(input) != -1 || arg0.getMessage() != null && arg0.getMessage().indexOf(input) != -1;
                    }
                });
            }
        };
    }

    @VisibleForTesting
    SshException propagate(Exception e, String message) {
        message = message + ": " + e.getMessage();
        this.logger.error((Throwable)e, "<< " + message, new Object[0]);
        if (e instanceof UserAuthException) {
            throw new AuthorizationException("(" + this.toString() + ") " + message, (Throwable)e);
        }
        throw e instanceof SshException ? (SshException)SshException.class.cast(e) : new SshException("(" + this.toString() + ") " + message, (Throwable)e);
    }

    public String toString() {
        return this.toString;
    }

    @PreDestroy
    public void disconnect() {
        try {
            this.sshConnection.clear();
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    protected Connection<Session> execConnection() {
        return new Connection<Session>(){
            private Session session = null;

            @Override
            public void clear() throws TransportException, ConnectionException {
                if (this.session != null) {
                    this.session.close();
                }
            }

            @Override
            public Session create() throws Exception {
                SshjSshClient.this.checkConnected();
                this.session = SshjSshClient.this.ssh.startSession();
                this.session.allocatePTY("vt100", 80, 24, 0, 0, Collections.emptyMap());
                return this.session;
            }

            public String toString() {
                return "Session()";
            }
        };
    }

    public ExecResponse exec(String command) {
        return (ExecResponse)this.acquire(new ExecConnection(command));
    }

    public String getHostAddress() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    class ExecConnection
    implements Connection<ExecResponse> {
        private final String command;
        private Session session;

        ExecConnection(String command) {
            this.command = (String)Preconditions.checkNotNull((Object)command, (Object)"command");
        }

        @Override
        public void clear() throws TransportException, ConnectionException {
            if (this.session != null) {
                this.session.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExecResponse create() throws Exception {
            try {
                this.session = (Session)SshjSshClient.this.acquire(SshjSshClient.this.execConnection());
                Session.Command output = this.session.exec((String)Preconditions.checkNotNull((Object)this.command, (Object)"command"));
                String outputString = IOUtils.readFully((InputStream)output.getInputStream()).toString();
                output.join(SshjSshClient.this.timeoutMillis, TimeUnit.SECONDS);
                int errorStatus = output.getExitStatus();
                String errorString = IOUtils.readFully((InputStream)output.getErrorStream()).toString();
                ExecResponse execResponse = new ExecResponse(outputString, errorString, errorStatus);
                return execResponse;
            }
            finally {
                this.clear();
            }
        }

        public String toString() {
            return "ExecResponse(command=[" + this.command + "])";
        }
    }

    class PutConnection
    implements Connection<Void> {
        private final String path;
        private final Payload contents;
        private SFTPClient sftp;

        PutConnection(String path, Payload contents) {
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
            this.contents = (Payload)Preconditions.checkNotNull((Object)contents, (Object)"contents");
        }

        @Override
        public void clear() {
            if (this.sftp != null) {
                try {
                    this.sftp.close();
                }
                catch (IOException e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void create() throws Exception {
            this.sftp = (SFTPClient)SshjSshClient.this.acquire(SshjSshClient.this.sftpConnection);
            try {
                this.sftp.put((LocalSourceFile)new InMemorySourceFile(){

                    public String getName() {
                        return PutConnection.this.path;
                    }

                    public long getLength() {
                        return PutConnection.this.contents.getContentMetadata().getContentLength();
                    }

                    public InputStream getInputStream() throws IOException {
                        return (InputStream)Preconditions.checkNotNull((Object)PutConnection.this.contents.getInput(), (String)"inputstream for path %s", (Object[])new Object[]{PutConnection.this.path});
                    }
                }, this.path);
            }
            finally {
                this.contents.release();
            }
            return null;
        }

        public String toString() {
            return "Put(path=[" + this.path + "])";
        }
    }

    class GetConnection
    implements Connection<Payload> {
        private final String path;
        private SFTPClient sftp;

        GetConnection(String path) {
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
        }

        @Override
        public void clear() throws IOException {
            if (this.sftp != null) {
                this.sftp.close();
            }
        }

        @Override
        public Payload create() throws Exception {
            this.sftp = (SFTPClient)SshjSshClient.this.acquire(SshjSshClient.this.sftpConnection);
            return Payloads.newInputStreamPayload((InputStream)((Object)new CloseFtpChannelOnCloseInputStream((InputStream)this.sftp.getSFTPEngine().open(this.path).getInputStream(), this.sftp)));
        }

        public String toString() {
            return "Payload(path=[" + this.path + "])";
        }
    }

    public static interface Connection<T> {
        public void clear() throws Exception;

        public T create() throws Exception;
    }

    private final class CloseFtpChannelOnCloseInputStream
    extends ProxyInputStream {
        private final SFTPClient sftp;

        private CloseFtpChannelOnCloseInputStream(InputStream proxy, SFTPClient sftp) {
            super(proxy);
            this.sftp = sftp;
        }

        public void close() throws IOException {
            super.close();
            if (this.sftp != null) {
                this.sftp.close();
            }
        }
    }
}

