/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.functions;

import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.RunningInstanceToNodeMetadata;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.RunningInstance;

@Singleton
public class AWSRunningInstanceToNodeMetadata
extends RunningInstanceToNodeMetadata {
    @Inject
    protected AWSRunningInstanceToNodeMetadata(Map<InstanceState, NodeState> instanceToNodeState, Map<String, Credentials> credentialStore, Supplier<LoadingCache<RegionAndName, ? extends Image>> imageMap, @Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Hardware>> hardware, GroupNamingConvention.Factory namingConvention) {
        super(instanceToNodeState, credentialStore, imageMap, locations, hardware, namingConvention);
    }

    protected void addCredentialsForInstance(NodeMetadataBuilder builder, RunningInstance instance) {
        LoginCredentials creds = LoginCredentials.fromCredentials((Credentials)((Credentials)this.credentialStore.get("node#" + instance.getRegion() + "/" + instance.getId())));
        String spotRequestId = ((AWSRunningInstance)((Object)AWSRunningInstance.class.cast(instance))).getSpotInstanceRequestId();
        if (creds == null && spotRequestId != null && (creds = LoginCredentials.fromCredentials((Credentials)((Credentials)this.credentialStore.get("node#" + instance.getRegion() + "/" + spotRequestId)))) != null) {
            this.credentialStore.put("node#" + instance.getRegion() + "/" + instance.getId(), creds);
        }
        if (creds != null) {
            builder.credentials(creds);
        }
    }

    protected Hardware parseHardware(RunningInstance instance) {
        Hardware in = super.parseHardware(instance);
        if (in == null) {
            return null;
        }
        AWSRunningInstance awsInstance = (AWSRunningInstance)((Object)AWSRunningInstance.class.cast(instance));
        return HardwareBuilder.fromHardware((Hardware)in).hypervisor(awsInstance.getHypervisor().toString()).build();
    }

    protected NodeMetadataBuilder buildInstance(RunningInstance instance, NodeMetadataBuilder builder) {
        AWSRunningInstance awsInstance = (AWSRunningInstance)((Object)AWSRunningInstance.class.cast(instance));
        builder.name(awsInstance.getTags().get("Name"));
        ComputeServiceUtils.addMetadataAndParseTagsFromValuesOfEmptyString((NodeMetadataBuilder)builder, awsInstance.getTags());
        return super.buildInstance(instance, builder);
    }
}

