/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.javax.annotation.Nullable;

public class AWSRunningInstance
extends RunningInstance {
    private final MonitoringState monitoringState;
    @Nullable
    private final String placementGroup;
    private final Set<String> productCodes;
    @Nullable
    private final String subnetId;
    @Nullable
    private final String spotInstanceRequestId;
    @Nullable
    private final String vpcId;
    private final Hypervisor hypervisor;
    private final Map<String, String> securityGroupIdToNames;
    private final Map<String, String> tags;

    public static Builder builder() {
        return new Builder();
    }

    protected AWSRunningInstance(String region, Map<String, String> securityGroupIdToNames, String amiLaunchIndex, String dnsName, String imageId, String instanceId, InstanceState instanceState, String instanceType, String ipAddress, String kernelId, String keyName, Date launchTime, String availabilityZone, String virtualizationType, String platform, String privateDnsName, String privateIpAddress, String ramdiskId, String reason, RootDeviceType rootDeviceType, String rootDeviceName, Map<String, BlockDevice> ebsBlockDevices, MonitoringState monitoringState, String placementGroup, Iterable<String> productCodes, String subnetId, String spotInstanceRequestId, String vpcId, Hypervisor hypervisor, Map<String, String> tags) {
        super(region, securityGroupIdToNames.values(), amiLaunchIndex, dnsName, imageId, instanceId, instanceState, instanceType, ipAddress, kernelId, keyName, launchTime, availabilityZone, virtualizationType, platform, privateDnsName, privateIpAddress, ramdiskId, reason, rootDeviceType, rootDeviceName, ebsBlockDevices);
        this.monitoringState = (MonitoringState)((Object)Preconditions.checkNotNull((Object)((Object)monitoringState), (Object)"monitoringState"));
        this.placementGroup = placementGroup;
        this.productCodes = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(productCodes, (Object)"productCodes")));
        this.subnetId = subnetId;
        this.spotInstanceRequestId = spotInstanceRequestId;
        this.vpcId = vpcId;
        this.hypervisor = (Hypervisor)Preconditions.checkNotNull((Object)hypervisor, (Object)"hypervisor");
        this.securityGroupIdToNames = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(securityGroupIdToNames, (Object)"securityGroupIdToNames")));
        this.tags = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(tags, (Object)"tags")));
    }

    public Map<String, String> getSecurityGroupIdToNames() {
        return this.securityGroupIdToNames;
    }

    public MonitoringState getMonitoringState() {
        return this.monitoringState;
    }

    public String getPlacementGroup() {
        return this.placementGroup;
    }

    public Set<String> getProductCodes() {
        return this.productCodes;
    }

    public String getSpotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public Hypervisor getHypervisor() {
        return this.hypervisor;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.placementGroup == null ? 0 : this.placementGroup.hashCode());
        result = 31 * result + (this.productCodes == null ? 0 : ((Object)this.productCodes).hashCode());
        result = 31 * result + (this.spotInstanceRequestId == null ? 0 : this.spotInstanceRequestId.hashCode());
        result = 31 * result + (this.subnetId == null ? 0 : this.subnetId.hashCode());
        result = 31 * result + (this.vpcId == null ? 0 : this.vpcId.hashCode());
        result = 31 * result + (this.hypervisor == null ? 0 : this.hypervisor.hashCode());
        result = 31 * result + (this.tags == null ? 0 : ((Object)this.tags).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AWSRunningInstance other = (AWSRunningInstance)((Object)obj);
        if (this.placementGroup == null ? other.placementGroup != null : !this.placementGroup.equals(other.placementGroup)) {
            return false;
        }
        if (this.productCodes == null ? other.productCodes != null : !((Object)this.productCodes).equals(other.productCodes)) {
            return false;
        }
        if (this.spotInstanceRequestId == null ? other.spotInstanceRequestId != null : !this.spotInstanceRequestId.equals(other.spotInstanceRequestId)) {
            return false;
        }
        if (this.subnetId == null ? other.subnetId != null : !this.subnetId.equals(other.subnetId)) {
            return false;
        }
        if (this.vpcId == null ? other.vpcId != null : !this.vpcId.equals(other.vpcId)) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !((Object)this.tags).equals(other.tags)) {
            return false;
        }
        return Objects.equal((Object)this.hypervisor, (Object)other.hypervisor);
    }

    public String toString() {
        return "[region=" + this.region + ", availabilityZone=" + this.availabilityZone + ", instanceId=" + this.instanceId + ", instanceState=" + this.instanceState + ", instanceType=" + this.instanceType + ", virtualizationType=" + this.virtualizationType + ", imageId=" + this.imageId + ", ipAddress=" + this.ipAddress + ", dnsName=" + this.dnsName + ", privateIpAddress=" + this.privateIpAddress + ", privateDnsName=" + this.privateDnsName + ", keyName=" + this.keyName + ", platform=" + this.platform + ", launchTime=" + this.launchTime + ", rootDeviceName=" + this.rootDeviceName + ", rootDeviceType=" + this.rootDeviceType + ", ebsBlockDevices=" + this.ebsBlockDevices + ", monitoringState=" + (Object)((Object)this.monitoringState) + ", placementGroup=" + this.placementGroup + ", productCodes=" + this.productCodes + ", spotInstanceRequestId=" + this.spotInstanceRequestId + ", subnetId=" + this.subnetId + ", hypervisor=" + this.hypervisor + ", vpcId=" + this.vpcId + ", tags=" + this.tags + "]";
    }

    public static class Builder
    extends RunningInstance.Builder {
        private MonitoringState monitoringState;
        private String placementGroup;
        private Set<String> productCodes = Sets.newLinkedHashSet();
        private String subnetId;
        private String spotInstanceRequestId;
        private String vpcId;
        private Hypervisor hypervisor;
        private Map<String, String> securityGroupIdToNames = Maps.newLinkedHashMap();
        private Map<String, String> tags = Maps.newLinkedHashMap();

        public Builder tags(Map<String, String> tags) {
            this.tags = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this;
        }

        public Builder tag(String key, String value) {
            if (key != null) {
                this.tags.put(key, Strings.nullToEmpty((String)value));
            }
            return this;
        }

        public Builder securityGroupIdToNames(Map<String, String> securityGroupIdToNames) {
            this.securityGroupIdToNames = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(securityGroupIdToNames, (Object)"securityGroupIdToNames")));
            return this;
        }

        public Builder securityGroupIdToName(String key, String value) {
            if (key != null && value != null) {
                this.securityGroupIdToNames.put(key, value);
            }
            return this;
        }

        public Builder monitoringState(MonitoringState monitoringState) {
            this.monitoringState = monitoringState;
            return this;
        }

        public Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public Builder productCodes(Iterable<String> productCodes) {
            this.productCodes = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(productCodes, (Object)"productCodes")));
            return this;
        }

        public Builder productCode(String productCode) {
            if (productCode != null) {
                this.productCodes.add(productCode);
            }
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public Builder hypervisor(Hypervisor hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public Builder amiLaunchIndex(String amiLaunchIndex) {
            return (Builder)((Object)Builder.class.cast(super.amiLaunchIndex(amiLaunchIndex)));
        }

        public Builder availabilityZone(String availabilityZone) {
            return (Builder)((Object)Builder.class.cast(super.availabilityZone(availabilityZone)));
        }

        public Builder devices(Map<String, BlockDevice> ebsBlockDevices) {
            return (Builder)((Object)Builder.class.cast(super.devices(ebsBlockDevices)));
        }

        public Builder dnsName(String dnsName) {
            return (Builder)((Object)Builder.class.cast(super.dnsName(dnsName)));
        }

        public Builder imageId(String imageId) {
            return (Builder)((Object)Builder.class.cast(super.imageId(imageId)));
        }

        public Builder instanceId(String instanceId) {
            return (Builder)((Object)Builder.class.cast(super.instanceId(instanceId)));
        }

        public Builder instanceState(InstanceState instanceState) {
            return (Builder)((Object)Builder.class.cast(super.instanceState(instanceState)));
        }

        public Builder instanceType(String instanceType) {
            return (Builder)((Object)Builder.class.cast(super.instanceType(instanceType)));
        }

        public Builder ipAddress(String ipAddress) {
            return (Builder)((Object)Builder.class.cast(super.ipAddress(ipAddress)));
        }

        public Builder kernelId(String kernelId) {
            return (Builder)((Object)Builder.class.cast(super.kernelId(kernelId)));
        }

        public Builder keyName(String keyName) {
            return (Builder)((Object)Builder.class.cast(super.keyName(keyName)));
        }

        public Builder launchTime(Date launchTime) {
            return (Builder)((Object)Builder.class.cast(super.launchTime(launchTime)));
        }

        public Builder platform(String platform) {
            return (Builder)((Object)Builder.class.cast(super.platform(platform)));
        }

        public Builder privateDnsName(String privateDnsName) {
            return (Builder)((Object)Builder.class.cast(super.privateDnsName(privateDnsName)));
        }

        public Builder privateIpAddress(String privateIpAddress) {
            return (Builder)((Object)Builder.class.cast(super.privateIpAddress(privateIpAddress)));
        }

        public Builder ramdiskId(String ramdiskId) {
            return (Builder)((Object)Builder.class.cast(super.ramdiskId(ramdiskId)));
        }

        public Builder reason(String reason) {
            return (Builder)((Object)Builder.class.cast(super.reason(reason)));
        }

        public Builder region(String region) {
            return (Builder)((Object)Builder.class.cast(super.region(region)));
        }

        public Builder rootDeviceName(String rootDeviceName) {
            return (Builder)((Object)Builder.class.cast(super.rootDeviceName(rootDeviceName)));
        }

        public Builder rootDeviceType(RootDeviceType rootDeviceType) {
            return (Builder)((Object)Builder.class.cast(super.rootDeviceType(rootDeviceType)));
        }

        public Builder virtualizationType(String virtualizationType) {
            return (Builder)((Object)Builder.class.cast(super.virtualizationType(virtualizationType)));
        }

        public Builder device(String key, BlockDevice value) {
            return (Builder)((Object)Builder.class.cast(super.device(key, value)));
        }

        public Builder groupId(String groupId) {
            return (Builder)((Object)Builder.class.cast(super.groupId(groupId)));
        }

        public Builder groupIds(Iterable<String> groupIds) {
            return (Builder)((Object)Builder.class.cast(super.groupIds(groupIds)));
        }

        public AWSRunningInstance build() {
            return new AWSRunningInstance(this.region, this.securityGroupIdToNames, this.amiLaunchIndex, this.dnsName, this.imageId, this.instanceId, this.instanceState, this.instanceType, this.ipAddress, this.kernelId, this.keyName, this.launchTime, this.availabilityZone, this.virtualizationType, this.platform, this.privateDnsName, this.privateIpAddress, this.ramdiskId, this.reason, this.rootDeviceType, this.rootDeviceName, this.ebsBlockDevices, this.monitoringState, this.placementGroup, this.productCodes, this.subnetId, this.spotInstanceRequestId, this.vpcId, this.hypervisor, this.tags);
        }
    }
}

