/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2AsyncClient;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.functions.SpotInstanceRequestToAWSRunningInstance;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.ec2.EC2AsyncClient;
import org.jclouds.ec2.compute.strategy.EC2ListNodesStrategy;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;

@Singleton
public class AWSEC2ListNodesStrategy
extends EC2ListNodesStrategy {
    protected final AWSEC2AsyncClient client;
    protected final SpotInstanceRequestToAWSRunningInstance spotConverter;

    @Inject
    protected AWSEC2ListNodesStrategy(AWSEC2AsyncClient client, @Region Supplier<Set<String>> regions, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, @Named(value="jclouds.user-threads") ExecutorService executor, SpotInstanceRequestToAWSRunningInstance spotConverter) {
        super((EC2AsyncClient)client, regions, runningInstanceToNodeMetadata, executor);
        this.client = (AWSEC2AsyncClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.spotConverter = (SpotInstanceRequestToAWSRunningInstance)Preconditions.checkNotNull((Object)spotConverter, (Object)"spotConverter");
    }

    protected Iterable<? extends RunningInstance> pollRunningInstances() {
        Iterable spots = Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.concat((Iterable)FutureIterables.transformParallel((Iterable)((Iterable)this.regions.get()), (Function)new Function<String, Future<? extends Set<SpotInstanceRequest>>>(){

            public Future<? extends Set<SpotInstanceRequest>> apply(String from) {
                return AWSEC2ListNodesStrategy.this.client.getSpotInstanceServices().describeSpotInstanceRequestsInRegion(from, new String[0]);
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)"reservations")), (Function)this.spotConverter), (Predicate)Predicates.notNull());
        return Iterables.concat((Iterable)super.pollRunningInstances(), (Iterable)spots);
    }
}

