/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.jclouds.javax.annotation.Nullable;

public class LaunchSpecification {
    protected final String instanceType;
    protected final String imageId;
    protected final String kernelId;
    protected final String ramdiskId;
    protected final String availabilityZone;
    protected final String keyName;
    protected final Map<String, String> securityGroupIdToNames;
    protected final Set<? extends BlockDeviceMapping> blockDeviceMappings;
    protected final Set<String> securityGroupIds;
    protected final Set<String> securityGroupNames;
    protected final Boolean monitoringEnabled;
    protected final byte[] userData;

    public static Builder builder() {
        return new Builder();
    }

    public LaunchSpecification(String instanceType, String imageId, String kernelId, String ramdiskId, String availabilityZone, String keyName, Map<String, String> securityGroupIdToNames, Iterable<? extends BlockDeviceMapping> blockDeviceMappings, Boolean monitoringEnabled, Set<String> securityGroupIds, Set<String> securityGroupNames, byte[] userData) {
        this.instanceType = (String)Preconditions.checkNotNull((Object)instanceType, (Object)"instanceType");
        this.imageId = (String)Preconditions.checkNotNull((Object)imageId, (Object)"imageId");
        this.kernelId = kernelId;
        this.ramdiskId = ramdiskId;
        this.availabilityZone = availabilityZone;
        this.keyName = keyName;
        this.securityGroupIdToNames = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(securityGroupIdToNames, (Object)"securityGroupIdToNames")));
        this.blockDeviceMappings = ImmutableSortedSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(blockDeviceMappings, (Object)"blockDeviceMappings")));
        this.securityGroupIds = ImmutableSortedSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(securityGroupIds, (Object)"securityGroupIds")));
        this.securityGroupNames = ImmutableSortedSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(securityGroupNames, (Object)"securityGroupNames")));
        this.monitoringEnabled = monitoringEnabled;
        this.userData = userData;
    }

    public Map<String, String> getSecurityGroupIdToNames() {
        return this.securityGroupIdToNames;
    }

    public String getImageId() {
        return this.imageId;
    }

    public Boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public Set<? extends BlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public Set<String> getSecurityGroupNames() {
        return this.securityGroupNames;
    }

    public Set<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.availabilityZone == null ? 0 : this.availabilityZone.hashCode());
        result = 31 * result + (this.blockDeviceMappings == null ? 0 : ((Object)this.blockDeviceMappings).hashCode());
        result = 31 * result + (this.imageId == null ? 0 : this.imageId.hashCode());
        result = 31 * result + (this.instanceType == null ? 0 : this.instanceType.hashCode());
        result = 31 * result + (this.kernelId == null ? 0 : this.kernelId.hashCode());
        result = 31 * result + (this.keyName == null ? 0 : this.keyName.hashCode());
        result = 31 * result + (this.monitoringEnabled == null ? 0 : this.monitoringEnabled.hashCode());
        result = 31 * result + (this.ramdiskId == null ? 0 : this.ramdiskId.hashCode());
        result = 31 * result + (this.securityGroupIdToNames == null ? 0 : ((Object)this.securityGroupIdToNames).hashCode());
        result = 31 * result + (this.securityGroupIds == null ? 0 : ((Object)this.securityGroupIds).hashCode());
        result = 31 * result + (this.securityGroupNames == null ? 0 : ((Object)this.securityGroupNames).hashCode());
        result = 31 * result + Arrays.hashCode(this.userData);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LaunchSpecification other = (LaunchSpecification)obj;
        if (this.availabilityZone == null ? other.availabilityZone != null : !this.availabilityZone.equals(other.availabilityZone)) {
            return false;
        }
        if (this.blockDeviceMappings == null ? other.blockDeviceMappings != null : !((Object)this.blockDeviceMappings).equals(other.blockDeviceMappings)) {
            return false;
        }
        if (this.imageId == null ? other.imageId != null : !this.imageId.equals(other.imageId)) {
            return false;
        }
        if (this.instanceType == null ? other.instanceType != null : !this.instanceType.equals(other.instanceType)) {
            return false;
        }
        if (this.kernelId == null ? other.kernelId != null : !this.kernelId.equals(other.kernelId)) {
            return false;
        }
        if (this.keyName == null ? other.keyName != null : !this.keyName.equals(other.keyName)) {
            return false;
        }
        if (this.monitoringEnabled == null ? other.monitoringEnabled != null : !this.monitoringEnabled.equals(other.monitoringEnabled)) {
            return false;
        }
        if (this.ramdiskId == null ? other.ramdiskId != null : !this.ramdiskId.equals(other.ramdiskId)) {
            return false;
        }
        if (this.securityGroupIdToNames == null ? other.securityGroupIdToNames != null : !((Object)this.securityGroupIdToNames).equals(other.securityGroupIdToNames)) {
            return false;
        }
        if (this.securityGroupIds == null ? other.securityGroupIds != null : !((Object)this.securityGroupIds).equals(other.securityGroupIds)) {
            return false;
        }
        if (this.securityGroupNames == null ? other.securityGroupNames != null : !((Object)this.securityGroupNames).equals(other.securityGroupNames)) {
            return false;
        }
        return Arrays.equals(this.userData, other.userData);
    }

    public Builder toBuilder() {
        return Builder.fromLaunchSpecification(this);
    }

    public String toString() {
        return "[instanceType=" + this.instanceType + ", imageId=" + this.imageId + ", kernelId=" + this.kernelId + ", ramdiskId=" + this.ramdiskId + ", availabilityZone=" + this.availabilityZone + ", keyName=" + this.keyName + ", securityGroupIdToNames=" + this.securityGroupIdToNames + ", blockDeviceMappings=" + this.blockDeviceMappings + ", securityGroupIds=" + this.securityGroupIds + ", securityGroupNames=" + this.securityGroupNames + ", monitoringEnabled=" + this.monitoringEnabled + ", userData=" + Arrays.toString(this.userData) + "]";
    }

    public static class Builder {
        protected ImmutableMap.Builder<String, String> securityGroupIdToNames = ImmutableMap.builder();
        protected String imageId;
        protected String instanceType;
        protected String kernelId;
        protected String keyName;
        protected String availabilityZone;
        protected String ramdiskId;
        protected Boolean monitoringEnabled;
        protected ImmutableSet.Builder<BlockDeviceMapping> blockDeviceMappings = ImmutableSet.builder();
        protected ImmutableSet.Builder<String> securityGroupIds = ImmutableSet.builder();
        protected ImmutableSet.Builder<String> securityGroupNames = ImmutableSet.builder();
        protected byte[] userData;

        public void clear() {
            this.securityGroupIdToNames = ImmutableMap.builder();
            this.imageId = null;
            this.instanceType = null;
            this.kernelId = null;
            this.keyName = null;
            this.availabilityZone = null;
            this.ramdiskId = null;
            this.monitoringEnabled = false;
            this.blockDeviceMappings = ImmutableSet.builder();
            this.securityGroupIds = ImmutableSet.builder();
            this.securityGroupNames = ImmutableSet.builder();
            this.userData = null;
        }

        public Builder securityGroupIdToNames(Map<String, String> securityGroupIdToNames) {
            this.securityGroupIdToNames.putAll((Map)Preconditions.checkNotNull(securityGroupIdToNames, (Object)"securityGroupIdToNames"));
            return this;
        }

        public Builder securityGroupIdToName(String groupId, String groupName) {
            if (groupId != null && groupName != null) {
                this.securityGroupIdToNames.put(Preconditions.checkNotNull((Object)groupId, (Object)"groupId"), Preconditions.checkNotNull((Object)groupName, (Object)"groupName"));
            }
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder monitoringEnabled(Boolean monitoringEnabled) {
            this.monitoringEnabled = monitoringEnabled;
            return this;
        }

        public Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public Builder mapEBSSnapshotToDevice(String deviceName, String snapshotId, @Nullable Integer sizeInGib, boolean deleteOnTermination) {
            this.blockDeviceMappings.add((Object)new BlockDeviceMapping.MapEBSSnapshotToDevice(deviceName, snapshotId, sizeInGib, Boolean.valueOf(deleteOnTermination)));
            return this;
        }

        public Builder mapNewVolumeToDevice(String deviceName, int sizeInGib, boolean deleteOnTermination) {
            this.blockDeviceMappings.add((Object)new BlockDeviceMapping.MapNewVolumeToDevice(deviceName, Integer.valueOf(sizeInGib), Boolean.valueOf(deleteOnTermination)));
            return this;
        }

        public Builder mapEphemeralDeviceToDevice(String deviceName, String virtualName) {
            this.blockDeviceMappings.add((Object)new BlockDeviceMapping.MapEphemeralDeviceToDevice(deviceName, virtualName));
            return this;
        }

        public Builder blockDeviceMapping(BlockDeviceMapping blockDeviceMapping) {
            this.blockDeviceMappings.add(Preconditions.checkNotNull((Object)blockDeviceMapping, (Object)"blockDeviceMapping"));
            return this;
        }

        public Builder blockDeviceMappings(Iterable<? extends BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings.addAll((Iterable)Preconditions.checkNotNull(blockDeviceMappings, (Object)"blockDeviceMappings"));
            return this;
        }

        public Builder securityGroupIds(Iterable<String> securityGroupIds) {
            this.securityGroupIds.addAll((Iterable)Preconditions.checkNotNull(securityGroupIds, (Object)"securityGroupIds"));
            return this;
        }

        public Builder securityGroupId(String securityGroupId) {
            if (securityGroupId != null) {
                this.securityGroupIds.add((Object)securityGroupId);
            }
            return this;
        }

        public Builder securityGroupNames(Iterable<String> securityGroupNames) {
            this.securityGroupNames.addAll((Iterable)Preconditions.checkNotNull(securityGroupNames, (Object)"securityGroupNames"));
            return this;
        }

        public Builder securityGroupName(String securityGroupName) {
            if (securityGroupName != null) {
                this.securityGroupNames.add((Object)securityGroupName);
            }
            return this;
        }

        public Builder userData(byte[] userData) {
            this.userData = userData;
            return this;
        }

        public LaunchSpecification build() {
            return new LaunchSpecification(this.instanceType, this.imageId, this.kernelId, this.ramdiskId, this.availabilityZone, this.keyName, (Map<String, String>)this.securityGroupIdToNames.build(), (Iterable<? extends BlockDeviceMapping>)this.blockDeviceMappings.build(), this.monitoringEnabled, (Set<String>)this.securityGroupIds.build(), (Set<String>)this.securityGroupNames.build(), this.userData);
        }

        public static Builder fromLaunchSpecification(LaunchSpecification in) {
            return new Builder().instanceType(in.getInstanceType()).imageId(in.getImageId()).kernelId(in.getKernelId()).ramdiskId(in.getRamdiskId()).availabilityZone(in.getAvailabilityZone()).keyName(in.getKeyName()).securityGroupIdToNames(in.getSecurityGroupIdToNames()).securityGroupIds(in.getSecurityGroupIds()).securityGroupNames(in.getSecurityGroupNames()).blockDeviceMappings(in.getBlockDeviceMappings()).monitoringEnabled(in.isMonitoringEnabled()).userData(in.getUserData());
        }
    }
}

