/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azureblob.AzureBlobAsyncClient;
import org.jclouds.azureblob.blobstore.functions.BlobToAzureBlob;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.options.GetOptions;
import org.jclouds.rest.internal.RestAnnotationProcessor;

@Singleton
public class AzureBlobRequestSigner
implements BlobRequestSigner {
    private final RestAnnotationProcessor<AzureBlobAsyncClient> processor;
    private final BlobToAzureBlob blobToBlob;
    private final BlobToHttpGetOptions blob2HttpGetOptions;
    private final Method getMethod;
    private final Method deleteMethod;
    private final Method createMethod;

    @Inject
    public AzureBlobRequestSigner(RestAnnotationProcessor<AzureBlobAsyncClient> processor, BlobToAzureBlob blobToBlob, BlobToHttpGetOptions blob2HttpGetOptions) throws SecurityException, NoSuchMethodException {
        this.processor = (RestAnnotationProcessor)Preconditions.checkNotNull(processor, (Object)"processor");
        this.blobToBlob = (BlobToAzureBlob)Preconditions.checkNotNull((Object)blobToBlob, (Object)"blobToBlob");
        this.blob2HttpGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2HttpGetOptions, (Object)"blob2HttpGetOptions");
        this.getMethod = AzureBlobAsyncClient.class.getMethod("getBlob", String.class, String.class, GetOptions[].class);
        this.deleteMethod = AzureBlobAsyncClient.class.getMethod("deleteBlob", String.class, String.class);
        this.createMethod = AzureBlobAsyncClient.class.getMethod("putBlob", String.class, AzureBlob.class);
    }

    public HttpRequest signGetBlob(String container, String name) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.getMethod, new Object[]{container, name}));
    }

    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        throw new UnsupportedOperationException();
    }

    public HttpRequest signPutBlob(String container, Blob blob) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.createMethod, new Object[]{container, this.blobToBlob.apply(blob)}));
    }

    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        throw new UnsupportedOperationException();
    }

    public HttpRequest signRemoveBlob(String container, String name) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.deleteMethod, new Object[]{container, name}));
    }

    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.getMethod, new Object[]{container, name, this.blob2HttpGetOptions.apply(options)}));
    }
}

