/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.jclouds.azureblob.domain.ContainerProperties;

public class ContainerPropertiesImpl
implements Serializable,
ContainerProperties {
    private static final long serialVersionUID = -4648755473986695062L;
    private final String name;
    private final URI url;
    private final Date lastModified;
    private final String eTag;
    private final Map<String, String> metadata = Maps.newLinkedHashMap();

    public ContainerPropertiesImpl(URI url, Date lastModified, String eTag, Map<String, String> metadata) {
        this.url = (URI)Preconditions.checkNotNull((Object)url, (Object)"url");
        this.name = ((String)Preconditions.checkNotNull((Object)url.getPath(), (Object)"url.getPath()")).replaceFirst("/", "");
        this.lastModified = (Date)Preconditions.checkNotNull((Object)lastModified, (Object)"lastModified");
        this.eTag = (String)Preconditions.checkNotNull((Object)eTag, (Object)"eTag");
        this.metadata.putAll((Map)Preconditions.checkNotNull(metadata, (Object)"metadata"));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    @Override
    public int compareTo(ContainerProperties o) {
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public URI getUrl() {
        return this.url;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eTag == null ? 0 : this.eTag.hashCode());
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerPropertiesImpl other = (ContainerPropertiesImpl)obj;
        if (this.eTag == null ? other.eTag != null : !this.eTag.equals(other.eTag)) {
            return false;
        }
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

