/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParentLastURLClassLoader
extends ClassLoader {
    private final ChildURLClassLoader childClassLoader;

    public ParentLastURLClassLoader(@NotNull List<URL> classpath, @Nullable ClassLoader parent) {
        super(Thread.currentThread().getContextClassLoader());
        URL[] urls = classpath.toArray(new URL[classpath.size()]);
        this.childClassLoader = new ChildURLClassLoader(urls, new FindClassClassLoader(parent));
    }

    @Override
    protected synchronized Class<?> loadClass(@NotNull String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.childClassLoader.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, resolve);
        }
    }

    static class ChildURLClassLoader
    extends URLClassLoader {
        private final FindClassClassLoader realParent;

        public ChildURLClassLoader(@NotNull URL[] urls, @NotNull FindClassClassLoader realParent) {
            super(urls, (ClassLoader)null);
            this.realParent = realParent;
        }

        @Override
        @NotNull
        public Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
            Class<?> loaded = this.findLoadedClass(name);
            if (loaded != null) {
                return loaded;
            }
            try {
                return super.findClass(name);
            }
            catch (ClassNotFoundException e) {
                return this.realParent.loadClass(name);
            }
        }
    }

    private static class FindClassClassLoader
    extends ClassLoader {
        public FindClassClassLoader(@Nullable ClassLoader parent) {
            super(parent);
        }

        @Override
        @NotNull
        public Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
            return super.findClass(name);
        }
    }
}

