/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlugin;
import org.jetbrains.kotlin.gradle.tasks.JarSearchingUtilKt;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0$2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a\n\u0010%\u001a\u0004\u0018\u00010\u000fH\u0000\u001a\u001a\u0010&\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u0001H\u0002\u001a\u0012\u0010(\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0014\u0010)\u001a\u00020**\u00020\u000f2\u0006\u0010+\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"K2JS_COMPILER_CLASS", "", "K2JS_DCE_CLASS", "K2JVM_COMPILER_CLASS", "K2METADATA_COMPILER_CLASS", "KOTLIN_COMPILER_EMBEDDABLE", "KOTLIN_GRADLE_PLUGIN", "KOTLIN_MODULE_GROUP", "KOTLIN_REFLECT", "KOTLIN_REFLECT_EXPECTED_CLASS", "KOTLIN_SCRIPT_RUNTIME", "KOTLIN_SCRIPT_RUNTIME_EXPECTED_CLASS", "KOTLIN_STDLIB", "KOTLIN_STDLIB_EXPECTED_CLASS", "findJarByClass", "Ljava/io/File;", "klass", "Ljava/lang/Class;", "findKotlinJsCompilerClasspath", "", "project", "Lorg/gradle/api/Project;", "findKotlinJsDceClasspath", "findKotlinJvmCompilerClasspath", "findKotlinMetadataCompilerClasspath", "findKotlinModuleDependency", "Lorg/gradle/api/artifacts/ResolvedDependency;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "moduleId", "findKotlinModuleJar", "expectedClassName", "findKotlinReflectClasspath", "findKotlinScriptRuntimeClasspath", "findKotlinStdlibClasspath", "findPotentialModuleJars", "", "findToolsJar", "getModuleFromClassLoader", "moduleVersion", "pluginVersionFromAppliedPlugin", "hasEntry", "", "entryToFind", "kotlin-gradle-plugin"})
public final class JarSearchingUtilKt {
    private static final String K2JVM_COMPILER_CLASS = "org.jetbrains.kotlin.cli.jvm.K2JVMCompiler";
    private static final String K2JS_COMPILER_CLASS = "org.jetbrains.kotlin.cli.js.K2JSCompiler";
    private static final String K2JS_DCE_CLASS = "org.jetbrains.kotlin.cli.js.dce.K2JSDce";
    private static final String K2METADATA_COMPILER_CLASS = "org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler";
    private static final String KOTLIN_STDLIB_EXPECTED_CLASS = "kotlin.collections.ArraysKt";
    private static final String KOTLIN_SCRIPT_RUNTIME_EXPECTED_CLASS = "kotlin.script.templates.AnnotationsKt";
    private static final String KOTLIN_REFLECT_EXPECTED_CLASS = "kotlin.reflect.full.KClasses";
    private static final String KOTLIN_MODULE_GROUP = "org.jetbrains.kotlin";
    private static final String KOTLIN_GRADLE_PLUGIN = "kotlin-gradle-plugin";
    private static final String KOTLIN_COMPILER_EMBEDDABLE = "kotlin-compiler-embeddable";
    private static final String KOTLIN_STDLIB = "kotlin-stdlib";
    private static final String KOTLIN_SCRIPT_RUNTIME = "kotlin-script-runtime";
    private static final String KOTLIN_REFLECT = "kotlin-reflect";

    @NotNull
    public static final List<File> findKotlinJvmCompilerClasspath(@NotNull Project project) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List it = list = JarSearchingUtilKt.findKotlinModuleJar(project, K2JVM_COMPILER_CLASS, KOTLIN_COMPILER_EMBEDDABLE);
        return it.isEmpty() ? it : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)it, (Iterable)JarSearchingUtilKt.findKotlinStdlibClasspath(project)), (Iterable)JarSearchingUtilKt.findKotlinScriptRuntimeClasspath(project)), (Iterable)JarSearchingUtilKt.findKotlinReflectClasspath(project));
    }

    @NotNull
    public static final List<File> findKotlinJsCompilerClasspath(@NotNull Project project) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List it = list = JarSearchingUtilKt.findKotlinModuleJar(project, K2JS_COMPILER_CLASS, KOTLIN_COMPILER_EMBEDDABLE);
        return it.isEmpty() ? it : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)it, (Iterable)JarSearchingUtilKt.findKotlinStdlibClasspath(project)), (Iterable)JarSearchingUtilKt.findKotlinScriptRuntimeClasspath(project)), (Iterable)JarSearchingUtilKt.findKotlinReflectClasspath(project));
    }

    @NotNull
    public static final List<File> findKotlinMetadataCompilerClasspath(@NotNull Project project) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List it = list = JarSearchingUtilKt.findKotlinModuleJar(project, K2METADATA_COMPILER_CLASS, KOTLIN_COMPILER_EMBEDDABLE);
        return it.isEmpty() ? it : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)it, (Iterable)JarSearchingUtilKt.findKotlinStdlibClasspath(project)), (Iterable)JarSearchingUtilKt.findKotlinScriptRuntimeClasspath(project)), (Iterable)JarSearchingUtilKt.findKotlinReflectClasspath(project));
    }

    @NotNull
    public static final List<File> findKotlinJsDceClasspath(@NotNull Project project) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List it = list = JarSearchingUtilKt.findKotlinModuleJar(project, K2JS_DCE_CLASS, KOTLIN_COMPILER_EMBEDDABLE);
        return it.isEmpty() ? it : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)it, (Iterable)JarSearchingUtilKt.findKotlinStdlibClasspath(project)), (Iterable)JarSearchingUtilKt.findKotlinScriptRuntimeClasspath(project)), (Iterable)JarSearchingUtilKt.findKotlinReflectClasspath(project));
    }

    @NotNull
    public static final List<File> findKotlinStdlibClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return JarSearchingUtilKt.findKotlinModuleJar(project, KOTLIN_STDLIB_EXPECTED_CLASS, KOTLIN_STDLIB);
    }

    @NotNull
    public static final List<File> findKotlinScriptRuntimeClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return JarSearchingUtilKt.findKotlinModuleJar(project, KOTLIN_SCRIPT_RUNTIME_EXPECTED_CLASS, KOTLIN_SCRIPT_RUNTIME);
    }

    @NotNull
    public static final List<File> findKotlinReflectClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return JarSearchingUtilKt.findKotlinModuleJar(project, KOTLIN_REFLECT_EXPECTED_CLASS, KOTLIN_REFLECT);
    }

    @Nullable
    public static final File findToolsJar() {
        File file;
        Class<?> clazz = Class.forName("com.sun.tools.javac.util.Context");
        if (clazz != null) {
            Class<?> clazz2;
            Class<?> p1 = clazz2 = clazz;
            file = JarSearchingUtilKt.findJarByClass(p1);
        } else {
            file = null;
        }
        return file;
    }

    private static final File findJarByClass(Class<?> klass) {
        String classFileName = StringsKt.substringAfterLast$default((String)klass.getName(), (String)".", null, (int)2, null) + ".class";
        URL uRL = klass.getResource(classFileName);
        if (uRL == null) {
            return null;
        }
        URL resource = uRL;
        String uri = resource.toString();
        if (!StringsKt.startsWith$default((String)uri, (String)"jar:file:", (boolean)false, (int)2, null)) {
            return null;
        }
        String fileName = URLDecoder.decode(StringsKt.substringBefore$default((String)StringsKt.removePrefix((String)uri, (CharSequence)"jar:file:"), (String)"!", null, (int)2, null), Charset.defaultCharset().name());
        return new File(fileName);
    }

    private static final List<File> findKotlinModuleJar(Project project, String expectedClassName, String moduleId) {
        File file;
        File it;
        Object object;
        Object v6;
        block4: {
            File file2;
            Sequence sequence;
            Sequence sequence2;
            String pluginVersion = JarSearchingUtilKt.pluginVersionFromAppliedPlugin(project);
            Sequence sequence3 = new File[1];
            Sequence sequence4 = sequence3;
            Sequence sequence5 = sequence3;
            int n = 0;
            String string = pluginVersion;
            if (string != null) {
                String string2 = string;
                int n2 = n;
                sequence2 = sequence4;
                sequence = sequence5;
                String version2 = string2;
                File file3 = JarSearchingUtilKt.getModuleFromClassLoader(moduleId, version2);
                sequence5 = sequence;
                sequence4 = sequence2;
                n = n2;
                file2 = file3;
            } else {
                file2 = null;
            }
            sequence4[n] = file2;
            sequence = SequencesKt.sequenceOf((Object[])sequence5);
            sequence2 = (Sequence)new Sequence<File>(project, moduleId){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ String $moduleId$inlined;
                {
                    this.$project$inlined = project;
                    this.$moduleId$inlined = string;
                }

                @NotNull
                public Iterator<File> iterator() {
                    return JarSearchingUtilKt.access$findPotentialModuleJars(this.$project$inlined, this.$moduleId$inlined).iterator();
                }
            };
            Sequence filesToCheck = SequencesKt.plus((Sequence)sequence, (Sequence)sequence2);
            String entryToFind = StringsKt.replace$default((String)expectedClassName, (String)".", (String)"/", (boolean)false, (int)4, null) + ".class";
            Sequence $receiver$iv = SequencesKt.filterNotNull((Sequence)filesToCheck);
            for (Object element$iv : $receiver$iv) {
                File it2 = (File)element$iv;
                if (!JarSearchingUtilKt.hasEntry(it2, entryToFind)) continue;
                v6 = element$iv;
                break block4;
            }
            v6 = null;
        }
        if ((object = (File)v6) == null || (object = CollectionsKt.listOf((Object)(it = (file = object)))) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final String pluginVersionFromAppliedPlugin(Project project) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)project.getPlugins();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KotlinBasePluginWrapper)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KotlinBasePluginWrapper kotlinBasePluginWrapper = (KotlinBasePluginWrapper)CollectionsKt.firstOrNull((List)((List)var3_3));
        return kotlinBasePluginWrapper != null ? kotlinBasePluginWrapper.getKotlinPluginVersion() : null;
    }

    private static final File getModuleFromClassLoader(String moduleId, String moduleVersion) {
        Serializable serializable;
        Object object;
        block5: {
            ClassLoader classLoader = KotlinPlugin.class.getClassLoader();
            if (!(classLoader instanceof URLClassLoader)) {
                classLoader = null;
            }
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
            if (uRLClassLoader == null) {
                return null;
            }
            URLClassLoader urlClassLoader = uRLClassLoader;
            Object[] $receiver$iv = urlClassLoader.getURLs();
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                URL it = (URL)element$iv;
                if (!StringsKt.endsWith$default((String)it.toString(), (String)("" + moduleId + '-' + moduleVersion + ".jar"), (boolean)false, (int)2, null)) continue;
                object = element$iv;
                break block5;
            }
            object = null;
        }
        URL uRL = (URL)object;
        if (uRL != null) {
            Serializable serializable2 = uRL;
            URL it = serializable2;
            serializable2 = new File(it.toURI());
            Serializable p1 = serializable2;
            serializable = ((File)p1).exists() ? serializable2 : null;
        } else {
            serializable = null;
        }
        return serializable;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable<File> findPotentialModuleJars(Project project, String moduleId) {
        Sequence projects2 = SequencesKt.generateSequence((Object)project, (Function1)findPotentialModuleJars.projects.1.INSTANCE);
        Sequence classpathConfigurations2 = SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)projects2, (Function1)findPotentialModuleJars.classpathConfigurations.1.INSTANCE));
        HashSet allFiles = new HashSet();
        for (Configuration configuration : classpathConfigurations2) {
            ResolvedDependency compilerEmbeddable = JarSearchingUtilKt.findKotlinModuleDependency(configuration, moduleId);
            if (compilerEmbeddable != null) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)compilerEmbeddable.getModuleArtifacts();
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    ResolvedArtifact resolvedArtifact = (ResolvedArtifact)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    File file = it.getFile();
                    collection.add(file);
                }
                return (List)destination$iv$iv;
            }
            allFiles.addAll(configuration.getFiles());
        }
        return allFiles;
    }

    private static final ResolvedDependency findKotlinModuleDependency(Configuration configuration, String moduleId) {
        findKotlinModuleDependency.1 findDependency$ = findKotlinModuleDependency.1.INSTANCE;
        Set firstLevelModuleDependencies = configuration.getResolvedConfiguration().getFirstLevelModuleDependencies();
        ResolvedDependency gradlePlugin = findDependency$.invoke(firstLevelModuleDependencies, KOTLIN_MODULE_GROUP, KOTLIN_GRADLE_PLUGIN);
        Object object = gradlePlugin;
        return object != null && (object = object.getChildren()) != null ? findDependency$.invoke((Iterable)object, KOTLIN_MODULE_GROUP, moduleId) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean hasEntry(@NotNull File $receiver, String entryToFind) {
        try (ZipFile zip = new ZipFile($receiver);){
            boolean bl = zip.getEntry(entryToFind) != null;
            return bl;
        }
    }

    static {
        K2JVM_COMPILER_CLASS = K2JVM_COMPILER_CLASS;
        K2JS_COMPILER_CLASS = K2JS_COMPILER_CLASS;
        K2JS_DCE_CLASS = K2JS_DCE_CLASS;
        K2METADATA_COMPILER_CLASS = K2METADATA_COMPILER_CLASS;
        KOTLIN_STDLIB_EXPECTED_CLASS = KOTLIN_STDLIB_EXPECTED_CLASS;
        KOTLIN_SCRIPT_RUNTIME_EXPECTED_CLASS = KOTLIN_SCRIPT_RUNTIME_EXPECTED_CLASS;
        KOTLIN_REFLECT_EXPECTED_CLASS = KOTLIN_REFLECT_EXPECTED_CLASS;
        KOTLIN_MODULE_GROUP = KOTLIN_MODULE_GROUP;
        KOTLIN_GRADLE_PLUGIN = KOTLIN_GRADLE_PLUGIN;
        KOTLIN_COMPILER_EMBEDDABLE = KOTLIN_COMPILER_EMBEDDABLE;
        KOTLIN_STDLIB = KOTLIN_STDLIB;
        KOTLIN_SCRIPT_RUNTIME = KOTLIN_SCRIPT_RUNTIME;
        KOTLIN_REFLECT = KOTLIN_REFLECT;
    }

    @NotNull
    public static final /* synthetic */ Iterable access$findPotentialModuleJars(@NotNull Project project, @NotNull String moduleId) {
        return JarSearchingUtilKt.findPotentialModuleJars(project, moduleId);
    }
}

