/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.incremental.BuildCacheStorage;
import org.jetbrains.kotlin.incremental.CacheVersion;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.JvmUtilsKt;
import org.jetbrains.kotlin.incremental.multiproject.ArtifactDifferenceRegistry;
import org.jetbrains.kotlin.incremental.multiproject.ArtifactDifferenceRegistryImpl;
import org.jetbrains.kotlin.incremental.multiproject.ArtifactDifferenceRegistryProvider;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J=\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0000\u0010\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00150\u0017H\u0017\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/incremental/BuildCacheStorage;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "Lorg/jetbrains/kotlin/incremental/multiproject/ArtifactDifferenceRegistryProvider;", "workingDir", "Ljava/io/File;", "(Ljava/io/File;)V", "artifactDifferenceRegistry", "Lorg/jetbrains/kotlin/incremental/multiproject/ArtifactDifferenceRegistryImpl;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "version", "Lorg/jetbrains/kotlin/incremental/CacheVersion;", "versionFile", "clean", "", "close", "flush", "memoryCachesOnly", "", "withRegistry", "T", "report", "Lkotlin/Function1;", "", "fn", "Lorg/jetbrains/kotlin/incremental/multiproject/ArtifactDifferenceRegistry;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "kotlin-gradle-plugin"})
public final class BuildCacheStorage
extends BasicMapsOwner
implements ArtifactDifferenceRegistryProvider {
    private final Logger log;
    private final File versionFile;
    private final CacheVersion version;
    private volatile ArtifactDifferenceRegistryImpl artifactDifferenceRegistry;
    private final File workingDir;
    private static final int OWN_VERSION = 0;
    private static final String ARTIFACT_DIFFERENCE = "artifact-difference";
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public synchronized <T> T withRegistry(@NotNull Function1<? super String, Unit> report2, @NotNull Function1<? super ArtifactDifferenceRegistry, ? extends T> fn) {
        Intrinsics.checkParameterIsNotNull(report2, (String)"report");
        Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
        try {
            if (this.artifactDifferenceRegistry == null) {
                this.artifactDifferenceRegistry = (ArtifactDifferenceRegistryImpl)this.registerMap((BasicMap)new ArtifactDifferenceRegistryImpl(this.getStorageFile(BuildCacheStorage.Companion.getARTIFACT_DIFFERENCE())));
            }
            ArtifactDifferenceRegistryImpl artifactDifferenceRegistryImpl = this.artifactDifferenceRegistry;
            if (artifactDifferenceRegistryImpl == null) {
                Intrinsics.throwNpe();
            }
            return (T)fn.invoke((Object)artifactDifferenceRegistryImpl);
        }
        catch (Throwable e1) {
            report2.invoke((Object)("Error accessing artifact file difference registry: " + JvmUtilsKt.getStackTraceStr(e1) + '}'));
            report2.invoke((Object)"Cleaning artifact difference storage and trying again");
            this.clean();
            try {
                ArtifactDifferenceRegistryImpl artifactDifferenceRegistryImpl = this.artifactDifferenceRegistry = (ArtifactDifferenceRegistryImpl)this.registerMap((BasicMap)new ArtifactDifferenceRegistryImpl(this.getStorageFile(BuildCacheStorage.Companion.getARTIFACT_DIFFERENCE())));
                if (artifactDifferenceRegistryImpl == null) {
                    Intrinsics.throwNpe();
                }
                return (T)fn.invoke((Object)artifactDifferenceRegistryImpl);
            }
            catch (Throwable e2) {
                report2.invoke((Object)("Second error accessing artifact file difference registry: " + JvmUtilsKt.getStackTraceStr(e2) + '}'));
                return null;
            }
        }
    }

    @Override
    public synchronized void clean() {
        block2: {
            try {
                this.close();
            }
            catch (Throwable e) {
                Logger logger = this.log;
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
                Logger $receiver$iv = logger;
                if (!$receiver$iv.isDebugEnabled()) break block2;
                Logger logger2 = $receiver$iv;
                String string = "Exception while closing caches: " + JvmUtilsKt.getStackTraceStr(e);
                GradleUtilsKt.kotlinDebug(logger2, string);
            }
        }
        FilesKt.deleteRecursively((File)this.workingDir);
        this.workingDir.mkdirs();
        this.versionFile.delete();
    }

    public void flush(boolean memoryCachesOnly) {
        super.flush(memoryCachesOnly);
        this.version.saveIfNeeded();
    }

    public void close() {
        super.close();
        this.artifactDifferenceRegistry = null;
    }

    public BuildCacheStorage(@NotNull File workingDir2) {
        Intrinsics.checkParameterIsNotNull((Object)workingDir2, (String)"workingDir");
        super(workingDir2);
        this.workingDir = workingDir2;
        this.log = Logging.getLogger(this.getClass());
        this.versionFile = new File(this.workingDir, "version.txt");
        Function0 function0 = version.1.INSTANCE;
        CacheVersion.Action action = CacheVersion.Action.REBUILD_ALL_KOTLIN;
        CacheVersion.Action action2 = CacheVersion.Action.REBUILD_ALL_KOTLIN;
        this.version = new CacheVersion(BuildCacheStorage.Companion.getOWN_VERSION(), this.versionFile, CacheVersion.Action.REBUILD_ALL_KOTLIN, action, action2, function0);
        if (this.version.checkVersion() != CacheVersion.Action.DO_NOTHING) {
            Logger logger = this.log;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
            Logger $receiver$iv = logger;
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger2 = $receiver$iv;
                String string = "Cache version is not up-to-date";
                GradleUtilsKt.kotlinDebug(logger2, string);
            }
            this.clean();
        }
    }

    static {
        ARTIFACT_DIFFERENCE = ARTIFACT_DIFFERENCE;
    }

    @Override
    @Nullable
    public <T> T withRegistry(@NotNull ICReporter reporter, @NotNull Function1<? super ArtifactDifferenceRegistry, ? extends T> fn) {
        Intrinsics.checkParameterIsNotNull((Object)reporter, (String)"reporter");
        Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
        return ArtifactDifferenceRegistryProvider.DefaultImpls.withRegistry(this, reporter, fn);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/incremental/BuildCacheStorage$Companion;", "", "()V", "ARTIFACT_DIFFERENCE", "", "getARTIFACT_DIFFERENCE", "()Ljava/lang/String;", "OWN_VERSION", "", "getOWN_VERSION", "()I", "kotlin-gradle-plugin"})
    public static final class Companion {
        private final int getOWN_VERSION() {
            return OWN_VERSION;
        }

        private final String getARTIFACT_DIFFERENCE() {
            return ARTIFACT_DIFFERENCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

