/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerRunner;
import org.jetbrains.kotlin.gradle.plugin.CompilerServicesCleanup;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;
import org.jetbrains.kotlin.incremental.BuildCacheStorage;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.JvmUtilsKt;
import org.jetbrains.kotlin.incremental.multiproject.ArtifactDifferenceRegistryProvider;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0006\u0010\"\u001a\u00020\u001fJ\b\u0010#\u001a\u00020\u001fH\u0002J\b\u0010$\u001a\u00020\u0017H\u0002J\u000f\u0010%\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010&R\u0014\u0010\u0005\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u001b\u0010\u0019\u001a\u00020\u001a8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u000e\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "Lorg/gradle/BuildAdapter;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "(Lorg/gradle/api/invocation/Gradle;)V", "artifactDifferenceRegistryProvider", "Lorg/jetbrains/kotlin/incremental/multiproject/ArtifactDifferenceRegistryProvider;", "getArtifactDifferenceRegistryProvider$kotlin_gradle_plugin", "()Lorg/jetbrains/kotlin/incremental/multiproject/ArtifactDifferenceRegistryProvider;", "buildCacheStorage", "Lorg/jetbrains/kotlin/incremental/BuildCacheStorage;", "getBuildCacheStorage", "()Lorg/jetbrains/kotlin/incremental/BuildCacheStorage;", "buildCacheStorage$delegate", "Lkotlin/Lazy;", "cleanup", "Lorg/jetbrains/kotlin/gradle/plugin/CompilerServicesCleanup;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "shouldReportMemoryUsage", "", "startMemory", "", "Ljava/lang/Long;", "workingDir", "Ljava/io/File;", "getWorkingDir$kotlin_gradle_plugin", "()Ljava/io/File;", "workingDir$delegate", "buildFinished", "", "result", "Lorg/gradle/BuildResult;", "buildStarted", "closeArtifactDifferenceRegistry", "getGcCount", "getUsedMemoryKb", "()Ljava/lang/Long;", "Companion", "kotlin-gradle-plugin"})
public final class KotlinGradleBuildServices
extends BuildAdapter {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Logger log = Logging.getLogger(((Object)((Object)this)).getClass());
    private final CompilerServicesCleanup cleanup = new CompilerServicesCleanup();
    private Long startMemory;
    @NotNull
    private final Lazy workingDir$delegate;
    private final Lazy buildCacheStorage$delegate;
    private final boolean shouldReportMemoryUsage;
    private static final String CLASS_NAME;
    @NotNull
    public static final String FORCE_SYSTEM_GC_MESSAGE = "Forcing System.gc()";
    @NotNull
    public static final String SHOULD_REPORT_MEMORY_USAGE_PROPERTY = "kotlin.gradle.test.report.memory.usage";
    @NotNull
    private static final String INIT_MESSAGE;
    @NotNull
    private static final String DISPOSE_MESSAGE;
    @NotNull
    private static final String ALREADY_INITIALIZED_MESSAGE;
    private static volatile KotlinGradleBuildServices instance;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(KotlinGradleBuildServices.class), "workingDir", "getWorkingDir$kotlin_gradle_plugin()Ljava/io/File;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(KotlinGradleBuildServices.class), "buildCacheStorage", "getBuildCacheStorage()Lorg/jetbrains/kotlin/incremental/BuildCacheStorage;"))};
        Companion = new Companion(null);
        CLASS_NAME = KotlinGradleBuildServices.class.getSimpleName();
        INIT_MESSAGE = "Initialized " + CLASS_NAME;
        DISPOSE_MESSAGE = "Disposed " + CLASS_NAME;
        ALREADY_INITIALIZED_MESSAGE = "" + CLASS_NAME + " is already initialized";
    }

    @NotNull
    public final File getWorkingDir$kotlin_gradle_plugin() {
        Lazy lazy = this.workingDir$delegate;
        KotlinGradleBuildServices kotlinGradleBuildServices = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (File)lazy.getValue();
    }

    private final BuildCacheStorage getBuildCacheStorage() {
        Lazy lazy = this.buildCacheStorage$delegate;
        KotlinGradleBuildServices kotlinGradleBuildServices = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (BuildCacheStorage)lazy.getValue();
    }

    @NotNull
    public final ArtifactDifferenceRegistryProvider getArtifactDifferenceRegistryProvider$kotlin_gradle_plugin() {
        return this.getBuildCacheStorage();
    }

    public final void buildStarted() {
        this.startMemory = this.getUsedMemoryKb();
    }

    public void buildFinished(@NotNull BuildResult result) {
        CharSequence charSequence;
        Logger logger;
        Project rootProject;
        boolean kotlinCompilerCalled;
        Gradle gradle;
        block13: {
            boolean bl;
            Iterator $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
            Gradle gradle2 = result.getGradle();
            if (gradle2 == null) {
                Intrinsics.throwNpe();
            }
            Gradle gradle3 = gradle = gradle2;
            Intrinsics.checkExpressionValueIsNotNull((Object)gradle3, (String)"gradle");
            Project project = gradle3.getRootProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"gradle.rootProject");
            Set set = project.getAllprojects();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"gradle.rootProject\n                .allprojects");
            Iterable iterable = set;
            void var5_4 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Project it;
                Object element$iv$iv = iterator.next();
                Project project2 = it = (Project)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"it");
                Iterable list$iv$iv = (Iterable)project2.getTasks();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Task it = (Task)element$iv;
                    if (!(it instanceof AbstractKotlinCompile && ((AbstractKotlinCompile)it).getCompilerCalled$kotlin_gradle_plugin())) continue;
                    bl = true;
                    break block13;
                }
                bl = kotlinCompilerCalled = false;
            }
        }
        if (kotlinCompilerCalled) {
            Logger logger2 = this.log;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"log");
            GradleUtilsKt.kotlinDebug(logger2, "Cleanup after kotlin");
            String string = gradle.getGradleVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gradle.gradleVersion");
            this.cleanup.invoke(string);
        } else {
            Logger logger3 = this.log;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger3, (String)"log");
            GradleUtilsKt.kotlinDebug(logger3, "Skipping kotlin cleanup since compiler wasn't called");
        }
        Project project = rootProject = gradle.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"rootProject");
        File sessionsDir = GradleCompilerRunner.Companion.sessionsDir$kotlin_gradle_plugin(project);
        if (sessionsDir.exists()) {
            File[] sessionFiles = sessionsDir.listFiles();
            if (sessionFiles.length > 1) {
                this.log.warn("w: Detected multiple Kotlin daemon sessions at " + FileUtilsKt.relativeToRoot(sessionsDir, rootProject));
            }
            for (File file : sessionFiles) {
                Logger $receiver$iv;
                file.delete();
                Intrinsics.checkExpressionValueIsNotNull((Object)this.log, (String)"log");
                if (!$receiver$iv.isDebugEnabled()) continue;
                logger = $receiver$iv;
                StringBuilder stringBuilder = new StringBuilder().append("Deleted session-is-alive flag file: ");
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                charSequence = stringBuilder.append(FileUtilsKt.relativeToRoot(file2, rootProject)).toString();
                GradleUtilsKt.kotlinDebug(logger, (String)charSequence);
            }
        }
        if (this.shouldReportMemoryUsage) {
            Long l = this.startMemory;
            if (l == null) {
                Intrinsics.throwNpe();
            }
            long startMem = l;
            Long l2 = this.getUsedMemoryKb();
            if (l2 == null) {
                Intrinsics.throwNpe();
            }
            long endMem = l2;
            String string = "%+d";
            Object[] objectArray = new Object[]{endMem - startMem};
            charSequence = new StringBuilder().append("[KOTLIN][PERF] Used memory after build: ").append(endMem).append(" kb (difference since build start: ");
            logger = this.log;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
            String string3 = string2;
            logger.lifecycle(((StringBuilder)charSequence).append(string3).append(" kb)").toString());
        }
        this.closeArtifactDifferenceRegistry();
        gradle.removeListener((Object)this);
        instance = null;
        Logger logger4 = this.log;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger4, (String)"log");
        GradleUtilsKt.kotlinDebug(logger4, DISPOSE_MESSAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeArtifactDifferenceRegistry() {
        block18: {
            String string;
            Logger logger;
            Logger $receiver$iv;
            boolean caughtError = false;
            try {
                if (this.getWorkingDir$kotlin_gradle_plugin().exists()) {
                    this.getBuildCacheStorage().flush(false);
                }
            }
            catch (Throwable e) {
                Logger logger2 = this.log;
                Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"log");
                $receiver$iv = logger2;
                if ($receiver$iv.isDebugEnabled()) {
                    logger = $receiver$iv;
                    string = "Error trying to flush artifact difference registry: " + JvmUtilsKt.getStackTraceStr(e);
                    GradleUtilsKt.kotlinDebug(logger, string);
                }
                caughtError = true;
            }
            finally {
                try {
                    this.getBuildCacheStorage().close();
                }
                catch (Throwable e) {
                    Logger logger3 = this.log;
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger3, (String)"log");
                    $receiver$iv = logger3;
                    if ($receiver$iv.isDebugEnabled()) {
                        logger = $receiver$iv;
                        string = "Error trying to close artifact difference registry: " + JvmUtilsKt.getStackTraceStr(e);
                        GradleUtilsKt.kotlinDebug(logger, string);
                    }
                    caughtError = true;
                }
            }
            if (caughtError && this.getWorkingDir$kotlin_gradle_plugin().exists()) {
                try {
                    FilesKt.deleteRecursively((File)this.getWorkingDir$kotlin_gradle_plugin());
                }
                catch (Throwable e) {
                    Logger logger4 = this.log;
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger4, (String)"log");
                    $receiver$iv = logger4;
                    if (!$receiver$iv.isDebugEnabled()) break block18;
                    logger = $receiver$iv;
                    string = "Error trying to delete kotlin-build " + this.getWorkingDir$kotlin_gradle_plugin() + ": " + JvmUtilsKt.getStackTraceStr(e);
                    GradleUtilsKt.kotlinDebug(logger, string);
                }
            }
        }
    }

    private final Long getUsedMemoryKb() {
        if (!this.shouldReportMemoryUsage) {
            return null;
        }
        this.log.lifecycle(FORCE_SYSTEM_GC_MESSAGE);
        long gcCountBefore = this.getGcCount();
        System.gc();
        while (this.getGcCount() == gcCountBefore) {
        }
        Runtime rt = Runtime.getRuntime();
        return (rt.totalMemory() - rt.freeMemory()) / (long)1024;
    }

    /*
     * WARNING - void declaration
     */
    private final long getGcCount() {
        void var2_2;
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"ManagementFactory.getGarbageCollectorMXBeans()");
        Iterable $receiver$iv = list;
        long sum$iv = 0L;
        for (Object element$iv : $receiver$iv) {
            void it;
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)element$iv;
            long l = sum$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            long l2 = Math.max(0L, v1.getCollectionCount());
            sum$iv = l + l2;
        }
        return (long)var2_2;
    }

    private KotlinGradleBuildServices(Gradle gradle) {
        this.workingDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(gradle){
            final /* synthetic */ Gradle $gradle;

            @NotNull
            public final File invoke() {
                File file;
                Project project = this.$gradle.getRootProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"gradle.rootProject");
                File $receiver = file = new File(project.getBuildDir(), "kotlin-build");
                $receiver.mkdirs();
                return file;
            }
            {
                this.$gradle = gradle;
                super(0);
            }
        }));
        this.buildCacheStorage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BuildCacheStorage>(this){
            final /* synthetic */ KotlinGradleBuildServices this$0;

            @NotNull
            public final BuildCacheStorage invoke() {
                return new BuildCacheStorage(this.this$0.getWorkingDir$kotlin_gradle_plugin());
            }
            {
                this.this$0 = kotlinGradleBuildServices;
                super(0);
            }
        }));
        this.shouldReportMemoryUsage = System.getProperty(SHOULD_REPORT_MEMORY_USAGE_PROPERTY) != null;
    }

    public /* synthetic */ KotlinGradleBuildServices(@NotNull Gradle gradle, DefaultConstructorMarker $constructor_marker) {
        this(gradle);
    }

    @JvmStatic
    @NotNull
    public static final synchronized KotlinGradleBuildServices getInstance(@NotNull Gradle gradle) {
        return Companion.getInstance(gradle);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices$Companion;", "", "()V", "ALREADY_INITIALIZED_MESSAGE", "", "getALREADY_INITIALIZED_MESSAGE", "()Ljava/lang/String;", "CLASS_NAME", "kotlin.jvm.PlatformType", "DISPOSE_MESSAGE", "getDISPOSE_MESSAGE", "FORCE_SYSTEM_GC_MESSAGE", "INIT_MESSAGE", "getINIT_MESSAGE", "SHOULD_REPORT_MEMORY_USAGE_PROPERTY", "instance", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "getInstance", "gradle", "Lorg/gradle/api/invocation/Gradle;", "kotlin-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final String getINIT_MESSAGE() {
            return INIT_MESSAGE;
        }

        @NotNull
        public final String getDISPOSE_MESSAGE() {
            return DISPOSE_MESSAGE;
        }

        @NotNull
        public final String getALREADY_INITIALIZED_MESSAGE() {
            return ALREADY_INITIALIZED_MESSAGE;
        }

        @JvmStatic
        @NotNull
        public final synchronized KotlinGradleBuildServices getInstance(@NotNull Gradle gradle) {
            Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
            Logger log = Logging.getLogger(KotlinGradleBuildServices.class);
            if (instance != null) {
                Logger logger = log;
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
                GradleUtilsKt.kotlinDebug(logger, this.getALREADY_INITIALIZED_MESSAGE());
                KotlinGradleBuildServices kotlinGradleBuildServices = instance;
                if (kotlinGradleBuildServices == null) {
                    Intrinsics.throwNpe();
                }
                return kotlinGradleBuildServices;
            }
            KotlinGradleBuildServices services = new KotlinGradleBuildServices(gradle, null);
            gradle.addBuildListener((BuildListener)services);
            instance = services;
            Logger logger = log;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
            GradleUtilsKt.kotlinDebug(logger, this.getINIT_MESSAGE());
            services.buildStarted();
            return services;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

