/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerRunner;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u000eJ\b\u0010\u0012\u001a\u00020\u000bH\u0002J\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0014R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "Lorg/gradle/BuildAdapter;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "(Lorg/gradle/api/invocation/Gradle;)V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "shouldReportMemoryUsage", "", "startMemory", "", "Ljava/lang/Long;", "buildFinished", "", "result", "Lorg/gradle/BuildResult;", "buildStarted", "getGcCount", "getUsedMemoryKb", "()Ljava/lang/Long;", "Companion", "kotlin-gradle-plugin"})
public final class KotlinGradleBuildServices
extends BuildAdapter {
    private final Logger log = Logging.getLogger(((Object)((Object)this)).getClass());
    private Long startMemory;
    private final boolean shouldReportMemoryUsage = System.getProperty("kotlin.gradle.test.report.memory.usage") != null;
    private static final String CLASS_NAME;
    @NotNull
    public static final String FORCE_SYSTEM_GC_MESSAGE = "Forcing System.gc()";
    @NotNull
    public static final String SHOULD_REPORT_MEMORY_USAGE_PROPERTY = "kotlin.gradle.test.report.memory.usage";
    @NotNull
    private static final String INIT_MESSAGE;
    @NotNull
    private static final String DISPOSE_MESSAGE;
    @NotNull
    private static final String ALREADY_INITIALIZED_MESSAGE;
    private static volatile KotlinGradleBuildServices instance;
    public static final Companion Companion;

    public final void buildStarted() {
        this.startMemory = this.getUsedMemoryKb();
    }

    public void buildFinished(@NotNull BuildResult result) {
        CharSequence charSequence;
        Logger logger;
        Project rootProject;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Gradle gradle = result.getGradle();
        if (gradle == null) {
            Intrinsics.throwNpe();
        }
        Gradle gradle2 = gradle;
        GradleCompilerRunner.Companion.clearBuildModulesInfo$kotlin_gradle_plugin();
        Gradle gradle3 = gradle2;
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle3, (String)"gradle");
        Project project = rootProject = gradle3.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"rootProject");
        File sessionsDir = GradleCompilerRunner.Companion.sessionsDir$kotlin_gradle_plugin(project);
        if (sessionsDir.exists()) {
            File[] sessionFiles = sessionsDir.listFiles();
            if (sessionFiles.length > 1) {
                this.log.warn("w: Detected multiple Kotlin daemon sessions at " + FileUtilsKt.relativeToRoot(sessionsDir, rootProject));
            }
            for (File file : sessionFiles) {
                Logger $receiver$iv;
                file.delete();
                Intrinsics.checkExpressionValueIsNotNull((Object)this.log, (String)"log");
                if (!$receiver$iv.isDebugEnabled()) continue;
                logger = $receiver$iv;
                StringBuilder stringBuilder = new StringBuilder().append("Deleted session-is-alive flag file: ");
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                charSequence = stringBuilder.append(FileUtilsKt.relativeToRoot(file2, rootProject)).toString();
                GradleUtilsKt.kotlinDebug(logger, (String)charSequence);
            }
        }
        if (this.shouldReportMemoryUsage) {
            Long l = this.startMemory;
            if (l == null) {
                Intrinsics.throwNpe();
            }
            long startMem = l;
            Long l2 = this.getUsedMemoryKb();
            if (l2 == null) {
                Intrinsics.throwNpe();
            }
            long endMem = l2;
            String string = "%+d";
            Object[] objectArray = new Object[]{endMem - startMem};
            charSequence = new StringBuilder().append("[KOTLIN][PERF] Used memory after build: ").append(endMem).append(" kb (difference since build start: ");
            logger = this.log;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
            String string3 = string2;
            logger.lifecycle(((StringBuilder)charSequence).append(string3).append(" kb)").toString());
        }
        gradle2.removeListener((Object)this);
        instance = null;
        Logger logger2 = this.log;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"log");
        GradleUtilsKt.kotlinDebug(logger2, DISPOSE_MESSAGE);
    }

    private final Long getUsedMemoryKb() {
        if (!this.shouldReportMemoryUsage) {
            return null;
        }
        this.log.lifecycle(FORCE_SYSTEM_GC_MESSAGE);
        long gcCountBefore = this.getGcCount();
        System.gc();
        while (this.getGcCount() == gcCountBefore) {
        }
        Runtime rt = Runtime.getRuntime();
        return (rt.totalMemory() - rt.freeMemory()) / (long)1024;
    }

    /*
     * WARNING - void declaration
     */
    private final long getGcCount() {
        void var2_2;
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"ManagementFactory.getGarbageCollectorMXBeans()");
        Iterable $receiver$iv = list;
        long sum$iv = 0L;
        for (Object element$iv : $receiver$iv) {
            void it;
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)element$iv;
            long l = sum$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            long l2 = Math.max(0L, v1.getCollectionCount());
            sum$iv = l + l2;
        }
        return (long)var2_2;
    }

    private KotlinGradleBuildServices(Gradle gradle) {
    }

    static {
        Companion = new Companion(null);
        CLASS_NAME = KotlinGradleBuildServices.class.getSimpleName();
        INIT_MESSAGE = "Initialized " + CLASS_NAME;
        DISPOSE_MESSAGE = "Disposed " + CLASS_NAME;
        ALREADY_INITIALIZED_MESSAGE = CLASS_NAME + " is already initialized";
    }

    public /* synthetic */ KotlinGradleBuildServices(@NotNull Gradle gradle, DefaultConstructorMarker $constructor_marker) {
        this(gradle);
    }

    @JvmStatic
    @NotNull
    public static final synchronized KotlinGradleBuildServices getInstance(@NotNull Gradle gradle) {
        return Companion.getInstance(gradle);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices$Companion;", "", "()V", "ALREADY_INITIALIZED_MESSAGE", "", "getALREADY_INITIALIZED_MESSAGE", "()Ljava/lang/String;", "CLASS_NAME", "kotlin.jvm.PlatformType", "DISPOSE_MESSAGE", "getDISPOSE_MESSAGE", "FORCE_SYSTEM_GC_MESSAGE", "INIT_MESSAGE", "getINIT_MESSAGE", "SHOULD_REPORT_MEMORY_USAGE_PROPERTY", "instance", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "getInstance", "gradle", "Lorg/gradle/api/invocation/Gradle;", "kotlin-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final String getINIT_MESSAGE() {
            return INIT_MESSAGE;
        }

        @NotNull
        public final String getDISPOSE_MESSAGE() {
            return DISPOSE_MESSAGE;
        }

        @NotNull
        public final String getALREADY_INITIALIZED_MESSAGE() {
            return ALREADY_INITIALIZED_MESSAGE;
        }

        @JvmStatic
        @NotNull
        public final synchronized KotlinGradleBuildServices getInstance(@NotNull Gradle gradle) {
            Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
            Logger log = Logging.getLogger(KotlinGradleBuildServices.class);
            if (instance != null) {
                Logger logger = log;
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
                GradleUtilsKt.kotlinDebug(logger, this.getALREADY_INITIALIZED_MESSAGE());
                KotlinGradleBuildServices kotlinGradleBuildServices = instance;
                if (kotlinGradleBuildServices == null) {
                    Intrinsics.throwNpe();
                }
                return kotlinGradleBuildServices;
            }
            KotlinGradleBuildServices services = new KotlinGradleBuildServices(gradle, null);
            gradle.addBuildListener((BuildListener)services);
            instance = services;
            Logger logger = log;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
            GradleUtilsKt.kotlinDebug(logger, this.getINIT_MESSAGE());
            services.buildStarted();
            return services;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

