/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.gradle.dsl.KotlinCommonOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinCompile;
import org.jetbrains.kotlin.gradle.plugin.LanguageSettingsBuilder;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0000\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0000\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"apiVersionValues", "", "Lorg/jetbrains/kotlin/config/ApiVersion;", "applyLanguageSettingsToKotlinTask", "", "languageSettingsBuilder", "Lorg/jetbrains/kotlin/gradle/plugin/LanguageSettingsBuilder;", "kotlinTask", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinCompile;", "parseApiVersionSettings", "versionString", "", "parseLanguageFeature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "featureName", "parseLanguageVersionSetting", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "kotlin-gradle-plugin"})
public final class DefaultLanguageSettingsBuilderKt {
    private static final List<ApiVersion> apiVersionValues;

    public static final void applyLanguageSettingsToKotlinTask(@NotNull LanguageSettingsBuilder languageSettingsBuilder, @NotNull KotlinCompile<?> kotlinTask) {
        Intrinsics.checkParameterIsNotNull((Object)languageSettingsBuilder, (String)"languageSettingsBuilder");
        Intrinsics.checkParameterIsNotNull(kotlinTask, (String)"kotlinTask");
        KotlinCommonOptions kotlinCommonOptions = kotlinTask.getKotlinOptions();
        boolean bl = false;
        boolean bl2 = false;
        KotlinCommonOptions $receiver = kotlinCommonOptions;
        boolean bl3 = false;
        String string = $receiver.getLanguageVersion();
        if (string == null) {
            string = languageSettingsBuilder.getLanguageVersion();
        }
        $receiver.setLanguageVersion(string);
        String string2 = $receiver.getApiVersion();
        if (string2 == null) {
            string2 = languageSettingsBuilder.getApiVersion();
        }
        $receiver.setApiVersion(string2);
        if (languageSettingsBuilder.getProgressiveMode()) {
            KotlinCommonOptions kotlinCommonOptions2 = $receiver;
            kotlinCommonOptions2.setFreeCompilerArgs(CollectionsKt.plus((Collection)kotlinCommonOptions2.getFreeCompilerArgs(), (Object)"-progressive"));
        }
        Iterable $this$forEach$iv = languageSettingsBuilder.getEnabledLanguageFeatures();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String featureName = (String)element$iv;
            boolean bl4 = false;
            KotlinCommonOptions kotlinCommonOptions3 = $receiver;
            kotlinCommonOptions3.setFreeCompilerArgs(CollectionsKt.plus((Collection)kotlinCommonOptions3.getFreeCompilerArgs(), (Object)("-XXLanguage:+" + featureName)));
        }
        $this$forEach$iv = languageSettingsBuilder.getExperimentalAnnotationsInUse();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String annotationName = (String)element$iv;
            boolean bl5 = false;
            KotlinCommonOptions kotlinCommonOptions4 = $receiver;
            kotlinCommonOptions4.setFreeCompilerArgs(CollectionsKt.plus((Collection)kotlinCommonOptions4.getFreeCompilerArgs(), (Object)("-Xuse-experimental=" + annotationName)));
        }
    }

    @Nullable
    public static final LanguageVersion parseLanguageVersionSetting(@NotNull String versionString) {
        Intrinsics.checkParameterIsNotNull((Object)versionString, (String)"versionString");
        return LanguageVersion.Companion.fromVersionString(versionString);
    }

    @Nullable
    public static final ApiVersion parseApiVersionSettings(@NotNull String versionString) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)versionString, (String)"versionString");
            Iterable iterable = apiVersionValues;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                ApiVersion it = (ApiVersion)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getVersionString(), (Object)versionString)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public static final LanguageFeature parseLanguageFeature(@NotNull String featureName) {
        Intrinsics.checkParameterIsNotNull((Object)featureName, (String)"featureName");
        return LanguageFeature.Companion.fromString(featureName);
    }

    static {
        ApiVersion.Companion companion = ApiVersion.Companion;
        boolean bl = false;
        boolean bl2 = false;
        ApiVersion.Companion $receiver = companion;
        boolean bl3 = false;
        apiVersionValues = CollectionsKt.listOf((Object[])new ApiVersion[]{ApiVersion.KOTLIN_1_0, ApiVersion.KOTLIN_1_1, ApiVersion.KOTLIN_1_2, ApiVersion.KOTLIN_1_3});
    }

    public static final /* synthetic */ List access$getApiVersionValues$p() {
        return apiVersionValues;
    }
}

