/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.gson.internal.bind;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.com.google.gson.TypeAdapter;
import org.jetbrains.kotlin.com.google.gson.TypeAdapterFactory;
import org.jetbrains.kotlin.com.google.gson.internal.$Gson$Types;
import org.jetbrains.kotlin.com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import org.jetbrains.kotlin.com.google.gson.reflect.TypeToken;
import org.jetbrains.kotlin.com.google.gson.stream.JsonReader;
import org.jetbrains.kotlin.com.google.gson.stream.JsonToken;
import org.jetbrains.kotlin.com.google.gson.stream.JsonWriter;

public final class ArrayTypeAdapter<E>
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson2, TypeToken<T> typeToken) {
            Type type = typeToken.getType();
            if (!(type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray())) {
                return null;
            }
            Type componentType = $Gson$Types.getArrayComponentType(type);
            TypeAdapter<?> componentTypeAdapter = gson2.getAdapter(TypeToken.get(componentType));
            return new ArrayTypeAdapter(gson2, componentTypeAdapter, $Gson$Types.getRawType(componentType));
        }
    };
    private final Class<E> componentType;
    private final TypeAdapter<E> componentTypeAdapter;

    public ArrayTypeAdapter(Gson context, TypeAdapter<E> componentTypeAdapter, Class<E> componentType) {
        this.componentTypeAdapter = new TypeAdapterRuntimeTypeWrapper<E>(context, componentTypeAdapter, componentType);
        this.componentType = componentType;
    }

    @Override
    public Object read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        ArrayList<E> list2 = new ArrayList<E>();
        in.beginArray();
        while (in.hasNext()) {
            E instance = this.componentTypeAdapter.read(in);
            list2.add(instance);
        }
        in.endArray();
        int size = list2.size();
        Object array2 = Array.newInstance(this.componentType, size);
        for (int i = 0; i < size; ++i) {
            Array.set(array2, i, list2.get(i));
        }
        return array2;
    }

    @Override
    public void write(JsonWriter out, Object array2) throws IOException {
        if (array2 == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        int length = Array.getLength(array2);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(array2, i);
            this.componentTypeAdapter.write(out, value);
        }
        out.endArray();
    }
}

