/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinJsOptions;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinMultiplatformPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSetProcessor;
import org.jetbrains.kotlin.gradle.plugin.SubpluginEnvironment;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinWithJavaCompilation;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinCompilationData;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinCompilationDataKt;
import org.jetbrains.kotlin.gradle.targets.js.ir.CompilerFlagsKt;
import org.jetbrains.kotlin.gradle.tasks.Kotlin2JsCompile;
import org.jetbrains.kotlin.gradle.tasks.KotlinTasksProvider;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;
import org.jetbrains.kotlin.gradle.utils.KlibUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J4\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/Kotlin2JsSourceSetProcessor;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSetProcessor;", "Lorg/jetbrains/kotlin/gradle/tasks/Kotlin2JsCompile;", "tasksProvider", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;", "kotlinCompilation", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/pm20/KotlinCompilationData;", "(Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;Lorg/jetbrains/kotlin/gradle/plugin/mpp/pm20/KotlinCompilationData;)V", "doRegisterTask", "Lorg/gradle/api/tasks/TaskProvider;", "project", "Lorg/gradle/api/Project;", "taskName", "", "configureAction", "Lkotlin/Function1;", "", "doTargetSpecificProcessing", "kotlin-gradle-plugin"})
public final class Kotlin2JsSourceSetProcessor
extends KotlinSourceSetProcessor<Kotlin2JsCompile> {
    public Kotlin2JsSourceSetProcessor(@NotNull KotlinTasksProvider tasksProvider, @NotNull KotlinCompilationData<?> kotlinCompilation) {
        Intrinsics.checkNotNullParameter((Object)tasksProvider, (String)"tasksProvider");
        Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
        super(tasksProvider, "Compiles the Kotlin sources in " + kotlinCompilation + " to JavaScript.", kotlinCompilation);
    }

    @Override
    @NotNull
    protected TaskProvider<? extends Kotlin2JsCompile> doRegisterTask(@NotNull Project project, @NotNull String taskName, @NotNull Function1<? super Kotlin2JsCompile, Unit> configureAction2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter(configureAction2, (String)"configureAction");
        return this.getTasksProvider().registerKotlinJSTask(project, taskName, this.getKotlinCompilation(), configureAction2);
    }

    @Override
    protected void doTargetSpecificProcessing() {
        this.getProject().getTasks().named(this.getKotlinCompilation().getCompileAllTaskName()).configure(new Action(this){
            final /* synthetic */ Kotlin2JsSourceSetProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(Task it) {
                Object[] objectArray = new Object[]{this.this$0.getKotlinTask()};
                it.dependsOn(objectArray);
            }
        });
        if (this.getKotlinCompilation() instanceof KotlinWithJavaCompilation) {
            KotlinPluginKt.access$clearJavaSrcDirs(((KotlinWithJavaCompilation)this.getKotlinCompilation()).getJavaSourceSet());
        }
        KotlinMultiplatformPluginKt.whenEvaluated(this.getProject(), (Function1)new Function1<Project, Unit>(this){
            final /* synthetic */ Kotlin2JsSourceSetProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Project $this$whenEvaluated) {
                Intrinsics.checkNotNullParameter((Object)$this$whenEvaluated, (String)"$this$whenEvaluated");
                this.this$0.getKotlinTask().configure(new Action($this$whenEvaluated, this.this$0){
                    final /* synthetic */ Project $this_whenEvaluated;
                    final /* synthetic */ Kotlin2JsSourceSetProcessor this$0;
                    {
                        this.$this_whenEvaluated = $this_whenEvaluated;
                        this.this$0 = $receiver;
                    }

                    public final void execute(Kotlin2JsCompile kotlinTaskInstance) {
                        KotlinJsOptions kotlinOptions2 = kotlinTaskInstance.getKotlinOptions();
                        File outputFile2 = (File)kotlinTaskInstance.getOutputFileProperty().get();
                        File file = outputFile2.getParentFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputFile.parentFile");
                        File outputDir = file;
                        kotlinOptions2.setOutputFile(!CompilerFlagsKt.isProduceUnzippedKlib(kotlinOptions2) ? outputFile2.getAbsolutePath() : outputFile2.getParentFile().getAbsolutePath());
                        File file2 = this.$this_whenEvaluated.getProject().getRootDir();
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.rootDir");
                        if (FileUtilsKt.isParentOf$default(outputDir, file2, false, 2, null)) {
                            throw new InvalidUserDataException("The output directory '" + outputDir + "' (defined by outputFile of " + kotlinTaskInstance + ") contains or matches the project root directory '" + this.$this_whenEvaluated.getProject().getRootDir() + "'.\nGradle will not be able to build the project because of the root directory lock.\nTo fix this, consider using the default outputFile location instead of providing it explicitly.");
                        }
                        kotlinTaskInstance.getDestinationDirectory().set(outputDir);
                        if (kotlinOptions2.getFreeCompilerArgs().contains("-Xir-produce-js") || kotlinOptions2.getFreeCompilerArgs().contains("-Xir-produce-klib-dir") || kotlinOptions2.getFreeCompilerArgs().contains("-Xir-produce-klib-file")) {
                            String baseName2 = KotlinCompilationDataKt.isMainCompilationData(this.this$0.getKotlinCompilation()) ? this.$this_whenEvaluated.getProject().getName() : this.$this_whenEvaluated.getProject().getName() + '_' + this.this$0.getKotlinCompilation().getCompilationPurpose();
                            KotlinJsOptions kotlinJsOptions = kotlinTaskInstance.getKotlinOptions();
                            Collection collection = kotlinJsOptions.getFreeCompilerArgs();
                            StringBuilder stringBuilder = new StringBuilder().append("-Xir-module-name=");
                            Project project = this.$this_whenEvaluated.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                            Intrinsics.checkNotNullExpressionValue((Object)baseName2, (String)"baseName");
                            kotlinJsOptions.setFreeCompilerArgs(CollectionsKt.plus((Collection)collection, (Object)stringBuilder.append(KlibUtilsKt.klibModuleName(project, baseName2)).toString()));
                        }
                    }
                });
                Project project = $this$whenEvaluated.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                SubpluginEnvironment subpluginEnvironment = SubpluginEnvironment.Companion.loadSubplugins(project);
                if (this.this$0.getKotlinCompilation() instanceof KotlinCompilation) {
                    Project project2 = $this$whenEvaluated.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                    subpluginEnvironment.addSubpluginOptions(project2, (KotlinCompilation)this.this$0.getKotlinCompilation());
                }
            }
        });
    }
}

