/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import com.android.build.gradle.api.BaseVariant;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.AbstractAndroidProjectHandler;
import org.jetbrains.kotlin.gradle.plugin.KotlinAndroidPlugin;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilerPluginSupportPlugin;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleSubplugin;
import org.jetbrains.kotlin.gradle.plugin.SubpluginArtifact;
import org.jetbrains.kotlin.gradle.plugin.SubpluginEnvironmentKt;
import org.jetbrains.kotlin.gradle.plugin.SubpluginOption;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJvmAndroidCompilation;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\rJ\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/LegacyKotlinCompilerPluginSupportPlugin;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilerPluginSupportPlugin;", "oldPlugin", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleSubplugin;", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleSubplugin;)V", "getOldPlugin", "()Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleSubplugin;", "applyToCompilation", "Lorg/gradle/api/provider/Provider;", "", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginOption;", "kotlinCompilation", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "getCompilerPluginId", "", "getPluginArtifact", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginArtifact;", "getPluginArtifactForNative", "getPluginKotlinTasks", "compilation", "isApplicable", "", "kotlin-gradle-plugin"})
public final class LegacyKotlinCompilerPluginSupportPlugin
implements KotlinCompilerPluginSupportPlugin {
    @NotNull
    private final KotlinGradleSubplugin<AbstractCompile> oldPlugin;

    public LegacyKotlinCompilerPluginSupportPlugin(@NotNull KotlinGradleSubplugin<? super AbstractCompile> oldPlugin) {
        Intrinsics.checkNotNullParameter(oldPlugin, (String)"oldPlugin");
        this.oldPlugin = oldPlugin;
    }

    @NotNull
    public final KotlinGradleSubplugin<AbstractCompile> getOldPlugin() {
        return this.oldPlugin;
    }

    public boolean isApplicable(@NotNull KotlinCompilation<?> kotlinCompilation) {
        Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
        Object object = kotlinCompilation.getCompileKotlinTaskProvider().get();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.tasks.compile.AbstractCompile");
        }
        return this.oldPlugin.isApplicable(kotlinCompilation.getTarget().getProject(), (AbstractCompile)object);
    }

    @NotNull
    public Provider<List<SubpluginOption>> applyToCompilation(@NotNull KotlinCompilation<?> kotlinCompilation) {
        Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
        Project project = kotlinCompilation.getTarget().getProject();
        AbstractAndroidProjectHandler androidProjectHandlerOrNull = kotlinCompilation instanceof KotlinJvmAndroidCompilation ? KotlinAndroidPlugin.Companion.androidTargetHandler() : null;
        KotlinJvmAndroidCompilation kotlinJvmAndroidCompilation = kotlinCompilation instanceof KotlinJvmAndroidCompilation ? (KotlinJvmAndroidCompilation)kotlinCompilation : null;
        BaseVariant variantData = kotlinJvmAndroidCompilation != null ? kotlinJvmAndroidCompilation.getAndroidVariant() : null;
        TaskProvider<? extends JavaCompile> taskProvider = SubpluginEnvironmentKt.findJavaTaskForKotlinCompilation(kotlinCompilation);
        List result2 = this.oldPlugin.apply(project, (AbstractCompile)kotlinCompilation.getCompileKotlinTask(), (AbstractCompile)(taskProvider != null ? (JavaCompile)taskProvider.get() : null), (Object)variantData, (Object)androidProjectHandlerOrNull, variantData != null ? null : kotlinCompilation);
        Provider provider = project.provider(new Callable(result2){
            final /* synthetic */ List<SubpluginOption> $result;
            {
                this.$result = $result;
            }

            public final List<SubpluginOption> call() {
                return this.$result;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"val result = oldPlugin.a\u2026oject.provider { result }");
        return provider;
    }

    @NotNull
    public final List<AbstractCompile> getPluginKotlinTasks(@NotNull KotlinCompilation<?> compilation2) {
        Intrinsics.checkNotNullParameter(compilation2, (String)"compilation");
        Project project = compilation2.getTarget().getProject();
        return this.oldPlugin.getSubpluginKotlinTasks(project, (AbstractCompile)compilation2.getCompileKotlinTask());
    }

    @NotNull
    public String getCompilerPluginId() {
        return this.oldPlugin.getCompilerPluginId();
    }

    @NotNull
    public SubpluginArtifact getPluginArtifact() {
        return this.oldPlugin.getPluginArtifact();
    }

    @Nullable
    public SubpluginArtifact getPluginArtifactForNative() {
        return this.oldPlugin.getNativeCompilerPluginArtifact();
    }

    public void apply(@NotNull Project target2) {
        KotlinCompilerPluginSupportPlugin.DefaultImpls.apply((KotlinCompilerPluginSupportPlugin)this, (Project)target2);
    }
}

