/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadata;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadataKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.MppDependencyProjectStructureMetadataExtractor;
import org.w3c.dom.Document;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/JarMppDependencyProjectStructureMetadataExtractor;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/MppDependencyProjectStructureMetadataExtractor;", "primaryArtifactFile", "Ljava/io/File;", "(Ljava/io/File;)V", "getPrimaryArtifactFile", "()Ljava/io/File;", "getProjectStructureMetadata", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;", "parseJsonProjectStructureMetadata", "input", "Ljava/io/InputStream;", "parseXmlProjectStructureMetadata", "kotlin-gradle-plugin"})
public class JarMppDependencyProjectStructureMetadataExtractor
extends MppDependencyProjectStructureMetadataExtractor {
    @NotNull
    private final File primaryArtifactFile;

    public JarMppDependencyProjectStructureMetadataExtractor(@NotNull File primaryArtifactFile) {
        Intrinsics.checkNotNullParameter((Object)primaryArtifactFile, (String)"primaryArtifactFile");
        super(null);
        this.primaryArtifactFile = primaryArtifactFile;
    }

    @NotNull
    public final File getPrimaryArtifactFile() {
        return this.primaryArtifactFile;
    }

    private final KotlinProjectStructureMetadata parseJsonProjectStructureMetadata(InputStream input) {
        InputStream inputStream = input;
        Charset charset = Charsets.UTF_8;
        return KotlinProjectStructureMetadataKt.parseKotlinSourceSetMetadataFromJson(TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset)));
    }

    private final KotlinProjectStructureMetadata parseXmlProjectStructureMetadata(InputStream input) {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"newInstance().newDocumentBuilder().parse(input)");
        return KotlinProjectStructureMetadataKt.parseKotlinSourceSetMetadataFromXml(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public KotlinProjectStructureMetadata getProjectStructureMetadata() {
        KotlinProjectStructureMetadata kotlinProjectStructureMetadata;
        Closeable closeable = new ZipFile(this.primaryArtifactFile);
        Throwable throwable = null;
        try {
            Object object;
            Object object2;
            ZipEntry zipEntry;
            ZipFile zip;
            block19: {
                block18: {
                    zip = (ZipFile)closeable;
                    boolean bl = false;
                    ZipEntry zipEntry2 = zip.getEntry("META-INF/kotlin-project-structure-metadata.json");
                    zipEntry = zipEntry2;
                    if (zipEntry == null) break block18;
                    Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"getEntry(\"META-INF/$MULT\u2026METADATA_JSON_FILE_NAME\")");
                    zipEntry = TuplesKt.to((Object)zipEntry2, (Object)new Function1<InputStream, KotlinProjectStructureMetadata>((Object)this){

                        @Nullable
                        public final KotlinProjectStructureMetadata invoke(@NotNull InputStream p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return JarMppDependencyProjectStructureMetadataExtractor.access$parseJsonProjectStructureMetadata((JarMppDependencyProjectStructureMetadataExtractor)this.receiver, p0);
                        }

                        @NotNull
                        public final String getSignature() {
                            return "parseJsonProjectStructureMetadata(Ljava/io/InputStream;)Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;";
                        }

                        @NotNull
                        public final String getName() {
                            return "parseJsonProjectStructureMetadata";
                        }

                        @NotNull
                        public final KDeclarationContainer getOwner() {
                            return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JarMppDependencyProjectStructureMetadataExtractor.class);
                        }
                    });
                    if (zipEntry != null) break block19;
                }
                object2 = zip.getEntry("META-INF/kotlin-project-structure-metadata.xml");
                ZipEntry zipEntry3 = object2;
                if (zipEntry3 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)zipEntry3, (String)"getEntry(\"META-INF/$MULT\u2026JECT_METADATA_FILE_NAME\")");
                    zipEntry = TuplesKt.to((Object)object2, (Object)new Function1<InputStream, KotlinProjectStructureMetadata>((Object)this){

                        @Nullable
                        public final KotlinProjectStructureMetadata invoke(@NotNull InputStream p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return JarMppDependencyProjectStructureMetadataExtractor.access$parseXmlProjectStructureMetadata((JarMppDependencyProjectStructureMetadataExtractor)this.receiver, p0);
                        }

                        @NotNull
                        public final String getSignature() {
                            return "parseXmlProjectStructureMetadata(Ljava/io/InputStream;)Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;";
                        }

                        @NotNull
                        public final String getName() {
                            return "parseXmlProjectStructureMetadata";
                        }

                        @NotNull
                        public final KDeclarationContainer getOwner() {
                            return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JarMppDependencyProjectStructureMetadataExtractor.class);
                        }
                    });
                } else {
                    KotlinProjectStructureMetadata kotlinProjectStructureMetadata2 = null;
                    return kotlinProjectStructureMetadata2;
                }
            }
            ZipEntry zipEntry4 = zipEntry;
            ZipEntry metadata2 = (ZipEntry)zipEntry4.component1();
            KFunction parseFunction = (KFunction)zipEntry4.component2();
            object2 = zip.getInputStream(metadata2);
            Throwable throwable2 = null;
            try {
                object = ((Function1)parseFunction).invoke(object2);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable2);
            }
            kotlinProjectStructureMetadata = (KotlinProjectStructureMetadata)object;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return kotlinProjectStructureMetadata;
    }

    public static final /* synthetic */ KotlinProjectStructureMetadata access$parseJsonProjectStructureMetadata(JarMppDependencyProjectStructureMetadataExtractor $this, InputStream input) {
        return $this.parseJsonProjectStructureMetadata(input);
    }

    public static final /* synthetic */ KotlinProjectStructureMetadata access$parseXmlProjectStructureMetadata(JarMppDependencyProjectStructureMetadataExtractor $this, InputStream input) {
        return $this.parseXmlProjectStructureMetadata(input);
    }
}

