/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.report.BuildReportMode;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "rootProject", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin"})
public final class ConfigureReporingKt {
    @NotNull
    public static final ReportingSettings reportingSettings(@NotNull Project rootProject) {
        Intrinsics.checkNotNullParameter((Object)rootProject, (String)"rootProject");
        PropertiesProvider properties2 = PropertiesProvider.Companion.invoke(rootProject);
        BuildReportMode buildReportMode = !properties2.getBuildReportEnabled() ? BuildReportMode.NONE : (properties2.getBuildReportVerbose() ? BuildReportMode.VERBOSE : BuildReportMode.SIMPLE);
        File metricsOutputFile = properties2.getSingleBuildMetricsFile();
        File file = properties2.getBuildReportDir();
        if (file == null) {
            File file2 = rootProject.getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"rootProject.buildDir");
            file = FilesKt.resolve((File)file2, (String)"reports/kotlin-build");
        }
        File buildReportDir = file;
        boolean includeMetricsInReport = properties2.getBuildReportMetrics() || buildReportMode == BuildReportMode.VERBOSE;
        return new ReportingSettings(metricsOutputFile, buildReportDir, metricsOutputFile != null || includeMetricsInReport, includeMetricsInReport, buildReportMode);
    }
}

