/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.report.PlainTextBuildReportWriter;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionData;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionDataProcessor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/report/PlainTextBuildReportWriterDataProcessor;", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionDataProcessor;", "Ljava/io/Serializable;", "reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "reportDir", "Ljava/io/File;", "rootProjectName", "", "(Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;Ljava/io/File;Ljava/lang/String;)V", "getReportDir", "()Ljava/io/File;", "getReportingSettings", "()Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "getRootProjectName", "()Ljava/lang/String;", "process", "", "build", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionData;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin-gradle-plugin"})
public final class PlainTextBuildReportWriterDataProcessor
implements BuildExecutionDataProcessor,
Serializable {
    @NotNull
    private final ReportingSettings reportingSettings;
    @NotNull
    private final File reportDir;
    @NotNull
    private final String rootProjectName;

    public PlainTextBuildReportWriterDataProcessor(@NotNull ReportingSettings reportingSettings, @NotNull File reportDir, @NotNull String rootProjectName2) {
        Intrinsics.checkNotNullParameter((Object)reportingSettings, (String)"reportingSettings");
        Intrinsics.checkNotNullParameter((Object)reportDir, (String)"reportDir");
        Intrinsics.checkNotNullParameter((Object)rootProjectName2, (String)"rootProjectName");
        this.reportingSettings = reportingSettings;
        this.reportDir = reportDir;
        this.rootProjectName = rootProjectName2;
    }

    @NotNull
    public final ReportingSettings getReportingSettings() {
        return this.reportingSettings;
    }

    @NotNull
    public final File getReportDir() {
        return this.reportDir;
    }

    @NotNull
    public final String getRootProjectName() {
        return this.rootProjectName;
    }

    @Override
    public void process(@NotNull BuildExecutionData build, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        String ts = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(Calendar.getInstance().getTime());
        File reportFile = FilesKt.resolve((File)this.reportDir, (String)(this.rootProjectName + "-build-" + ts + ".txt"));
        new PlainTextBuildReportWriter(reportFile, this.reportingSettings.getIncludeMetricsInReport()).process(build, log);
    }
}

