/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.tasks;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.cocoapods.CocoapodsExtension;
import org.jetbrains.kotlin.gradle.plugin.cocoapods.KotlinCocoapodsPluginKt;
import org.jetbrains.kotlin.gradle.targets.native.tasks.AdvancedCocoapodsTasksKt;
import org.jetbrains.kotlin.gradle.targets.native.tasks.CocoapodsErrorHandlingUtil;
import org.jetbrains.kotlin.gradle.targets.native.tasks.DownloadCocoapodsTask;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0007J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0018H\u0002R\u0016\u0010\u0003\u001a\u00020\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR:\u0010\u000e\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00040\u0004 \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\b0\b8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/tasks/PodDownloadGitTask;", "Lorg/jetbrains/kotlin/gradle/targets/native/tasks/DownloadCocoapodsTask;", "()V", "gitDir", "Ljava/io/File;", "getGitDir$kotlin_gradle_plugin", "()Ljava/io/File;", "podSource", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/plugin/cocoapods/CocoapodsExtension$CocoapodsDependency$PodLocation$Git;", "getPodSource$kotlin_gradle_plugin", "()Lorg/gradle/api/provider/Provider;", "setPodSource$kotlin_gradle_plugin", "(Lorg/gradle/api/provider/Provider;)V", "repo", "kotlin.jvm.PlatformType", "getRepo$kotlin_gradle_plugin", "cloneHead", "", "podspecLocation", "cloneShallow", "url", "Ljava/net/URI;", "branch", "", "download", "fallback", "retrieveCommit", "commit", "kotlin-gradle-plugin"})
public class PodDownloadGitTask
extends DownloadCocoapodsTask {
    public Provider<CocoapodsExtension.CocoapodsDependency.PodLocation.Git> podSource;
    @NotNull
    private final File gitDir;
    private final Provider<File> repo;

    public PodDownloadGitTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.gitDir = KotlinCocoapodsPluginKt.getCocoapodsBuildDirs(project).externalSources("git");
        this.repo = this.getProject().provider(new Callable(this){
            final /* synthetic */ PodDownloadGitTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final File call() {
                File file = this.this$0.getGitDir$kotlin_gradle_plugin();
                Object object = this.this$0.getPodName$kotlin_gradle_plugin().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"podName.get()");
                return FilesKt.resolve((File)file, (String)((String)object));
            }
        });
    }

    @Nested
    @NotNull
    public final Provider<CocoapodsExtension.CocoapodsDependency.PodLocation.Git> getPodSource$kotlin_gradle_plugin() {
        Provider<CocoapodsExtension.CocoapodsDependency.PodLocation.Git> provider = this.podSource;
        if (provider != null) {
            return provider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"podSource");
        return null;
    }

    public final void setPodSource$kotlin_gradle_plugin(@NotNull Provider<CocoapodsExtension.CocoapodsDependency.PodLocation.Git> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"<set-?>");
        this.podSource = provider;
    }

    @Internal
    @NotNull
    public final File getGitDir$kotlin_gradle_plugin() {
        return this.gitDir;
    }

    @OutputDirectory
    public final Provider<File> getRepo$kotlin_gradle_plugin() {
        return this.repo;
    }

    @TaskAction
    public final void download() {
        Object object = this.repo.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"repo.get()");
        FilesKt.deleteRecursively((File)((File)object));
        CocoapodsExtension.CocoapodsDependency.PodLocation.Git git2 = (CocoapodsExtension.CocoapodsDependency.PodLocation.Git)this.getPodSource$kotlin_gradle_plugin().get();
        String string = git2.getTag();
        if (string == null) {
            string = git2.getBranch();
        }
        String branch = string;
        String commit = git2.getCommit();
        URI url2 = git2.getUrl();
        try {
            if (commit != null) {
                this.retrieveCommit(url2, commit);
            } else if (branch != null) {
                this.cloneShallow(url2, branch);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)git2, (String)"git");
                this.cloneHead(git2);
            }
        }
        catch (IllegalStateException e) {
            Intrinsics.checkNotNullExpressionValue((Object)git2, (String)"git");
            this.fallback(git2);
        }
    }

    private final void retrieveCommit(URI url2, String commit) {
        Logger logger = this.getProject().getLogger();
        Object[] objectArray = new String[]{"git", "init"};
        List initCommand = CollectionsKt.listOf((Object[])objectArray);
        File repo2 = (File)this.repo.get();
        repo2.mkdir();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        AdvancedCocoapodsTasksKt.runCommand$default(initCommand, logger, null, null, (Function1)new Function1<ProcessBuilder, Unit>(repo2){
            final /* synthetic */ File $repo;
            {
                this.$repo = $repo;
                super(1);
            }

            public final void invoke(@NotNull ProcessBuilder $this$runCommand) {
                Intrinsics.checkNotNullParameter((Object)$this$runCommand, (String)"$this$runCommand");
                $this$runCommand.directory(this.$repo);
            }
        }, 12, null);
        Object[] objectArray2 = new String[]{"git", "fetch", "--depth", "1", String.valueOf(url2), commit};
        List fetchCommand = CollectionsKt.listOf((Object[])objectArray2);
        AdvancedCocoapodsTasksKt.runCommand$default(fetchCommand, logger, null, null, (Function1)new Function1<ProcessBuilder, Unit>(repo2){
            final /* synthetic */ File $repo;
            {
                this.$repo = $repo;
                super(1);
            }

            public final void invoke(@NotNull ProcessBuilder $this$runCommand) {
                Intrinsics.checkNotNullParameter((Object)$this$runCommand, (String)"$this$runCommand");
                $this$runCommand.directory(this.$repo);
            }
        }, 12, null);
        Object[] objectArray3 = new String[]{"git", "checkout", "FETCH_HEAD"};
        List checkoutCommand = CollectionsKt.listOf((Object[])objectArray3);
        AdvancedCocoapodsTasksKt.runCommand$default(checkoutCommand, logger, null, null, (Function1)new Function1<ProcessBuilder, Unit>(repo2){
            final /* synthetic */ File $repo;
            {
                this.$repo = $repo;
                super(1);
            }

            public final void invoke(@NotNull ProcessBuilder $this$runCommand) {
                Intrinsics.checkNotNullParameter((Object)$this$runCommand, (String)"$this$runCommand");
                $this$runCommand.directory(this.$repo);
            }
        }, 12, null);
    }

    private final void cloneShallow(URI url2, String branch) {
        Object[] objectArray = new String[]{"git", "clone", String.valueOf(url2), (String)this.getPodName$kotlin_gradle_plugin().get(), "--branch", branch, "--depth", "1"};
        List shallowCloneCommand = CollectionsKt.listOf((Object[])objectArray);
        Logger logger = this.getProject().getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
        AdvancedCocoapodsTasksKt.runCommand$default(shallowCloneCommand, logger, null, null, (Function1)new Function1<ProcessBuilder, Unit>(this){
            final /* synthetic */ PodDownloadGitTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ProcessBuilder $this$runCommand) {
                Intrinsics.checkNotNullParameter((Object)$this$runCommand, (String)"$this$runCommand");
                $this$runCommand.directory(this.this$0.getGitDir$kotlin_gradle_plugin());
            }
        }, 12, null);
    }

    private final void cloneHead(CocoapodsExtension.CocoapodsDependency.PodLocation.Git podspecLocation) {
        Object[] objectArray = new String[]{"git", "clone", String.valueOf(podspecLocation.getUrl()), (String)this.getPodName$kotlin_gradle_plugin().get(), "--depth", "1"};
        List cloneHeadCommand = CollectionsKt.listOf((Object[])objectArray);
        Logger logger = this.getProject().getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
        AdvancedCocoapodsTasksKt.runCommand$default(cloneHeadCommand, logger, null, null, (Function1)new Function1<ProcessBuilder, Unit>(this){
            final /* synthetic */ PodDownloadGitTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ProcessBuilder $this$runCommand) {
                Intrinsics.checkNotNullParameter((Object)$this$runCommand, (String)"$this$runCommand");
                $this$runCommand.directory(this.this$0.getGitDir$kotlin_gradle_plugin());
            }
        }, 12, null);
    }

    private final void fallback(CocoapodsExtension.CocoapodsDependency.PodLocation.Git podspecLocation) {
        Object object = this.getPodName$kotlin_gradle_plugin().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"podName.get()");
        FilesKt.deleteRecursively((File)FilesKt.resolve((File)this.gitDir, (String)((String)object)));
        Object[] objectArray = new String[]{"git", "clone", String.valueOf(podspecLocation.getUrl()), (String)this.getPodName$kotlin_gradle_plugin().get()};
        List cloneAllCommand = CollectionsKt.listOf((Object[])objectArray);
        Logger logger = this.getProject().getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
        AdvancedCocoapodsTasksKt.runCommand$default(cloneAllCommand, logger, (Function3)new Function3<Integer, String, Process, String>(this, (List<String>)cloneAllCommand){
            final /* synthetic */ PodDownloadGitTask this$0;
            final /* synthetic */ List<String> $cloneAllCommand;
            {
                this.this$0 = $receiver;
                this.$cloneAllCommand = $cloneAllCommand;
                super(3);
            }

            @Nullable
            public final String invoke(int retCode, @NotNull String error, @NotNull Process process) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                Intrinsics.checkNotNullParameter((Object)process, (String)"<anonymous parameter 2>");
                Object object = this.this$0.getPodName$kotlin_gradle_plugin().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"podName.get()");
                return CocoapodsErrorHandlingUtil.INSTANCE.handlePodDownloadError((String)object, CollectionsKt.joinToString$default((Iterable)this.$cloneAllCommand, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), retCode, error);
            }
        }, null, (Function1)new Function1<ProcessBuilder, Unit>(this){
            final /* synthetic */ PodDownloadGitTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ProcessBuilder $this$runCommand) {
                Intrinsics.checkNotNullParameter((Object)$this$runCommand, (String)"$this$runCommand");
                $this$runCommand.directory(this.this$0.getGitDir$kotlin_gradle_plugin());
            }
        }, 8, null);
    }
}

