/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.gradle.plugin.CompilerPluginConfig;
import org.jetbrains.kotlin.gradle.plugin.LanguageSettingsBuilder;
import org.jetbrains.kotlin.gradle.plugin.sources.DefaultLanguageSettingsBuilder;
import org.jetbrains.kotlin.gradle.plugin.sources.DefaultLanguageSettingsBuilderKt;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompileTool;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinNativeCompile;
import org.jetbrains.kotlin.gradle.tasks.CompilerPluginOptions;
import org.jetbrains.kotlin.gradle.tasks.CompilerPluginOptionsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0004H\u0016J\u0010\u0010;\u001a\u0002092\u0006\u0010<\u001a\u00020\u0004H\u0016R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R&\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00160\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\r8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000fR(\u0010$\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R(\u0010*\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010\u0007\"\u0004\b,\u0010\tR\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u001eR\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u00040 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u000203X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/DefaultLanguageSettingsBuilder;", "Lorg/jetbrains/kotlin/gradle/plugin/LanguageSettingsBuilder;", "()V", "value", "", "apiVersion", "getApiVersion", "()Ljava/lang/String;", "setApiVersion", "(Ljava/lang/String;)V", "apiVersionImpl", "Lorg/jetbrains/kotlin/config/ApiVersion;", "compilerPluginArguments", "", "getCompilerPluginArguments", "()Ljava/util/List;", "compilerPluginClasspath", "Lorg/gradle/api/file/FileCollection;", "getCompilerPluginClasspath", "()Lorg/gradle/api/file/FileCollection;", "compilerPluginOptionsTask", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/gradle/tasks/AbstractKotlinCompileTool;", "getCompilerPluginOptionsTask", "()Lkotlin/Lazy;", "setCompilerPluginOptionsTask", "(Lkotlin/Lazy;)V", "enabledLanguageFeatures", "", "getEnabledLanguageFeatures", "()Ljava/util/Set;", "enabledLanguageFeaturesImpl", "", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "freeCompilerArgs", "getFreeCompilerArgs", "freeCompilerArgsProvider", "Lorg/gradle/api/provider/Provider;", "getFreeCompilerArgsProvider", "()Lorg/gradle/api/provider/Provider;", "setFreeCompilerArgsProvider", "(Lorg/gradle/api/provider/Provider;)V", "languageVersion", "getLanguageVersion", "setLanguageVersion", "languageVersionImpl", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "optInAnnotationsInUse", "getOptInAnnotationsInUse", "optInAnnotationsInUseImpl", "progressiveMode", "", "getProgressiveMode", "()Z", "setProgressiveMode", "(Z)V", "enableLanguageFeature", "", "name", "optIn", "annotationName", "kotlin-gradle-plugin_common"})
public final class DefaultLanguageSettingsBuilder
implements LanguageSettingsBuilder {
    @Nullable
    private LanguageVersion languageVersionImpl;
    @Nullable
    private ApiVersion apiVersionImpl;
    private boolean progressiveMode;
    @NotNull
    private final Set<LanguageFeature> enabledLanguageFeaturesImpl = new LinkedHashSet();
    @NotNull
    private final Set<String> optInAnnotationsInUseImpl = new LinkedHashSet();
    @NotNull
    private final Set<String> optInAnnotationsInUse = this.optInAnnotationsInUseImpl;
    @NotNull
    private transient Lazy<? extends AbstractKotlinCompileTool<?>> compilerPluginOptionsTask = LazyKt.lazyOf(null);
    @Nullable
    private Provider<List<String>> freeCompilerArgsProvider;

    @Override
    @Nullable
    public String getLanguageVersion() {
        LanguageVersion languageVersion2 = this.languageVersionImpl;
        return languageVersion2 != null ? languageVersion2.getVersionString() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLanguageVersion(@Nullable String value) {
        LanguageVersion languageVersion2;
        DefaultLanguageSettingsBuilder defaultLanguageSettingsBuilder = this;
        String string = value;
        if (string != null) {
            void versionString2;
            String string2 = string;
            DefaultLanguageSettingsBuilder defaultLanguageSettingsBuilder2 = defaultLanguageSettingsBuilder;
            boolean bl = false;
            LanguageVersion languageVersion3 = LanguageVersion.Companion.fromVersionString((String)versionString2);
            if (languageVersion3 == null) {
                throw new InvalidUserDataException("Incorrect language version. Expected one of: " + ArraysKt.joinToString$default((Object[])LanguageVersion.values(), null, null, null, (int)0, null, (Function1)languageVersion.1.1.INSTANCE, (int)31, null));
            }
            languageVersion2 = languageVersion3;
            defaultLanguageSettingsBuilder = defaultLanguageSettingsBuilder2;
        } else {
            languageVersion2 = null;
        }
        defaultLanguageSettingsBuilder.languageVersionImpl = languageVersion2;
    }

    @Override
    @Nullable
    public String getApiVersion() {
        ApiVersion apiVersion2 = this.apiVersionImpl;
        return apiVersion2 != null ? apiVersion2.getVersionString() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setApiVersion(@Nullable String value) {
        ApiVersion apiVersion2;
        DefaultLanguageSettingsBuilder defaultLanguageSettingsBuilder = this;
        String string = value;
        if (string != null) {
            void versionString2;
            String string2 = string;
            DefaultLanguageSettingsBuilder defaultLanguageSettingsBuilder2 = defaultLanguageSettingsBuilder;
            boolean bl = false;
            ApiVersion apiVersion3 = DefaultLanguageSettingsBuilderKt.parseApiVersionSettings((String)versionString2);
            if (apiVersion3 == null) {
                throw new InvalidUserDataException("Incorrect API version. Expected one of: " + CollectionsKt.joinToString$default((Iterable)DefaultLanguageSettingsBuilderKt.access$getApiVersionValues$p(), null, null, null, (int)0, null, (Function1)apiVersion.1.1.INSTANCE, (int)31, null));
            }
            apiVersion2 = apiVersion3;
            defaultLanguageSettingsBuilder = defaultLanguageSettingsBuilder2;
        } else {
            apiVersion2 = null;
        }
        defaultLanguageSettingsBuilder.apiVersionImpl = apiVersion2;
    }

    @Override
    public boolean getProgressiveMode() {
        return this.progressiveMode;
    }

    @Override
    public void setProgressiveMode(boolean bl) {
        this.progressiveMode = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getEnabledLanguageFeatures() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.enabledLanguageFeaturesImpl;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LanguageFeature languageFeature = (LanguageFeature)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Override
    public void enableLanguageFeature(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        LanguageFeature languageFeature = DefaultLanguageSettingsBuilderKt.parseLanguageFeature(name2);
        if (languageFeature == null) {
            throw new InvalidUserDataException("Unknown language feature '" + name2 + '\'');
        }
        LanguageFeature languageFeature2 = languageFeature;
        ((Collection)this.enabledLanguageFeaturesImpl).add(languageFeature2);
    }

    @Override
    @NotNull
    public Set<String> getOptInAnnotationsInUse() {
        return this.optInAnnotationsInUse;
    }

    @Override
    public void optIn(@NotNull String annotationName) {
        Intrinsics.checkNotNullParameter((Object)annotationName, (String)"annotationName");
        ((Collection)this.optInAnnotationsInUseImpl).add(annotationName);
    }

    @NotNull
    public final Lazy<AbstractKotlinCompileTool<?>> getCompilerPluginOptionsTask() {
        return this.compilerPluginOptionsTask;
    }

    public final void setCompilerPluginOptionsTask(@NotNull Lazy<? extends AbstractKotlinCompileTool<?>> lazy) {
        Intrinsics.checkNotNullParameter(lazy, (String)"<set-?>");
        this.compilerPluginOptionsTask = lazy;
    }

    @Nullable
    public final List<String> getCompilerPluginArguments() {
        CompilerPluginOptions compilerPluginOptions;
        AbstractKotlinCompileTool abstractKotlinCompileTool = (AbstractKotlinCompileTool)this.compilerPluginOptionsTask.getValue();
        if (abstractKotlinCompileTool == null) {
            return null;
        }
        AbstractKotlinCompileTool pluginOptionsTask = abstractKotlinCompileTool;
        AbstractKotlinCompileTool abstractKotlinCompileTool2 = pluginOptionsTask;
        if (abstractKotlinCompileTool2 instanceof AbstractKotlinCompile) {
            compilerPluginOptions = CompilerPluginOptionsKt.toSingleCompilerPluginOptions((ListProperty<? extends CompilerPluginConfig>)((AbstractKotlinCompile)pluginOptionsTask).getPluginOptions());
        } else if (abstractKotlinCompileTool2 instanceof AbstractKotlinNativeCompile) {
            compilerPluginOptions = ((AbstractKotlinNativeCompile)pluginOptionsTask).getCompilerPluginOptions();
        } else {
            throw new IllegalStateException(("Unexpected task: " + pluginOptionsTask).toString());
        }
        return compilerPluginOptions.getArguments();
    }

    @Nullable
    public final FileCollection getCompilerPluginClasspath() {
        FileCollection fileCollection;
        AbstractKotlinCompileTool abstractKotlinCompileTool = (AbstractKotlinCompileTool)this.compilerPluginOptionsTask.getValue();
        if (abstractKotlinCompileTool == null) {
            return null;
        }
        AbstractKotlinCompileTool pluginClasspathTask = abstractKotlinCompileTool;
        AbstractKotlinCompileTool abstractKotlinCompileTool2 = pluginClasspathTask;
        if (abstractKotlinCompileTool2 instanceof AbstractKotlinCompile) {
            fileCollection = (FileCollection)((AbstractKotlinCompile)pluginClasspathTask).getPluginClasspath();
        } else if (abstractKotlinCompileTool2 instanceof AbstractKotlinNativeCompile) {
            fileCollection = ((AbstractKotlinNativeCompile)pluginClasspathTask).getCompilerPluginClasspath();
            if (fileCollection == null) {
                fileCollection = (FileCollection)((AbstractKotlinNativeCompile)pluginClasspathTask).getProject().files(new Object[0]);
            }
        } else {
            throw new IllegalStateException(("Unexpected task: " + pluginClasspathTask).toString());
        }
        return fileCollection;
    }

    @Nullable
    public final Provider<List<String>> getFreeCompilerArgsProvider() {
        return this.freeCompilerArgsProvider;
    }

    public final void setFreeCompilerArgsProvider(@Nullable Provider<List<String>> provider) {
        this.freeCompilerArgsProvider = provider;
    }

    @NotNull
    public final List<String> getFreeCompilerArgs() {
        Provider<List<String>> provider = this.freeCompilerArgsProvider;
        List list2 = provider != null ? (List)provider.get() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }
}

