/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import com.gradle.scan.plugin.BuildScanExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.SizeMetricType;
import org.jetbrains.kotlin.gradle.plugin.stat.CompileStatisticsData;
import org.jetbrains.kotlin.gradle.plugin.statistics.BuildScanStatisticsListener;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatListener;
import org.jetbrains.kotlin.gradle.report.KotlinBuildReporterHandlerKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildScanStatisticsListener;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "buildScan", "Lcom/gradle/scan/plugin/BuildScanExtension;", "projectName", "", "label", "kotlinVersion", "(Lcom/gradle/scan/plugin/BuildScanExtension;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "buildUuid", "getKotlinVersion", "()Ljava/lang/String;", "getLabel", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getProjectName", "tags", "Ljava/util/LinkedHashSet;", "close", "", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "readableString", "", "data", "Lorg/jetbrains/kotlin/gradle/plugin/stat/CompileStatisticsData;", "report", "splitStringIfNeed", "str", "lengthLimit", "", "Companion", "kotlin-gradle-plugin_common"})
public final class BuildScanStatisticsListener
implements OperationCompletionListener,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BuildScanExtension buildScan;
    @NotNull
    private final String projectName;
    @Nullable
    private final String label;
    @NotNull
    private final String kotlinVersion;
    @NotNull
    private final LinkedHashSet<String> tags;
    private final Logger log;
    @NotNull
    private final String buildUuid;
    public static final int lengthLimit = 100000;

    public BuildScanStatisticsListener(@NotNull BuildScanExtension buildScan, @NotNull String projectName, @Nullable String label, @NotNull String kotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)buildScan, (String)"buildScan");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
        this.buildScan = buildScan;
        this.projectName = projectName;
        this.label = label;
        this.kotlinVersion = kotlinVersion;
        this.tags = new LinkedHashSet();
        this.log = Logging.getLogger(this.getClass());
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.buildUuid = string;
    }

    @NotNull
    public final String getProjectName() {
        return this.projectName;
    }

    @Nullable
    public final String getLabel() {
        return this.label;
    }

    @NotNull
    public final String getKotlinVersion() {
        return this.kotlinVersion;
    }

    public void onFinish(@Nullable FinishEvent event) {
        block1: {
            if (!(event instanceof TaskFinishEvent)) break block1;
            boolean $i$f$measureTimeMillisWithResult = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            CompileStatisticsData result$iv = KotlinBuildStatListener.Companion.prepareData$kotlin_gradle_plugin_common((TaskFinishEvent)event, this.projectName, this.buildUuid, this.label, this.kotlinVersion);
            Pair pair = new Pair((Object)(System.currentTimeMillis() - start$iv), (Object)result$iv);
            long collectDataDuration = ((Number)pair.component1()).longValue();
            CompileStatisticsData compileStatData = (CompileStatisticsData)pair.component2();
            this.log.debug("Collect data takes " + collectDataDuration + ": " + compileStatData);
            CompileStatisticsData compileStatisticsData = compileStatData;
            if (compileStatisticsData != null) {
                CompileStatisticsData compileStatisticsData2;
                CompileStatisticsData it = compileStatisticsData2 = compileStatisticsData;
                boolean bl2 = false;
                this.report(it);
            }
        }
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - void declaration
     */
    public final void report(@NotNull CompileStatisticsData data) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Iterable $this$forEach$iv = this.readableString(data);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            this.buildScan.value(data.getTaskName(), it);
        }
        $this$forEach$iv = data.getTags();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (!(!this.tags.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl4 = false;
            this.buildScan.tag(it);
            this.tags.add(it);
        }
        long elapsedTime = System.currentTimeMillis() - start$iv;
        this.log.debug("Report statistic to build scan takes " + elapsedTime + " ms");
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> readableString(CompileStatisticsData data) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        StringBuilder readableString2 = new StringBuilder();
        if (data.getNonIncrementalAttributes().isEmpty()) {
            readableString2.append("Incremental build; ");
            CollectionsKt.joinTo$default((Iterable)data.getChanges(), (Appendable)readableString2, null, (CharSequence)"Changes: [", (CharSequence)"]; ", (int)0, null, (Function1)readableString.1.INSTANCE, (int)50, null);
        } else {
            CollectionsKt.joinTo$default((Iterable)data.getNonIncrementalAttributes(), (Appendable)readableString2, null, (CharSequence)"Non incremental build because: [", (CharSequence)"]; ", (int)0, null, (Function1)readableString.2.INSTANCE, (int)50, null);
        }
        Map<BuildTime, Long> $this$map$iv = data.getBuildTimesMetrics();
        boolean $i$f$map = false;
        Map<BuildTime, Long> map = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            BuildTime key = (BuildTime)entry.getKey();
            long value = ((Number)entry.getValue()).longValue();
            collection.add(key.getReadableString() + ": " + value + "ms");
        }
        List timeData = (List)destination$iv$iv;
        Map<BuildPerformanceMetric, Long> $this$map$iv2 = data.getPerformanceMetrics();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            collection = destination$iv$iv2;
            boolean bl = false;
            BuildPerformanceMetric key = (BuildPerformanceMetric)entry.getKey();
            long value = ((Number)entry.getValue()).longValue();
            collection.add(WhenMappings.$EnumSwitchMapping$0[key.getType().ordinal()] == 1 ? key.getReadableString() + ": " + KotlinBuildReporterHandlerKt.formatSize(value) : key.getReadableString() + ": " + value + '}');
        }
        List perfData = (List)destination$iv$iv2;
        CollectionsKt.joinTo$default((Iterable)CollectionsKt.union((Iterable)timeData, (Iterable)perfData), (Appendable)readableString2, (CharSequence)",", (CharSequence)"Performance: [", (CharSequence)"]", (int)0, null, null, (int)112, null);
        String string = readableString2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readableString.toString()");
        return this.splitStringIfNeed(string, 100000);
    }

    private final List<String> splitStringIfNeed(String str, int lengthLimit) {
        ArrayList<String> splattedString = new ArrayList<String>();
        String tempStr = str;
        while (tempStr.length() > lengthLimit) {
            String subSequence;
            Intrinsics.checkNotNullExpressionValue((Object)tempStr.substring(lengthLimit), (String)"this as java.lang.String).substring(startIndex)");
            int index = StringsKt.lastIndexOf$default((CharSequence)subSequence, (char)';', (int)0, (boolean)false, (int)6, null);
            if (index == -1 && (index = StringsKt.lastIndexOf$default((CharSequence)subSequence, (char)',', (int)0, (boolean)false, (int)6, null)) == -1) {
                index = lengthLimit;
            }
            String string = tempStr.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            splattedString.add(string);
            Intrinsics.checkNotNullExpressionValue((Object)tempStr.substring(index), (String)"this as java.lang.String).substring(startIndex)");
        }
        splattedString.add(tempStr);
        return splattedString;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildScanStatisticsListener$Companion;", "", "()V", "lengthLimit", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SizeMetricType.values().length];
            try {
                nArray[SizeMetricType.BYTES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

