/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.gradle.plugin.stat.CompileStatisticsData;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatListener;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt;
import org.jetbrains.kotlin.gradle.report.HttpReportSettings;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\u0012\u0010\u0017\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/gradle/report/HttpReportService;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/report/HttpReportService$Parameters;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "()V", "executorService", "Ljava/util/concurrent/ExecutorService;", "getExecutorService", "()Ljava/util/concurrent/ExecutorService;", "setExecutorService", "(Ljava/util/concurrent/ExecutorService;)V", "invalidUrl", "", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "requestPreviousFailed", "checkResponseAndLog", "", "connection", "Ljava/net/HttpURLConnection;", "close", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "report", "data", "Lorg/jetbrains/kotlin/gradle/plugin/stat/CompileStatisticsData;", "Companion", "Parameters", "kotlin-gradle-plugin_common"})
public abstract class HttpReportService
implements BuildService<Parameters>,
OperationCompletionListener,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ExecutorService executorService;
    private final Logger log;
    private boolean requestPreviousFailed;
    private boolean invalidUrl;

    public HttpReportService() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        this.executorService = executorService;
        this.log = Logging.getLogger(this.getClass());
    }

    @NotNull
    public final ExecutorService getExecutorService() {
        return this.executorService;
    }

    public final void setExecutorService(@NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"<set-?>");
        this.executorService = executorService;
    }

    public void onFinish(@Nullable FinishEvent event) {
        block1: {
            CompileStatisticsData data;
            if (!(event instanceof TaskFinishEvent)) break block1;
            CompileStatisticsData compileStatisticsData = data = KotlinBuildStatListener.Companion.prepareData$kotlin_gradle_plugin_common((TaskFinishEvent)event, ((Parameters)this.getParameters()).getProjectName(), ((Parameters)this.getParameters()).getUuid(), ((Parameters)this.getParameters()).getLabel(), ((Parameters)this.getParameters()).getKotlinVersion());
            if (compileStatisticsData != null) {
                CompileStatisticsData compileStatisticsData2;
                CompileStatisticsData it = compileStatisticsData2 = compileStatisticsData;
                boolean bl = false;
                this.executorService.submit(new Runnable(this, data){
                    final /* synthetic */ HttpReportService this$0;
                    final /* synthetic */ CompileStatisticsData $data;
                    {
                        this.this$0 = $receiver;
                        this.$data = $data;
                    }

                    public final void run() {
                        this.this$0.report(this.$data);
                    }
                });
            }
        }
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void report(@NotNull CompileStatisticsData data) {
        HttpURLConnection httpURLConnection;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if (this.invalidUrl) {
            return;
        }
        try {
            URLConnection uRLConnection = new URL(((Parameters)this.getParameters()).getHttpSettings().getUrl()).openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            httpURLConnection = (HttpURLConnection)uRLConnection;
        }
        catch (IOException e) {
            this.log.warn("Unable to open connection to " + ((Parameters)this.getParameters()).getHttpSettings().getUrl() + ": " + e.getMessage());
            this.invalidUrl = true;
            return;
        }
        HttpURLConnection connection = httpURLConnection;
        try {
            Closeable it2;
            Object auth;
            Object object;
            Object object2;
            if (((Parameters)this.getParameters()).getHttpSettings().getUser() != null && ((Parameters)this.getParameters()).getHttpSettings().getPassword() != null) {
                Base64.Encoder encoder = Base64.getEncoder();
                byte[] byArray = (((Parameters)this.getParameters()).getHttpSettings().getUser() + ':' + ((Parameters)this.getParameters()).getHttpSettings().getPassword()).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = encoder.encode(byArray);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoder()\n           \u2026password}\".toByteArray())");
                object2 = byArray2;
                object = Charsets.UTF_8;
                auth = new String((byte[])object2, (Charset)object);
                connection.addRequestProperty("Authorization", "Basic " + (String)auth);
            }
            connection.addRequestProperty("Content-Type", "application/json");
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            auth = connection.getOutputStream();
            object2 = null;
            try {
                it2 = (OutputStream)auth;
                boolean bl2 = false;
                String string = new Gson().toJson(data);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Gson().toJson(data)");
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                it2.write(byArray);
                it2 = Unit.INSTANCE;
            }
            catch (Throwable it2) {
                object2 = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)auth, (Throwable)object2);
            }
            connection.connect();
            this.checkResponseAndLog(connection);
            auth = connection.getInputStream();
            object2 = null;
            try {
                String string;
                it2 = (InputStream)auth;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                Closeable closeable = it2;
                Object object3 = Charsets.UTF_8;
                closeable = new InputStreamReader((InputStream)closeable, (Charset)object3);
                object3 = null;
                try {
                    InputStreamReader reader = (InputStreamReader)closeable;
                    boolean bl4 = false;
                    string = TextStreamsKt.readText((Reader)reader);
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object3);
                }
                object = string;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)auth, (Throwable)object2);
            }
        }
        catch (Exception e) {
            this.checkResponseAndLog(connection);
        }
        finally {
            connection.disconnect();
        }
        long elapsedTime = System.currentTimeMillis() - start$iv;
        this.log.debug("Report statistic by http takes " + elapsedTime + " ms");
    }

    private final void checkResponseAndLog(HttpURLConnection connection) {
        boolean isResponseBad;
        int n = connection.getResponseCode();
        boolean bl = isResponseBad = !(200 <= n ? n < 300 : false);
        if (isResponseBad) {
            String message2 = "Failed to send statistic to " + connection.getURL() + " with " + connection.getResponseCode() + ": " + connection.getResponseMessage();
            if (!this.requestPreviousFailed) {
                this.log.warn(message2);
            } else {
                this.log.debug(message2);
            }
            this.requestPreviousFailed = true;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000e\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u0004\u0018\u00010\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u0018\u0010\u0011\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u0018\u0010\u0014\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/report/HttpReportService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "httpSettings", "Lorg/jetbrains/kotlin/gradle/report/HttpReportSettings;", "getHttpSettings", "()Lorg/jetbrains/kotlin/gradle/report/HttpReportSettings;", "setHttpSettings", "(Lorg/jetbrains/kotlin/gradle/report/HttpReportSettings;)V", "kotlinVersion", "", "getKotlinVersion", "()Ljava/lang/String;", "setKotlinVersion", "(Ljava/lang/String;)V", "label", "getLabel", "setLabel", "projectName", "getProjectName", "setProjectName", "uuid", "getUuid", "setUuid", "kotlin-gradle-plugin_common"})
    public static interface Parameters
    extends BuildServiceParameters {
        @Nullable
        public String getLabel();

        public void setLabel(@Nullable String var1);

        @NotNull
        public String getUuid();

        public void setUuid(@NotNull String var1);

        @NotNull
        public String getProjectName();

        public void setProjectName(@NotNull String var1);

        @NotNull
        public HttpReportSettings getHttpSettings();

        public void setHttpSettings(@NotNull HttpReportSettings var1);

        @NotNull
        public String getKotlinVersion();

        public void setKotlinVersion(@NotNull String var1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/report/HttpReportService$Companion;", "", "()V", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/report/HttpReportService;", "project", "Lorg/gradle/api/Project;", "kotlinVersion", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Provider<HttpReportService> registerIfAbsent(@NotNull Project project, @NotNull String kotlinVersion) {
            Provider provider;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
            Project rootProject = project.getGradle().getRootProject();
            Intrinsics.checkNotNullExpressionValue((Object)rootProject, (String)"rootProject");
            ReportingSettings reportingSettings = ConfigureReporingKt.reportingSettings(rootProject);
            HttpReportSettings httpReportSettings = reportingSettings.getHttpReportSettings();
            if (httpReportSettings != null) {
                HttpReportSettings httpSettings = httpReportSettings;
                boolean bl = false;
                Function1 function1 = (Function1)new Function1<BuildServiceSpec<Parameters>, Unit>(reportingSettings, rootProject, httpSettings, kotlinVersion){
                    final /* synthetic */ ReportingSettings $reportingSettings;
                    final /* synthetic */ Project $rootProject;
                    final /* synthetic */ HttpReportSettings $httpSettings;
                    final /* synthetic */ String $kotlinVersion;
                    {
                        this.$reportingSettings = $reportingSettings;
                        this.$rootProject = $rootProject;
                        this.$httpSettings = $httpSettings;
                        this.$kotlinVersion = $kotlinVersion;
                        super(1);
                    }

                    public final void invoke(BuildServiceSpec<Parameters> it) {
                        ((Parameters)it.getParameters()).setLabel(this.$reportingSettings.getBuildReportLabel());
                        Parameters parameters = (Parameters)it.getParameters();
                        String string = this.$rootProject.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rootProject.name");
                        parameters.setProjectName(string);
                        Parameters parameters2 = (Parameters)it.getParameters();
                        String string2 = UUID.randomUUID().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
                        parameters2.setUuid(string2);
                        ((Parameters)it.getParameters()).setHttpSettings(this.$httpSettings);
                        ((Parameters)it.getParameters()).setKotlinVersion(this.$kotlinVersion);
                    }
                };
                Provider provider2 = project.getGradle().getSharedServices().registerIfAbsent("build_http_metric_service_" + HttpReportService.class.getClassLoader().hashCode(), HttpReportService.class, new Action(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ void execute(Object p0) {
                        this.function.invoke(p0);
                    }
                });
                provider = provider2;
                Intrinsics.checkNotNull((Object)provider2);
            } else {
                provider = null;
            }
            return provider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

