/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.webpack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.tasks.Input;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.targets.js.NpmVersions;
import org.jetbrains.kotlin.gradle.targets.js.RequiredKotlinJsDependency;
import org.jetbrains.kotlin.gradle.targets.js.webpack.KotlinWebpackRule;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u001c\u0010\u0005\u001a\u00020\u00038GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\u0004\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackCssRule;", "Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackRule;", "name", "", "(Ljava/lang/String;)V", "mode", "getMode", "()Ljava/lang/String;", "setMode", "test", "getTest", "setTest", "dependencies", "", "Lorg/jetbrains/kotlin/gradle/targets/js/RequiredKotlinJsDependency;", "versions", "Lorg/jetbrains/kotlin/gradle/targets/js/NpmVersions;", "loaders", "", "Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackRule$Loader;", "validate", "", "kotlin-gradle-plugin_common"})
public abstract class KotlinWebpackCssRule
extends KotlinWebpackRule {
    @NotNull
    private String mode;
    @NotNull
    private String test;

    @Inject
    public KotlinWebpackCssRule(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(name2);
        this.mode = "inline";
        this.test = "/\\.css$/";
    }

    @Input
    @NotNull
    public final String getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.mode = string;
    }

    @Override
    @NotNull
    public String getTest() {
        return this.test;
    }

    @Override
    public void setTest(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.test = string;
    }

    @Override
    public boolean validate() {
        Object[] objectArray = new String[]{"extract", "inline", "import"};
        if (!ArraysKt.contains((Object[])objectArray, (Object)this.mode)) {
            throw new IllegalStateException("Possible values for cssSupport.mode:\n- EXTRACT\n- INLINE\n- IMPORT".toString());
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<RequiredKotlinJsDependency> dependencies(@NotNull NpmVersions versions2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)versions2, (String)"versions");
        List $this$dependencies_u24lambda_u240 = list2 = (List)new ArrayList();
        boolean bl = false;
        $this$dependencies_u24lambda_u240.add(versions2.getCssLoader());
        switch (this.mode) {
            case "extract": {
                $this$dependencies_u24lambda_u240.add(versions2.getMiniCssExtractPlugin());
                break;
            }
            case "inline": {
                $this$dependencies_u24lambda_u240.add(versions2.getStyleLoader());
                break;
            }
            case "import": {
                $this$dependencies_u24lambda_u240.add(versions2.getToStringLoader());
            }
        }
        return list2;
    }

    @Override
    @NotNull
    protected List<KotlinWebpackRule.Loader> loaders() {
        List list2;
        switch (this.mode) {
            case "extract": {
                Object[] objectArray = new String[]{"const MiniCssExtractPlugin = require('mini-css-extract-plugin');", "config.plugins.push(new MiniCssExtractPlugin())"};
                list2 = CollectionsKt.listOf((Object)new KotlinWebpackRule.Loader("MiniCssExtractPlugin.loader", null, CollectionsKt.listOf((Object[])objectArray), 2, null));
                break;
            }
            case "inline": {
                list2 = CollectionsKt.listOf((Object)new KotlinWebpackRule.Loader("'style-loader'", null, null, 6, null));
                break;
            }
            case "import": {
                list2 = CollectionsKt.listOf((Object)new KotlinWebpackRule.Loader("'to-string-loader'", null, null, 6, null));
                break;
            }
            default: {
                list2 = CollectionsKt.emptyList();
            }
        }
        return CollectionsKt.plus((Collection)list2, (Object)new KotlinWebpackRule.Loader("'css-loader'", null, null, 6, null));
    }
}

