/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.dsl.KotlinSingleJavaTargetExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinTopLevelExtension;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinCompilationData;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompileTool;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001 \u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B\u0011\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H&R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilationProcessor;", "T", "Lorg/jetbrains/kotlin/gradle/tasks/AbstractKotlinCompileTool;", "", "kotlinCompilation", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/pm20/KotlinCompilationData;", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/pm20/KotlinCompilationData;)V", "defaultKotlinDestinationDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getDefaultKotlinDestinationDir", "()Lorg/gradle/api/provider/Provider;", "getKotlinCompilation", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/pm20/KotlinCompilationData;", "kotlinTask", "Lorg/gradle/api/tasks/TaskProvider;", "getKotlinTask", "()Lorg/gradle/api/tasks/TaskProvider;", "project", "Lorg/gradle/api/Project;", "getProject", "()Lorg/gradle/api/Project;", "run", "", "kotlin-gradle-plugin_common"})
public abstract class KotlinCompilationProcessor<T extends AbstractKotlinCompileTool<?>> {
    @NotNull
    private final KotlinCompilationData<?> kotlinCompilation;

    public KotlinCompilationProcessor(@NotNull KotlinCompilationData<?> kotlinCompilation) {
        Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
        this.kotlinCompilation = kotlinCompilation;
    }

    @NotNull
    public KotlinCompilationData<?> getKotlinCompilation() {
        return this.kotlinCompilation;
    }

    @NotNull
    public abstract TaskProvider<? extends T> getKotlinTask();

    public abstract void run();

    @NotNull
    protected final Project getProject() {
        return this.getKotlinCompilation().getProject();
    }

    @NotNull
    protected final Provider<Directory> getDefaultKotlinDestinationDir() {
        String string;
        KotlinTopLevelExtension kotlinExt = KotlinProjectExtensionKt.getTopLevelExtension(this.getProject());
        if (kotlinExt instanceof KotlinSingleJavaTargetExtension) {
            string = "";
        } else {
            String string2;
            String string3 = this.getKotlinCompilation().getCompilationClassifier();
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                string2 = it + '/';
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                string = "";
            }
        }
        String targetSubDirectory = string;
        Provider provider = this.getProject().getLayout().getBuildDirectory().dir("classes/kotlin/" + targetSubDirectory + this.getKotlinCompilation().getCompilationPurpose());
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.layout.buildDire\u2026ion.compilationPurpose}\")");
        return provider;
    }
}

