/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.project.model;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.project.model.KpmModule;
import org.jetbrains.kotlin.project.model.KpmVariant;
import org.jetbrains.kotlin.project.model.KpmVariantResolution;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \r2\u00020\u0001:\u0006\r\u000e\u000f\u0010\u0011\u0012B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0001\u0005\u0013\u0014\u0015\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/project/model/KpmVariantResolution;", "", "requestingVariant", "Lorg/jetbrains/kotlin/project/model/KpmVariant;", "dependencyModule", "Lorg/jetbrains/kotlin/project/model/KpmModule;", "(Lorg/jetbrains/kotlin/project/model/KpmVariant;Lorg/jetbrains/kotlin/project/model/KpmModule;)V", "getDependencyModule", "()Lorg/jetbrains/kotlin/project/model/KpmModule;", "getRequestingVariant", "()Lorg/jetbrains/kotlin/project/model/KpmVariant;", "toString", "", "Companion", "KpmAmbiguousVariants", "KpmNoVariantMatch", "KpmVariantMatch", "NotRequested", "Unknown", "Lorg/jetbrains/kotlin/project/model/KpmVariantResolution$KpmAmbiguousVariants;", "Lorg/jetbrains/kotlin/project/model/KpmVariantResolution$KpmNoVariantMatch;", "Lorg/jetbrains/kotlin/project/model/KpmVariantResolution$KpmVariantMatch;", "Lorg/jetbrains/kotlin/project/model/KpmVariantResolution$NotRequested;", "Lorg/jetbrains/kotlin/project/model/KpmVariantResolution$Unknown;", "kotlin-project-model"})
public abstract class KpmVariantResolution {
    @NotNull
    private final KpmVariant requestingVariant;
    @NotNull
    private final KpmModule dependencyModule;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String toString() {
        String string;
        KpmVariantResolution kpmVariantResolution = this;
        if (kpmVariantResolution instanceof KpmVariantMatch) {
            string = "match: " + ((KpmVariantMatch)this).getChosenVariant().getFragmentName();
        } else if (kpmVariantResolution instanceof Unknown) {
            string = "unknown";
        } else if (kpmVariantResolution instanceof NotRequested) {
            string = "not requested";
        } else if (kpmVariantResolution instanceof KpmNoVariantMatch) {
            string = "no match";
        } else if (kpmVariantResolution instanceof KpmAmbiguousVariants) {
            string = "ambiguity: " + CollectionsKt.joinToString$default(((KpmAmbiguousVariants)this).getMatchingVariants(), null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final KpmVariant getRequestingVariant() {
        return this.requestingVariant;
    }

    @NotNull
    public final KpmModule getDependencyModule() {
        return this.dependencyModule;
    }

    private KpmVariantResolution(KpmVariant requestingVariant, KpmModule dependencyModule) {
        this.requestingVariant = requestingVariant;
        this.dependencyModule = dependencyModule;
    }

    public /* synthetic */ KpmVariantResolution(KpmVariant requestingVariant, KpmModule dependencyModule, DefaultConstructorMarker $constructor_marker) {
        this(requestingVariant, dependencyModule);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/project/model/KpmVariantResolution$KpmVariantMatch;", "Lorg/jetbrains/kotlin/project/model/KpmVariantResolution;", "requestingVariant", "Lorg/jetbrains/kotlin/project/model/KpmVariant;", "dependencyModule", "Lorg/jetbrains/kotlin/project/model/KpmModule;", "chosenVariant", "(Lorg/jetbrains/kotlin/project/model/KpmVariant;Lorg/jetbrains/kotlin/project/model/KpmModule;Lorg/jetbrains/kotlin/project/model/KpmVariant;)V", "getChosenVariant", "()Lorg/jetbrains/kotlin/project/model/KpmVariant;", "kotlin-project-model"})
    public static final class KpmVariantMatch
    extends KpmVariantResolution {
        @NotNull
        private final KpmVariant chosenVariant;

        @NotNull
        public final KpmVariant getChosenVariant() {
            return this.chosenVariant;
        }

        public KpmVariantMatch(@NotNull KpmVariant requestingVariant, @NotNull KpmModule dependencyModule, @NotNull KpmVariant chosenVariant) {
            Intrinsics.checkNotNullParameter((Object)requestingVariant, (String)"requestingVariant");
            Intrinsics.checkNotNullParameter((Object)dependencyModule, (String)"dependencyModule");
            Intrinsics.checkNotNullParameter((Object)chosenVariant, (String)"chosenVariant");
            super(requestingVariant, dependencyModule, null);
            this.chosenVariant = chosenVariant;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/project/model/KpmVariantResolution$Unknown;", "Lorg/jetbrains/kotlin/project/model/KpmVariantResolution;", "requestingVariant", "Lorg/jetbrains/kotlin/project/model/KpmVariant;", "dependencyModule", "Lorg/jetbrains/kotlin/project/model/KpmModule;", "(Lorg/jetbrains/kotlin/project/model/KpmVariant;Lorg/jetbrains/kotlin/project/model/KpmModule;)V", "kotlin-project-model"})
    public static final class Unknown
    extends KpmVariantResolution {
        public Unknown(@NotNull KpmVariant requestingVariant, @NotNull KpmModule dependencyModule) {
            Intrinsics.checkNotNullParameter((Object)requestingVariant, (String)"requestingVariant");
            Intrinsics.checkNotNullParameter((Object)dependencyModule, (String)"dependencyModule");
            super(requestingVariant, dependencyModule, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/project/model/KpmVariantResolution$NotRequested;", "Lorg/jetbrains/kotlin/project/model/KpmVariantResolution;", "requestingVariant", "Lorg/jetbrains/kotlin/project/model/KpmVariant;", "dependencyModule", "Lorg/jetbrains/kotlin/project/model/KpmModule;", "(Lorg/jetbrains/kotlin/project/model/KpmVariant;Lorg/jetbrains/kotlin/project/model/KpmModule;)V", "kotlin-project-model"})
    public static final class NotRequested
    extends KpmVariantResolution {
        public NotRequested(@NotNull KpmVariant requestingVariant, @NotNull KpmModule dependencyModule) {
            Intrinsics.checkNotNullParameter((Object)requestingVariant, (String)"requestingVariant");
            Intrinsics.checkNotNullParameter((Object)dependencyModule, (String)"dependencyModule");
            super(requestingVariant, dependencyModule, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/project/model/KpmVariantResolution$KpmNoVariantMatch;", "Lorg/jetbrains/kotlin/project/model/KpmVariantResolution;", "requestingVariant", "Lorg/jetbrains/kotlin/project/model/KpmVariant;", "dependencyModule", "Lorg/jetbrains/kotlin/project/model/KpmModule;", "(Lorg/jetbrains/kotlin/project/model/KpmVariant;Lorg/jetbrains/kotlin/project/model/KpmModule;)V", "kotlin-project-model"})
    public static final class KpmNoVariantMatch
    extends KpmVariantResolution {
        public KpmNoVariantMatch(@NotNull KpmVariant requestingVariant, @NotNull KpmModule dependencyModule) {
            Intrinsics.checkNotNullParameter((Object)requestingVariant, (String)"requestingVariant");
            Intrinsics.checkNotNullParameter((Object)dependencyModule, (String)"dependencyModule");
            super(requestingVariant, dependencyModule, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/project/model/KpmVariantResolution$KpmAmbiguousVariants;", "Lorg/jetbrains/kotlin/project/model/KpmVariantResolution;", "requestingVariant", "Lorg/jetbrains/kotlin/project/model/KpmVariant;", "dependencyModule", "Lorg/jetbrains/kotlin/project/model/KpmModule;", "matchingVariants", "", "(Lorg/jetbrains/kotlin/project/model/KpmVariant;Lorg/jetbrains/kotlin/project/model/KpmModule;Ljava/lang/Iterable;)V", "getMatchingVariants", "()Ljava/lang/Iterable;", "kotlin-project-model"})
    public static final class KpmAmbiguousVariants
    extends KpmVariantResolution {
        @NotNull
        private final Iterable<KpmVariant> matchingVariants;

        @NotNull
        public final Iterable<KpmVariant> getMatchingVariants() {
            return this.matchingVariants;
        }

        public KpmAmbiguousVariants(@NotNull KpmVariant requestingVariant, @NotNull KpmModule dependencyModule, @NotNull Iterable<? extends KpmVariant> matchingVariants) {
            Intrinsics.checkNotNullParameter((Object)requestingVariant, (String)"requestingVariant");
            Intrinsics.checkNotNullParameter((Object)dependencyModule, (String)"dependencyModule");
            Intrinsics.checkNotNullParameter(matchingVariants, (String)"matchingVariants");
            super(requestingVariant, dependencyModule, null);
            this.matchingVariants = matchingVariants;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/project/model/KpmVariantResolution$Companion;", "", "()V", "fromMatchingVariants", "Lorg/jetbrains/kotlin/project/model/KpmVariantResolution;", "requestingVariant", "Lorg/jetbrains/kotlin/project/model/KpmVariant;", "dependencyModule", "Lorg/jetbrains/kotlin/project/model/KpmModule;", "matchingVariants", "", "kotlin-project-model"})
    public static final class Companion {
        @NotNull
        public final KpmVariantResolution fromMatchingVariants(@NotNull KpmVariant requestingVariant, @NotNull KpmModule dependencyModule, @NotNull Collection<? extends KpmVariant> matchingVariants) {
            KpmVariantResolution kpmVariantResolution;
            Intrinsics.checkNotNullParameter((Object)requestingVariant, (String)"requestingVariant");
            Intrinsics.checkNotNullParameter((Object)dependencyModule, (String)"dependencyModule");
            Intrinsics.checkNotNullParameter(matchingVariants, (String)"matchingVariants");
            switch (matchingVariants.size()) {
                case 0: {
                    kpmVariantResolution = new KpmNoVariantMatch(requestingVariant, dependencyModule);
                    break;
                }
                case 1: {
                    kpmVariantResolution = new KpmVariantMatch(requestingVariant, dependencyModule, (KpmVariant)CollectionsKt.single((Iterable)matchingVariants));
                    break;
                }
                default: {
                    kpmVariantResolution = new KpmAmbiguousVariants(requestingVariant, dependencyModule, (Iterable<? extends KpmVariant>)matchingVariants);
                }
            }
            return kpmVariantResolution;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

