/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.util;

import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.util.CheckMethodAdapter;

public class CheckAnnotationAdapter
extends AnnotationVisitor {
    private final boolean useNamedValue;
    private boolean visitEndCalled;

    public CheckAnnotationAdapter(AnnotationVisitor annotationVisitor) {
        this(annotationVisitor, true);
    }

    CheckAnnotationAdapter(AnnotationVisitor annotationVisitor, boolean useNamedValues) {
        super(589824, annotationVisitor);
        this.useNamedValue = useNamedValues;
    }

    public void visit(String name2, Object value) {
        this.checkVisitEndNotCalled();
        this.checkName(name2);
        if (!(value instanceof Byte || value instanceof Boolean || value instanceof Character || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof Type || value instanceof byte[] || value instanceof boolean[] || value instanceof char[] || value instanceof short[] || value instanceof int[] || value instanceof long[] || value instanceof float[] || value instanceof double[])) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        if (value instanceof Type && ((Type)value).getSort() == 11) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        super.visit(name2, value);
    }

    public void visitEnum(String name2, String descriptor2, String value) {
        this.checkVisitEndNotCalled();
        this.checkName(name2);
        CheckMethodAdapter.checkDescriptor(49, descriptor2, false);
        if (value == null) {
            throw new IllegalArgumentException("Invalid enum value");
        }
        super.visitEnum(name2, descriptor2, value);
    }

    public AnnotationVisitor visitAnnotation(String name2, String descriptor2) {
        this.checkVisitEndNotCalled();
        this.checkName(name2);
        CheckMethodAdapter.checkDescriptor(49, descriptor2, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(name2, descriptor2));
    }

    public AnnotationVisitor visitArray(String name2) {
        this.checkVisitEndNotCalled();
        this.checkName(name2);
        return new CheckAnnotationAdapter(super.visitArray(name2), false);
    }

    public void visitEnd() {
        this.checkVisitEndNotCalled();
        this.visitEndCalled = true;
        super.visitEnd();
    }

    private void checkName(String name2) {
        if (this.useNamedValue && name2 == null) {
            throw new IllegalArgumentException("Annotation value name must not be null");
        }
    }

    private void checkVisitEndNotCalled() {
        if (this.visitEndCalled) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }
}

