/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMultiset;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.google.common.collect.Multiset;
import org.jetbrains.kotlin.com.google.common.collect.Multisets;
import org.jetbrains.kotlin.com.google.common.primitives.Ints;

@GwtCompatible
final class JdkBackedImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private final Map<E, Integer> delegateMap;
    private final ImmutableList<Multiset.Entry<E>> entries;
    private final long size;
    private transient ImmutableSet<E> elementSet;

    static <E> ImmutableMultiset<E> create(Collection<? extends Multiset.Entry<? extends E>> entries2) {
        Object[] entriesArray = entries2.toArray(new Multiset.Entry[0]);
        HashMap delegateMap = Maps.newHashMapWithExpectedSize(entriesArray.length);
        long size = 0L;
        for (int i2 = 0; i2 < entriesArray.length; ++i2) {
            Multiset.Entry entry2 = entriesArray[i2];
            int count = entry2.getCount();
            size += (long)count;
            Object element = Preconditions.checkNotNull(entry2.getElement());
            delegateMap.put(element, count);
            if (entry2 instanceof Multisets.ImmutableEntry) continue;
            entriesArray[i2] = Multisets.immutableEntry(element, count);
        }
        return new JdkBackedImmutableMultiset(delegateMap, ImmutableList.asImmutableList(entriesArray), size);
    }

    private JdkBackedImmutableMultiset(Map<E, Integer> delegateMap, ImmutableList<Multiset.Entry<E>> entries2, long size) {
        this.delegateMap = delegateMap;
        this.entries = entries2;
        this.size = size;
    }

    @Override
    public int count(@Nullable Object element) {
        return this.delegateMap.getOrDefault(element, 0);
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ImmutableSet<E> result2 = this.elementSet;
        return result2 == null ? (this.elementSet = new ImmutableMultiset.ElementSet<E>(this.entries, this)) : result2;
    }

    @Override
    Multiset.Entry<E> getEntry(int index) {
        return (Multiset.Entry)this.entries.get(index);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }
}

