/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.AbstractKotlinTargetConfigurator;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilationProcessor;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilationToRunnableFiles;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.internal.ArtifactTypeAttributeAccessorKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.AbstractKotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.InternalKotlinCompilationKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinCompilationsKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinOnlyTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.MppSourcesJarKt;
import org.jetbrains.kotlin.gradle.tasks.TasksProviderKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00030\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001b\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H \u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u00020\u00132\u0006\u0010 \u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010!J\u001d\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0$2\u0006\u0010 \u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010%R\u001c\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinOnlyTargetConfigurator;", "KotlinCompilationType", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "KotlinTargetType", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinOnlyTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/AbstractKotlinTargetConfigurator;", "createTestCompilation", "", "(Z)V", "archiveTaskType", "Ljava/lang/Class;", "Lorg/gradle/api/tasks/bundling/Zip;", "getArchiveTaskType", "()Ljava/lang/Class;", "archiveType", "", "getArchiveType", "()Ljava/lang/String;", "addJarIfNoArtifactsPresent", "", "project", "Lorg/gradle/api/Project;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "jarArtifact", "Lorg/gradle/api/artifacts/PublishArtifact;", "buildCompilationProcessor", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilationProcessor;", "compilation", "buildCompilationProcessor$kotlin_gradle_plugin_common", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;)Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilationProcessor;", "configureArchivesAndComponent", "target", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinOnlyTarget;)V", "configureCompilations", "createArchiveTasks", "Lorg/gradle/api/tasks/TaskProvider;", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinOnlyTarget;)Lorg/gradle/api/tasks/TaskProvider;", "kotlin-gradle-plugin_common"})
public abstract class KotlinOnlyTargetConfigurator<KotlinCompilationType extends KotlinCompilation<?>, KotlinTargetType extends KotlinOnlyTarget<KotlinCompilationType>>
extends AbstractKotlinTargetConfigurator<KotlinTargetType> {
    @NotNull
    private final String archiveType;

    public KotlinOnlyTargetConfigurator(boolean createTestCompilation) {
        super(createTestCompilation);
        this.archiveType = "jar";
    }

    @NotNull
    public String getArchiveType() {
        return this.archiveType;
    }

    @NotNull
    public Class<? extends Zip> getArchiveTaskType() {
        return Jar.class;
    }

    @NotNull
    public abstract KotlinCompilationProcessor<?> buildCompilationProcessor$kotlin_gradle_plugin_common(@NotNull KotlinCompilationType var1);

    @Override
    public void configureCompilations(@NotNull KotlinTargetType target2) {
        Intrinsics.checkNotNullParameter(target2, (String)"target");
        super.configureCompilations((KotlinTarget)target2);
        ((KotlinOnlyTarget)target2).getCompilations().all(new Action(this, target2){
            final /* synthetic */ KotlinOnlyTargetConfigurator<KotlinCompilationType, KotlinTargetType> this$0;
            final /* synthetic */ KotlinTargetType $target;
            {
                this.this$0 = $receiver;
                this.$target = $target;
            }

            public final void execute(KotlinCompilationType compilation2) {
                Intrinsics.checkNotNullExpressionValue(compilation2, (String)"compilation");
                this.this$0.buildCompilationProcessor$kotlin_gradle_plugin_common(compilation2).run();
                if (KotlinCompilationsKt.isMain(compilation2)) {
                    MppSourcesJarKt.sourcesJarTask(compilation2, ((KotlinOnlyTarget)this.$target).getTargetName(), CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)((KotlinOnlyTarget)this.$target).getTargetName()));
                }
            }
        });
    }

    @NotNull
    protected TaskProvider<? extends Zip> createArchiveTasks(@NotNull KotlinTargetType target2) {
        Intrinsics.checkNotNullParameter(target2, (String)"target");
        return TasksProviderKt.registerTask$default(((AbstractKotlinTarget)target2).getProject(), ((AbstractKotlinTarget)target2).getArtifactsTaskName(), this.getArchiveTaskType(), null, new Function1<?, Unit>(target2){
            final /* synthetic */ KotlinTargetType $target;
            {
                this.$target = $target;
                super(1);
            }

            public final void invoke(@NotNull Zip it) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.setDescription("Assembles an archive containing the main classes.");
                    it.setGroup("build");
                    Object[] objectArray = new Object[]{((KotlinCompilation)((KotlinOnlyTarget)this.$target).getCompilations().getByName("main")).getOutput().getAllOutputs()};
                    it.from(objectArray);
                    it.setPreserveFileTimestamps(false);
                    it.setReproducibleFileOrder(true);
                    String string = ((KotlinOnlyTarget)this.$target).getDisambiguationClassifier();
                    if (string == null) break block0;
                    String classifier = string;
                    boolean bl = false;
                    it.getArchiveAppendix().set((Object)CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)classifier));
                }
            }
        }, 4, null);
    }

    @Override
    public void configureArchivesAndComponent(@NotNull KotlinTargetType target2) {
        Intrinsics.checkNotNullParameter(target2, (String)"target");
        Project project = ((AbstractKotlinTarget)target2).getProject();
        KotlinCompilation mainCompilation = (KotlinCompilation)((KotlinOnlyTarget)target2).getCompilations().getByName("main");
        TaskProvider<Zip> task2 = this.createArchiveTasks(target2);
        project.afterEvaluate(new Action(project, task2, this, target2, mainCompilation){
            final /* synthetic */ Project $project;
            final /* synthetic */ TaskProvider<? extends Zip> $task;
            final /* synthetic */ KotlinOnlyTargetConfigurator<KotlinCompilationType, KotlinTargetType> this$0;
            final /* synthetic */ KotlinTargetType $target;
            final /* synthetic */ KotlinCompilationType $mainCompilation;
            {
                this.$project = $project;
                this.$task = $task;
                this.this$0 = $receiver;
                this.$target = $target;
                this.$mainCompilation = $mainCompilation;
            }

            public final void execute(Project it) {
                this.$project.getArtifacts().add("archives", this.$task, new Action(this.$task, this.this$0, this.$project, this.$target, this.$mainCompilation){
                    final /* synthetic */ TaskProvider<? extends Zip> $task;
                    final /* synthetic */ KotlinOnlyTargetConfigurator<KotlinCompilationType, KotlinTargetType> this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ KotlinTargetType $target;
                    final /* synthetic */ KotlinCompilationType $mainCompilation;
                    {
                        this.$task = $task;
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$target = $target;
                        this.$mainCompilation = $mainCompilation;
                    }

                    public final void execute(ConfigurablePublishArtifact jarArtifact) {
                        Object[] objectArray = new Object[]{this.$task};
                        jarArtifact.builtBy(objectArray);
                        jarArtifact.setType(this.this$0.getArchiveType());
                        Configuration apiElementsConfiguration = this.$project.getConfigurations().getByName(((AbstractKotlinTarget)this.$target).getApiElementsConfigurationName());
                        Intrinsics.checkNotNullExpressionValue((Object)apiElementsConfiguration, (String)"apiElementsConfiguration");
                        Intrinsics.checkNotNullExpressionValue((Object)jarArtifact, (String)"jarArtifact");
                        KotlinOnlyTargetConfigurator.access$addJarIfNoArtifactsPresent(this.this$0, this.$project, apiElementsConfiguration, (PublishArtifact)jarArtifact);
                        if (this.$mainCompilation instanceof KotlinCompilationToRunnableFiles) {
                            KotlinCompilationType KotlinCompilationType = this.$mainCompilation;
                            Intrinsics.checkNotNullExpressionValue(KotlinCompilationType, (String)"mainCompilation");
                            Configuration runtimeConfiguration = InternalKotlinCompilationKt.getInternal(KotlinCompilationType).getConfigurations().getDeprecatedRuntimeConfiguration();
                            Configuration runtimeElementsConfiguration = this.$project.getConfigurations().getByName(((AbstractKotlinTarget)this.$target).getRuntimeElementsConfigurationName());
                            Configuration configuration2 = runtimeConfiguration;
                            if (configuration2 != null) {
                                Configuration configuration3 = configuration2;
                                KotlinOnlyTargetConfigurator<KotlinCompilationType, KotlinTargetType> kotlinOnlyTargetConfigurator = this.this$0;
                                Project project = this.$project;
                                Configuration it = configuration3;
                                boolean bl = false;
                                KotlinOnlyTargetConfigurator.access$addJarIfNoArtifactsPresent(kotlinOnlyTargetConfigurator, project, runtimeConfiguration, (PublishArtifact)jarArtifact);
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)runtimeElementsConfiguration, (String)"runtimeElementsConfiguration");
                            KotlinOnlyTargetConfigurator.access$addJarIfNoArtifactsPresent(this.this$0, this.$project, runtimeElementsConfiguration, (PublishArtifact)jarArtifact);
                        }
                    }
                });
            }
        });
    }

    private final void addJarIfNoArtifactsPresent(Project project, Configuration configuration2, PublishArtifact jarArtifact) {
        if (configuration2.getArtifacts().isEmpty()) {
            ConfigurationPublications publications = configuration2.getOutgoing();
            publications.getArtifacts().add((Object)jarArtifact);
            publications.getAttributes().attribute(ArtifactTypeAttributeAccessorKt.getArtifactTypeAttribute(project), (Object)this.getArchiveType());
        }
    }

    public static final /* synthetic */ void access$addJarIfNoArtifactsPresent(KotlinOnlyTargetConfigurator $this, Project project, Configuration configuration2, PublishArtifact jarArtifact) {
        $this.addJarIfNoArtifactsPresent(project, configuration2, jarArtifact);
    }
}

