/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.testing;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.process.ProcessForkOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.testing.TCServiceMessagesClientSettings;
import org.jetbrains.kotlin.gradle.internal.testing.TCServiceMessagesTestExecutionSpec;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJsCompilation;
import org.jetbrains.kotlin.gradle.targets.js.KotlinWasmTargetType;
import org.jetbrains.kotlin.gradle.targets.js.RequiredKotlinJsDependency;
import org.jetbrains.kotlin.gradle.targets.js.UtilsKt;
import org.jetbrains.kotlin.gradle.targets.js.ir.KotlinJsIrTarget;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmProjectKt;
import org.jetbrains.kotlin.gradle.targets.js.testing.KotlinJsTest;
import org.jetbrains.kotlin.gradle.targets.js.testing.KotlinJsTestFramework;
import org.jetbrains.kotlin.gradle.targets.js.testing.KotlinTestRunnerCliArgs;
import org.jetbrains.kotlin.gradle.targets.js.testing.KotlinWasmNode;
import org.jetbrains.kotlin.gradle.utils.CompatibilityKt;
import org.jetbrains.kotlin.gradle.utils.ProviderApiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0+2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u000bH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR2\u0010\t\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/testing/KotlinWasmNode;", "Lorg/jetbrains/kotlin/gradle/targets/js/testing/KotlinJsTestFramework;", "kotlinJsTest", "Lorg/jetbrains/kotlin/gradle/targets/js/testing/KotlinJsTest;", "(Lorg/jetbrains/kotlin/gradle/targets/js/testing/KotlinJsTest;)V", "compilation", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;", "getCompilation", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;", "isTeamCity", "Lorg/gradle/api/provider/Provider;", "", "kotlin.jvm.PlatformType", "npmProjectDir", "Ljava/io/File;", "getNpmProjectDir", "()Ljava/io/File;", "npmProjectDir$delegate", "Lorg/gradle/api/provider/Provider;", "project", "Lorg/gradle/api/Project;", "requiredNpmDependencies", "", "Lorg/jetbrains/kotlin/gradle/targets/js/RequiredKotlinJsDependency;", "getRequiredNpmDependencies", "()Ljava/util/Set;", "settingsState", "getSettingsState", "()Ljava/lang/String;", "target", "Lorg/jetbrains/kotlin/gradle/targets/js/ir/KotlinJsIrTarget;", "wasmTargetType", "Lorg/jetbrains/kotlin/gradle/targets/js/KotlinWasmTargetType;", "workingDir", "Ljava/nio/file/Path;", "getWorkingDir", "()Ljava/nio/file/Path;", "createTestExecutionSpec", "Lorg/jetbrains/kotlin/gradle/internal/testing/TCServiceMessagesTestExecutionSpec;", "task", "forkOptions", "Lorg/gradle/process/ProcessForkOptions;", "nodeJsArgs", "", "debug", "", "getPath", "kotlin-gradle-plugin_common"})
public final class KotlinWasmNode
implements KotlinJsTestFramework {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final KotlinJsTest kotlinJsTest;
    @NotNull
    private final String settingsState;
    @NotNull
    private final transient KotlinJsCompilation compilation;
    private final Provider<String> isTeamCity;
    @NotNull
    private final transient KotlinJsIrTarget target;
    @NotNull
    private final transient Project project;
    private final Provider npmProjectDir$delegate;
    @Nullable
    private final KotlinWasmTargetType wasmTargetType;
    @NotNull
    private final Set<RequiredKotlinJsDependency> requiredNpmDependencies;

    public KotlinWasmNode(@NotNull KotlinJsTest kotlinJsTest) {
        Intrinsics.checkNotNullParameter((Object)kotlinJsTest, (String)"kotlinJsTest");
        this.kotlinJsTest = kotlinJsTest;
        this.settingsState = "KotlinWasmNode";
        this.compilation = this.kotlinJsTest.getCompilation();
        this.isTeamCity = this.getCompilation().getTarget().getProject().getProviders().gradleProperty("teamcity");
        KotlinTarget kotlinTarget = this.getCompilation().getTarget();
        Intrinsics.checkNotNull((Object)kotlinTarget, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.targets.js.ir.KotlinJsIrTarget");
        this.target = (KotlinJsIrTarget)kotlinTarget;
        this.project = this.target.getProject();
        this.npmProjectDir$delegate = this.project.provider(new Callable(this){
            final /* synthetic */ KotlinWasmNode this$0;
            {
                this.this$0 = $receiver;
            }

            public final File call() {
                return NpmProjectKt.getNpmProject(this.this$0.getCompilation()).getDir();
            }
        });
        this.wasmTargetType = this.target.getWasmTargetType();
        CompatibilityKt.doNotTrackStateCompat(this.kotlinJsTest, "Should always re-run for WASM");
        this.requiredNpmDependencies = SetsKt.emptySet();
    }

    @Override
    @NotNull
    public String getSettingsState() {
        return this.settingsState;
    }

    @Override
    @NotNull
    public KotlinJsCompilation getCompilation() {
        return this.compilation;
    }

    private final File getNpmProjectDir() {
        Provider provider = this.npmProjectDir$delegate;
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"<get-npmProjectDir>(...)");
        return (File)ProviderApiUtilsKt.getValue(provider, this, $$delegatedProperties[0]);
    }

    @Override
    @NotNull
    public Path getWorkingDir() {
        Path path;
        if (this.wasmTargetType != KotlinWasmTargetType.WASI) {
            Path path2 = this.getNpmProjectDir().toPath();
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"{\n            npmProjectDir.toPath()\n        }");
        } else {
            Path path3 = ((RegularFile)this.kotlinJsTest.getInputFileProperty().get()).getAsFile().toPath().getParent();
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"{\n            kotlinJsTe\u2026toPath().parent\n        }");
        }
        return path;
    }

    @Override
    @NotNull
    public TCServiceMessagesTestExecutionSpec createTestExecutionSpec(@NotNull KotlinJsTest task2, @NotNull ProcessForkOptions forkOptions, @NotNull List<String> nodeJsArgs, boolean debug) {
        List args2;
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)forkOptions, (String)"forkOptions");
        Intrinsics.checkNotNullParameter(nodeJsArgs, (String)"nodeJsArgs");
        File file = ((RegularFile)task2.getInputFileProperty().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"task.inputFileProperty.get().asFile");
        File testRunnerFile = UtilsKt.writeWasmUnitTestRunner(file);
        String string = task2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
        TCServiceMessagesClientSettings clientSettings2 = new TCServiceMessagesClientSettings(string, task2.getTargetName(), true, false, createTestExecutionSpec.clientSettings.1.INSTANCE, true, false, this.isTeamCity.isPresent(), 72, null);
        KotlinTestRunnerCliArgs cliArgs = new KotlinTestRunnerCliArgs(null, task2.getIncludePatterns(), task2.getExcludePatterns(), null, 9, null);
        List $this$createTestExecutionSpec_u24lambda_u240 = args2 = (List)new ArrayList();
        boolean bl = false;
        $this$createTestExecutionSpec_u24lambda_u240.addAll((Collection)nodeJsArgs);
        UtilsKt.addWasmExperimentalArguments($this$createTestExecutionSpec_u24lambda_u240);
        String string2 = testRunnerFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"testRunnerFile.absolutePath");
        $this$createTestExecutionSpec_u24lambda_u240.add(string2);
        $this$createTestExecutionSpec_u24lambda_u240.addAll((Collection)cliArgs.toList());
        return new TCServiceMessagesTestExecutionSpec(forkOptions, args2, false, clientSettings2, CollectionsKt.plus((Collection)args2, (Object)"--dryRun"));
    }

    @Override
    @NotNull
    public Set<RequiredKotlinJsDependency> getRequiredNpmDependencies() {
        return this.requiredNpmDependencies;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.kotlinJsTest.getPath() + ":kotlinTestFrameworkStub";
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(KotlinWasmNode.class), "npmProjectDir", "getNpmProjectDir()Ljava/io/File;")))};
        $$delegatedProperties = kPropertyArray;
    }
}

