/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.fileClasses.JvmMultifileClassPartInfo;
import org.jetbrains.kotlin.fileClasses.JvmSimpleFileClassInfo;
import org.jetbrains.kotlin.fileClasses.ParsedJvmFileClassAnnotations;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmNames;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0007J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\fJ\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fileClasses/JvmFileClassUtil;", "", "()V", "JVM_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getJVM_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "JVM_NAME_SHORT", "", "getJVM_NAME_SHORT", "()Ljava/lang/String;", "findAnnotationEntryOnFileNoResolve", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "shortName", "getFacadeClassInternalName", "getFileClassInfoNoResolve", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "getFileClassInternalName", "getLiteralStringFromAnnotation", "annotation", "getPartFqNameForDeserialized", "descriptor", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedMemberDescriptor;", "manglePartName", "facadeName", "fileName", "parseJvmNameOnFileNoResolve", "Lorg/jetbrains/kotlin/fileClasses/ParsedJvmFileClassAnnotations;", "frontend.java"})
public final class JvmFileClassUtil {
    @NotNull
    public static final JvmFileClassUtil INSTANCE = new JvmFileClassUtil();
    @NotNull
    private static final FqName JVM_NAME = new FqName("kotlin.jvm.JvmName");
    @NotNull
    private static final String JVM_NAME_SHORT;

    private JvmFileClassUtil() {
    }

    @NotNull
    public final FqName getJVM_NAME() {
        return JVM_NAME;
    }

    @NotNull
    public final String getJVM_NAME_SHORT() {
        return JVM_NAME_SHORT;
    }

    @NotNull
    public final FqName getPartFqNameForDeserialized(@NotNull DeserializedMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        JvmClassName jvmClassName = UtilKt.getImplClassNameForDeserialized(descriptor2);
        if (jvmClassName == null) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"No implClassName for ", (Object)descriptor2).toString());
        }
        FqName fqName2 = jvmClassName.getFqNameForTopLevelClassMaybeWithDollars();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"descriptor.getImplClassN\u2026assName for $descriptor\")");
        return fqName2;
    }

    @JvmStatic
    @NotNull
    public static final String getFileClassInternalName(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve(file).getFileClassFqName());
    }

    @JvmStatic
    @NotNull
    public static final String getFacadeClassInternalName(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve(file).getFacadeClassFqName());
    }

    private final String manglePartName(String facadeName, String fileName) {
        return facadeName + "__" + PackagePartClassUtils.getFilePartShortName(fileName);
    }

    @JvmStatic
    @NotNull
    public static final JvmFileClassInfo getFileClassInfoNoResolve(@NotNull KtFile file) {
        JvmFileClassInfo jvmFileClassInfo;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ParsedJvmFileClassAnnotations parsedAnnotations = INSTANCE.parseJvmNameOnFileNoResolve(file);
        Object object = parsedAnnotations;
        Object object2 = object == null ? null : ((ParsedJvmFileClassAnnotations)object).getJvmPackageName();
        FqName packageFqName = object2 == null ? file.getPackageFqName() : object2;
        if (parsedAnnotations != null) {
            Object object3;
            Object object4;
            object = parsedAnnotations.getJvmName();
            if (object == null) {
                object4 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"file.name");
                object3 = PackagePartClassUtils.getFilePartShortName((String)object4);
            } else {
                object3 = object;
            }
            Object simpleName = object3;
            object4 = packageFqName.child(Name.identifier((String)simpleName));
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"packageFqName.child(Name.identifier(simpleName))");
            Object facadeClassFqName = object4;
            if (parsedAnnotations.isMultifileClass()) {
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                object4 = packageFqName.child(Name.identifier(INSTANCE.manglePartName((String)simpleName, string)));
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"packageFqName.child(Name\u2026(simpleName, file.name)))");
                jvmFileClassInfo = new JvmMultifileClassPartInfo((FqName)object4, (FqName)facadeClassFqName);
            } else {
                jvmFileClassInfo = new JvmSimpleFileClassInfo((FqName)facadeClassFqName, true);
            }
        } else {
            object2 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"file.name");
            jvmFileClassInfo = new JvmSimpleFileClassInfo(PackagePartClassUtils.getPackagePartFqName(packageFqName, (String)object2), false);
        }
        return jvmFileClassInfo;
    }

    private final ParsedJvmFileClassAnnotations parseJvmNameOnFileNoResolve(KtFile file) {
        FqName fqName2;
        KtAnnotationEntry jvmPackageNameAnnotation;
        Object object;
        Object object2;
        KtAnnotationEntry jvmNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JVM_NAME_SHORT);
        KtAnnotationEntry ktAnnotationEntry = jvmNameAnnotation;
        if (ktAnnotationEntry == null) {
            object2 = null;
        } else {
            KtAnnotationEntry p0 = object = ktAnnotationEntry;
            boolean bl = false;
            String string = this.getLiteralStringFromAnnotation(p0);
            if (string == null) {
                object2 = null;
            } else {
                p0 = object = string;
                boolean bl2 = false;
                object2 = Name.isValidIdentifier((String)p0) ? object : null;
            }
        }
        Object jvmName = object2;
        object = jvmPackageNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JvmNames.INSTANCE.getJVM_PACKAGE_NAME_SHORT());
        if (object == null) {
            fqName2 = null;
        } else {
            Object object3;
            KtAnnotationEntry p0 = object3 = object;
            boolean bl = false;
            String string = this.getLiteralStringFromAnnotation(p0);
            if (string == null) {
                fqName2 = null;
            } else {
                p0 = object3 = string;
                boolean bl3 = false;
                fqName2 = new FqName((String)p0);
            }
        }
        FqName jvmPackageName = fqName2;
        if (jvmName == null && jvmPackageName == null) {
            return null;
        }
        boolean isMultifileClass = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JvmNames.INSTANCE.getJVM_MULTIFILE_CLASS_SHORT()) != null;
        return new ParsedJvmFileClassAnnotations((String)jvmName, jvmPackageName, isMultifileClass);
    }

    @JvmStatic
    @Nullable
    public static final KtAnnotationEntry findAnnotationEntryOnFileNoResolve(@NotNull KtFile file, @NotNull String shortName) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        KtFileAnnotationList ktFileAnnotationList = file.getFileAnnotationList();
        if (ktFileAnnotationList == null) {
            ktAnnotationEntry = null;
        } else {
            Object v1;
            block3: {
                List list = ktFileAnnotationList.getAnnotationEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"annotationEntries");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtSimpleNameExpression ktSimpleNameExpression;
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl = false;
                    KtConstructorCalleeExpression ktConstructorCalleeExpression = it.getCalleeExpression();
                    if (!Intrinsics.areEqual(ktConstructorCalleeExpression == null ? null : ((ktSimpleNameExpression = ktConstructorCalleeExpression.getConstructorReferenceExpression()) == null ? null : ktSimpleNameExpression.getReferencedName()), (Object)shortName)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            ktAnnotationEntry = v1;
        }
        return ktAnnotationEntry;
    }

    @Nullable
    public final String getLiteralStringFromAnnotation(@NotNull KtAnnotationEntry annotation) {
        KtStringTemplateExpression ktStringTemplateExpression;
        KtStringTemplateExpression ktStringTemplateExpression2;
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        KtStringTemplateEntry[] ktStringTemplateEntryArray = annotation.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"annotation.valueArguments");
        Object object = (ValueArgument)CollectionsKt.firstOrNull((List)ktStringTemplateEntryArray);
        if (object == null) {
            ktStringTemplateExpression2 = null;
        } else {
            KtStringTemplateEntry[] $this$getLiteralStringFromAnnotation_u24lambda_u2d4 = ktStringTemplateEntryArray = object;
            boolean bl = false;
            KtStringTemplateEntry[] ktStringTemplateEntryArray2 = $this$getLiteralStringFromAnnotation_u24lambda_u2d4;
            if (ktStringTemplateEntryArray2 instanceof KtValueArgument) {
                ktStringTemplateExpression2 = ((KtValueArgument)$this$getLiteralStringFromAnnotation_u24lambda_u2d4).getStringTemplateExpression();
            } else {
                KtExpression $this$safeAs$iv = $this$getLiteralStringFromAnnotation_u24lambda_u2d4.getArgumentExpression();
                boolean $i$f$safeAs = false;
                KtExpression ktExpression = $this$safeAs$iv;
                if (!(ktExpression instanceof KtStringTemplateExpression)) {
                    ktExpression = null;
                }
                ktStringTemplateExpression2 = (KtStringTemplateExpression)ktExpression;
            }
        }
        KtStringTemplateExpression ktStringTemplateExpression3 = ktStringTemplateExpression2;
        if (ktStringTemplateExpression3 == null) {
            return null;
        }
        KtStringTemplateExpression stringTemplateExpression = ktStringTemplateExpression = ktStringTemplateExpression3;
        ktStringTemplateEntryArray = stringTemplateExpression.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"stringTemplateExpression.entries");
        object = ArraysKt.singleOrNull((Object[])ktStringTemplateEntryArray);
        KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = ktStringTemplateExpression3 = object instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)object : null;
        if (ktStringTemplateExpression3 == null) {
            return null;
        }
        KtStringTemplateExpression singleEntry = ktStringTemplateExpression3;
        return singleEntry.getText();
    }

    static {
        String string = JVM_NAME.shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JVM_NAME.shortName().asString()");
        JVM_NAME_SHORT = string;
    }
}

