/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.DirtyFilesHolderBase;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.compilerRunner.ProgressReporterImpl;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItem;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItemKt;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.KotlinModuleKind;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ExpectActualTrackerImpl;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.KotlinJpsBundle;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper;
import org.jetbrains.kotlin.jps.build.FilesToRecompile;
import org.jetbrains.kotlin.jps.build.HasKotlinMarker;
import org.jetbrains.kotlin.jps.build.IdeaPlatformKt;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.KotlinCompileContextKt;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolder;
import org.jetbrains.kotlin.jps.build.MessageCollectorAdapter;
import org.jetbrains.kotlin.jps.build.TeamcityStatisticsLogger;
import org.jetbrains.kotlin.jps.build.TestingBuildLogger;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageManager;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.targets.KotlinJvmModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.preloading.ClassCondition;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 H2\u00020\u0001:\u0001HB\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JV\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0016\u0010\u001e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JD\u0010%\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*H\u0002J^\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u00101\u001a\u00020\u001b2\u0016\u0010\u001e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0010\u00102\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u00105\u001a\u0012\u0012\u0004\u0012\u00020706j\b\u0012\u0004\u0012\u000207`8H\u0016J2\u00109\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0:0\u001f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010<\u001a\u00020=H\u0002J\b\u0010>\u001a\u000207H\u0016J\u0010\u0010?\u001a\u0002042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010@\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010A\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010B\u001a\u000204H\u0002JJ\u0010C\u001a\u00020\u00122\u0018\u0010D\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0:0\u001f2\u0006\u0010B\u001a\u0002042\u0016\u0010\u001e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010)\u001a\u00020*H\u0002J \u0010E\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010F\u001a\u00020G2\u0006\u0010\u000b\u001a\u00020(H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder;", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder;", "()V", "statisticsLogger", "Lorg/jetbrains/kotlin/jps/build/TeamcityStatisticsLogger;", "build", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$ExitCode;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "dirtyFilesHolder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "outputConsumer", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$OutputConsumer;", "buildFinished", "", "buildStarted", "chunkBuildFinished", "chunkBuildStarted", "computeKotlinPathsForJpsPlugin", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "messageCollector", "Lorg/jetbrains/kotlin/jps/build/MessageCollectorAdapter;", "createCompileEnvironment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "kotlinModuleBuilderTarget", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "incrementalCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "exceptActualTracer", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "doBuild", "representativeTarget", "kotlinDirtyFilesHolder", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "fsOperations", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "doCompileModuleChunk", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "kotlinChunk", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "ensureKotlinContextDisposed", "ensureKotlinContextInitialized", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "getCompilableFileExtensions", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getGeneratedFiles", "", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "outputItemCollector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollectorImpl;", "getPresentableName", "initializeKotlinContext", "logSettings", "markAdditionalFilesForInitialRound", "kotlinContext", "markDirtyComplementaryMultifileClasses", "generatedFiles", "updateLookupStorage", "lookupStorageManager", "Lorg/jetbrains/kotlin/jps/incremental/JpsLookupStorageManager;", "Companion", "jps-plugin"})
public final class KotlinBuilder
extends ModuleLevelBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TeamcityStatisticsLogger statisticsLogger = new TeamcityStatisticsLogger();
    @NotNull
    public static final String KOTLIN_BUILDER_NAME = "Kotlin Builder";
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String SKIP_CACHE_VERSION_CHECK_PROPERTY = "kotlin.jps.skip.cache.version.check";
    @NotNull
    public static final String JPS_KOTLIN_HOME_PROPERTY = "jps.kotlin.home";

    public KotlinBuilder() {
        super(BuilderCategory.SOURCE_PROCESSOR);
    }

    @NotNull
    public String getPresentableName() {
        return KOTLIN_BUILDER_NAME;
    }

    @NotNull
    public ArrayList<String> getCompilableFileExtensions() {
        Object[] objectArray = new String[]{"kt", "kts"};
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }

    public void buildStarted(@NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.logSettings(context);
    }

    private final void logSettings(CompileContext context) {
        LOG.debug("==========================================");
        LOG.info(Intrinsics.stringPlus((String)"is Kotlin incremental compilation enabled for JVM: ", (Object)IncrementalCompilation.isEnabledForJvm()));
        LOG.info(Intrinsics.stringPlus((String)"is Kotlin incremental compilation enabled for JS: ", (Object)IncrementalCompilation.isEnabledForJs()));
        LOG.info(Intrinsics.stringPlus((String)"is Kotlin compiler daemon enabled: ", (Object)DaemonParamsKt.isDaemonEnabled()));
        String historyLabel = context.getBuilderParameter("history label");
        if (historyLabel != null) {
            LOG.info(Intrinsics.stringPlus((String)"Label in local history: ", (Object)historyLabel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final KotlinCompileContext ensureKotlinContextInitialized(CompileContext context) {
        KotlinCompileContext kotlinCompileContext = (KotlinCompileContext)context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey());
        if (kotlinCompileContext != null) {
            return kotlinCompileContext;
        }
        GlobalContextKey<KotlinCompileContext> globalContextKey = KotlinCompileContextKt.getKotlinCompileContextKey();
        synchronized (globalContextKey) {
            boolean bl = false;
            KotlinCompileContext actualKotlinCompileContext = (KotlinCompileContext)context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey());
            if (actualKotlinCompileContext != null) {
                return actualKotlinCompileContext;
            }
            try {
                return this.initializeKotlinContext(context);
            }
            catch (Throwable t) {
                IdeaPlatformKt.jpsReportInternalBuilderError(context, new Error(Intrinsics.stringPlus((String)"Cannot initialize Kotlin context: ", (Object)t.getMessage()), t));
                throw t;
            }
        }
    }

    private final KotlinCompileContext initializeKotlinContext(CompileContext context) {
        KotlinCompileContext kotlinContext = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        kotlinContext = new KotlinCompileContext(context);
        context.putUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey(), (Object)kotlinContext);
        TestingContext testingContext = TestingContextKt.getTestingContext(context);
        if (testingContext != null) {
            testingContext.setKotlinCompileContext(kotlinContext);
        }
        if (kotlinContext.getShouldCheckCacheVersions() && kotlinContext.hasKotlin()) {
            kotlinContext.checkCacheVersions();
        }
        kotlinContext.cleanupCaches();
        kotlinContext.reportUnsupportedTargets();
        long time = System.currentTimeMillis() - start$iv;
        LOG.info("Total Kotlin global compile context initialization time: " + time + " ms");
        return kotlinContext;
    }

    public void buildFinished(@NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensureKotlinContextDisposed(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureKotlinContextDisposed(CompileContext context) {
        if (context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey()) != null) {
            GlobalContextKey<KotlinCompileContext> globalContextKey = KotlinCompileContextKt.getKotlinCompileContextKey();
            synchronized (globalContextKey) {
                boolean bl = false;
                KotlinCompileContext kotlinCompileContext = (KotlinCompileContext)context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey());
                if (kotlinCompileContext != null) {
                    kotlinCompileContext.dispose();
                    context.putUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey(), null);
                    this.statisticsLogger.reportTotal();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public void chunkBuildStarted(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        boolean bl;
        TestingBuildLogger buildLogger;
        KotlinCompileContext kotlinContext;
        block10: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
            super.chunkBuildStarted(context, chunk);
            if (JpsUtilKt.isDummy(chunk, context)) {
                return;
            }
            kotlinContext = this.ensureKotlinContextInitialized(context);
            Object object = TestingContextKt.getTestingContext(context);
            buildLogger = object == null ? null : ((TestingContext)object).getBuildLogger();
            object = buildLogger;
            if (object != null) {
                object.chunkBuildStarted(context, chunk);
            }
            if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) {
                return;
            }
            Set targets = chunk.getTargets();
            Intrinsics.checkNotNullExpressionValue((Object)targets, (String)"targets");
            Iterable $this$none$iv = targets;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ModuleBuildTarget it = (ModuleBuildTarget)element$iv;
                    boolean bl2 = false;
                    HasKotlinMarker hasKotlinMarker = kotlinContext.getHasKotlinMarker();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!Intrinsics.areEqual((Object)hasKotlinMarker.get(it), (Object)true)) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        Object object = kotlinContext.getChunk(chunk);
        if (object == null) {
            return;
        }
        KotlinChunk kotlinChunk = object;
        kotlinContext.checkChunkCacheVersion(kotlinChunk);
        if (!kotlinContext.getRebuildingAllKotlin() && kotlinChunk.isEnabled()) {
            this.markAdditionalFilesForInitialRound(kotlinChunk, chunk, kotlinContext);
        }
        if ((object = buildLogger) != null) {
            object.afterChunkBuildStarted(context, chunk);
        }
    }

    private final void markAdditionalFilesForInitialRound(KotlinChunk kotlinChunk, ModuleChunk chunk, KotlinCompileContext kotlinContext) {
        CompileContext context = kotlinContext.getJpsContext();
        KotlinDirtySourceFilesHolder dirtyFilesHolder2 = new KotlinDirtySourceFilesHolder(chunk, context, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)((DirtyFilesHolder)new DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget>(context, chunk){
            final /* synthetic */ CompileContext $context;
            final /* synthetic */ ModuleChunk $chunk;
            {
                this.$context = $context;
                this.$chunk = $chunk;
                super($context);
            }

            public void processDirtyFiles(@NotNull FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) {
                Intrinsics.checkNotNullParameter(processor, (String)"processor");
                FSOperations.processFilesToRecompile((CompileContext)this.$context, (ModuleChunk)this.$chunk, processor);
            }
        }));
        FSOperationsHelper fsOperations = new FSOperationsHelper(context, chunk, dirtyFilesHolder2, LOG);
        KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = kotlinContext.getTargetsBinding().get(chunk.representativeTarget());
        if (kotlinModuleBuildTarget == null) {
            return;
        }
        KotlinModuleBuildTarget<?> representativeTarget = kotlinModuleBuildTarget;
        Map<KotlinModuleBuildTarget<?>, JpsIncrementalCache> incrementalCaches = kotlinChunk.loadCaches(false);
        MessageCollectorAdapter messageCollector = new MessageCollectorAdapter(context, representativeTarget);
        JpsCompilerEnvironment jpsCompilerEnvironment = this.createCompileEnvironment(kotlinContext.getJpsContext(), representativeTarget, incrementalCaches, LookupTracker.DO_NOTHING.INSTANCE, ExpectActualTracker.DoNothing.INSTANCE, chunk, messageCollector);
        if (jpsCompilerEnvironment == null) {
            return;
        }
        JpsCompilerEnvironment environment = jpsCompilerEnvironment;
        HashSet<String> removedClasses = new HashSet<String>();
        for (KotlinModuleBuildTarget<?> target : kotlinChunk.getTargets()) {
            JpsIncrementalCache jpsIncrementalCache = incrementalCaches.get(target);
            if (jpsIncrementalCache == null) continue;
            JpsIncrementalCache cache2 = jpsIncrementalCache;
            Set<File> dirtyFiles = dirtyFilesHolder2.getDirtyFiles(target.getJpsModuleBuildTarget()).keySet();
            Collection<File> removedFiles = dirtyFilesHolder2.getRemovedFiles(target.getJpsModuleBuildTarget());
            Set<String> existingClasses = new JpsKotlinCompilerRunner().classesFqNamesByFiles(environment, dirtyFiles);
            Collection previousClasses = cache2.classesFqNamesBySources(SetsKt.plus(dirtyFiles, (Iterable)removedFiles));
            for (FqName jvmClassName : previousClasses) {
                String string = jvmClassName.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jvmClassName.asString()");
                String fqName2 = string;
                if (existingClasses.contains(fqName2)) continue;
                removedClasses.add(fqName2);
            }
        }
        ChangesCollector changesCollector = new ChangesCollector();
        Iterable $this$forEach$iv = removedClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            changesCollector.collectSignature(new FqName(it), true);
        }
        FilesToRecompile affectedByRemovedClasses = KotlinBuilderKt.access$getDirtyFiles(changesCollector, incrementalCaches.values(), kotlinContext.getLookupStorageManager());
        fsOperations.markFilesForCurrentRound$jps_plugin(SetsKt.plus(affectedByRemovedClasses.getDirtyFiles(), (Iterable)affectedByRemovedClasses.getForceRecompileTogether()));
    }

    public void chunkBuildFinished(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        super.chunkBuildFinished(context, chunk);
        if (JpsUtilKt.isDummy(chunk, context)) {
            return;
        }
        KotlinCompileContext kotlinContext = this.ensureKotlinContextInitialized(context);
        for (ModuleBuildTarget target : chunk.getTargets()) {
            HasKotlinMarker hasKotlinMarker = kotlinContext.getHasKotlinMarker();
            Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
            if (!Intrinsics.areEqual((Object)hasKotlinMarker.get(target), (Object)true)) continue;
            Collection collection = target.getOutputRoots(context);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"target.getOutputRoots(context)");
            Collection outputRoots = collection;
            if (outputRoots.size() <= 1) continue;
            Iterable $this$forEach$iv = outputRoots;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                it.mkdirs();
            }
        }
        LOG.debug("------------------------------------------");
    }

    @NotNull
    public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder2, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) {
        boolean bl;
        MessageCollectorAdapter messageCollector;
        KotlinModuleBuildTarget<?> kotlinTarget;
        block12: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
            Intrinsics.checkNotNullParameter(dirtyFilesHolder2, (String)"dirtyFilesHolder");
            Intrinsics.checkNotNullParameter((Object)outputConsumer, (String)"outputConsumer");
            if (JpsUtilKt.isDummy(chunk, context)) {
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = KotlinCompileContextKt.getKotlin(context).getTargetsBinding().get(chunk.representativeTarget());
            if (kotlinModuleBuildTarget == null) {
                return ModuleLevelBuilder.ExitCode.OK;
            }
            kotlinTarget = kotlinModuleBuildTarget;
            messageCollector = new MessageCollectorAdapter(context, kotlinTarget);
            Set set = chunk.getModules();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"chunk.modules");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JpsModule it = (JpsModule)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!(ModuleSettingsKt.getKotlinKind(it) == KotlinModuleKind.SOURCE_SET_HOLDER)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            if (chunk.getModules().size() > 1) {
                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, KotlinJpsBundle.message("error.text.cyclically.dependent.modules.are.not.supported.in.multiplatform.projects", new Object[0]), null, 4, null);
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        KotlinDirtySourceFilesHolder kotlinDirtyFilesHolder = new KotlinDirtySourceFilesHolder(chunk, context, dirtyFilesHolder2);
        FSOperationsHelper fsOperations = new FSOperationsHelper(context, chunk, kotlinDirtyFilesHolder, LOG);
        try {
            TestingBuildLogger testingBuildLogger;
            ModuleLevelBuilder.ExitCode proposedExitCode = this.doBuild(chunk, kotlinTarget, context, kotlinDirtyFilesHolder, messageCollector, outputConsumer, fsOperations);
            ModuleLevelBuilder.ExitCode actualExitCode = proposedExitCode == ModuleLevelBuilder.ExitCode.OK && fsOperations.getHasMarkedDirty$jps_plugin() ? ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED : proposedExitCode;
            LOG.debug(Intrinsics.stringPlus((String)"Build result: ", (Object)actualExitCode));
            TestingContext testingContext = TestingContextKt.getTestingContext(context);
            if (testingContext != null && (testingBuildLogger = testingContext.getBuildLogger()) != null) {
                testingBuildLogger.buildFinished(actualExitCode);
            }
            return actualExitCode;
        }
        catch (StopBuildException e) {
            LOG.info(Intrinsics.stringPlus((String)"Caught exception: ", (Object)((Object)e)));
            throw e;
        }
        catch (BuildDataCorruptedException e) {
            LOG.info(Intrinsics.stringPlus((String)"Caught exception: ", (Object)((Object)e)));
            throw e;
        }
        catch (Throwable e) {
            LOG.info(Intrinsics.stringPlus((String)"Caught exception: ", (Object)e));
            MessageCollectorUtil.reportException(messageCollector, e);
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ModuleLevelBuilder.ExitCode doBuild(ModuleChunk chunk, KotlinModuleBuildTarget<?> representativeTarget, CompileContext context, KotlinDirtySourceFilesHolder kotlinDirtyFilesHolder, MessageCollectorAdapter messageCollector, ModuleLevelBuilder.OutputConsumer outputConsumer, FSOperationsHelper fsOperations) {
        block39: {
            block38: {
                if (representativeTarget instanceof KotlinJvmModuleBuildTarget && !((Boolean)JavaBuilder.IS_ENABLED.get((UserDataHolder)context, (Object)true)).booleanValue()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, KotlinJpsBundle.message("info.text.kotlin.jps.plugin.is.disabled", new Object[0]), null, 4, null);
                    return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                }
                kotlinContext = KotlinCompileContextKt.getKotlin(context);
                v0 = JpsUtilKt.toKotlinChunk(chunk, context);
                Intrinsics.checkNotNull((Object)v0);
                kotlinChunk = v0;
                if (!kotlinChunk.getHaveSameCompiler()) {
                    var10_10 = new Object[]{kotlinChunk.getPresentableModulesToCompilersList()};
                    MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, KotlinJpsBundle.message("error.text.cyclically.dependent.modules.0.should.have.same.compiler", var10_10), null, 4, null);
                    return ModuleLevelBuilder.ExitCode.ABORT;
                }
                if (!kotlinChunk.isEnabled()) {
                    return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                }
                projectDescriptor = context.getProjectDescriptor();
                targets = chunk.getTargets();
                if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) ** GOTO lbl-1000
                Intrinsics.checkNotNullExpressionValue((Object)targets, (String)"targets");
                $this$any$iv = targets;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (Object[] element$iv : $this$any$iv) {
                        it = (ModuleBuildTarget)element$iv /* !! */ ;
                        $i$a$-any-KotlinBuilder$doBuild$isChunkRebuilding$1 = false;
                        v2 = kotlinContext.getRebuildAfterCacheVersionChanged();
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!Intrinsics.areEqual((Object)v2.get(it), (Object)true)) continue;
                        v1 = true;
                        break block38;
                    }
                    v1 = false;
                }
            }
            if (v1) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = isChunkRebuilding = false;
            }
            if (!kotlinDirtyFilesHolder.getHasDirtyOrRemovedFiles()) {
                if (isChunkRebuilding) {
                    Intrinsics.checkNotNullExpressionValue((Object)targets, (String)"targets");
                    $this$forEach$iv = targets;
                    $i$f$forEach = false;
                    for (Object[] element$iv : $this$forEach$iv) {
                        it = (ModuleBuildTarget)element$iv /* !! */ ;
                        $i$a$-forEach-KotlinBuilder$doBuild$1 = false;
                        v4 = kotlinContext.getHasKotlinMarker();
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        v4.set(it, false);
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)targets, (String)"targets");
                $this$forEach$iv = targets;
                $i$f$forEach = false;
                for (Object[] element$iv : $this$forEach$iv) {
                    it = (ModuleBuildTarget)element$iv /* !! */ ;
                    $i$a$-forEach-KotlinBuilder$doBuild$2 = false;
                    v5 = kotlinContext.getRebuildAfterCacheVersionChanged();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    v5.clean(it);
                }
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            if (!isChunkRebuilding && !representativeTarget.isIncrementalCompilationEnabled()) {
                Intrinsics.checkNotNullExpressionValue((Object)targets, (String)"targets");
                $this$forEach$iv = targets;
                $i$f$forEach = false;
                for (Object[] element$iv : $this$forEach$iv) {
                    it = (ModuleBuildTarget)element$iv /* !! */ ;
                    $i$a$-forEach-KotlinBuilder$doBuild$3 = false;
                    v6 = kotlinContext.getRebuildAfterCacheVersionChanged();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    v6.set(it, true);
                }
                return ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED;
            }
            Intrinsics.checkNotNullExpressionValue((Object)targets, (String)"targets");
            $this$filter$iv = (Object[])targets;
            $i$f$filter = false;
            element$iv /* !! */  = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (ModuleBuildTarget)element$iv$iv;
                $i$a$-filter-KotlinBuilder$doBuild$targetsWithoutOutputDir$1 = false;
                if (!(it.getOutputDir() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            targetsWithoutOutputDir = (List)destination$iv$iv;
            if (((Collection)targetsWithoutOutputDir).isEmpty() == false) {
                $this$filter$iv = new Object[]{CollectionsKt.joinToString$default((Iterable)targetsWithoutOutputDir, null, null, null, (int)0, null, null, (int)63, null)};
                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, KotlinJpsBundle.message("error.text.output.directory.not.specified.for.0", $this$filter$iv), null, 4, null);
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            project = projectDescriptor.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            lookupTracker = KotlinBuilderKt.access$getLookupTracker(project, representativeTarget);
            exceptActualTracer = new ExpectActualTrackerImpl();
            incrementalCaches = KotlinChunk.loadCaches$default(kotlinChunk, false, 1, null);
            var19_24 = this.createCompileEnvironment(context, representativeTarget, incrementalCaches, lookupTracker, (ExpectActualTracker)exceptActualTracer, chunk, messageCollector);
            if (var19_24 == null) {
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            environment = var19_24;
            var19_24 = TestingContextKt.getTestingContext(context);
            if (var19_24 == null) {
                v7 = null;
            } else {
                var20_26 = var19_24.getBuildLogger();
                if (var20_26 == null) {
                    v7 = null;
                } else {
                    var20_26.compilingFiles((Collection<? extends File>)kotlinDirtyFilesHolder.getAllDirtyFiles(), (Collection<? extends File>)kotlinDirtyFilesHolder.getAllRemovedFilesFiles());
                    v7 = Unit.INSTANCE;
                }
            }
            if (KotlinBuilder.LOG.isDebugEnabled()) {
                KotlinBuilder.LOG.debug(Intrinsics.stringPlus((String)"Compiling files: ", kotlinDirtyFilesHolder.getAllDirtyFiles()));
            }
            start = System.nanoTime();
            outputItemCollector = this.doCompileModuleChunk(kotlinChunk, representativeTarget, kotlinChunk.getCompilerArguments(), context, kotlinDirtyFilesHolder, fsOperations, (JpsCompilerEnvironment)environment, incrementalCaches);
            this.statisticsLogger.registerStatistic(chunk, System.nanoTime() - start);
            if (outputItemCollector == null) {
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            compilationErrors = (Boolean)Utils.ERRORS_DETECTED_KEY.get((UserDataHolder)context, (Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)compilationErrors, (String)"compilationErrors");
            if (compilationErrors.booleanValue()) {
                KotlinBuilder.LOG.info("Compiled with errors");
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            KotlinBuilder.LOG.info("Compiled successfully");
            generatedFiles = this.getGeneratedFiles(context, chunk, environment.getOutputItemsCollector());
            this.markDirtyComplementaryMultifileClasses(generatedFiles, kotlinContext, incrementalCaches, fsOperations);
            kotlinTargets = kotlinContext.getTargetsBinding();
            for (Map.Entry<ModuleBuildTarget, List<GeneratedFile>> var26_33 : generatedFiles.entrySet()) {
                target = var26_33.getKey();
                outputItems = var26_33.getValue();
                var30_41 = kotlinTargets.get(target);
                if (var30_41 == null) {
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"Could not find Kotlin target for JPS target ", (Object)target).toString());
                }
                kotlinTarget = var30_41;
                kotlinTarget.registerOutputItems(outputConsumer, outputItems);
            }
            kotlinChunk.saveVersions();
            $this$any$iv = targets;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v8 = false;
            } else {
                target = $this$any$iv.iterator();
                while (target.hasNext()) {
                    element$iv = target.next();
                    it = (ModuleBuildTarget)element$iv;
                    $i$a$-any-KotlinBuilder$doBuild$4 = false;
                    v9 = kotlinContext.getHasKotlinMarker();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!(v9.get((ModuleBuildTarget)it) == null)) continue;
                    v8 = true;
                    break block39;
                }
                v8 = false;
            }
        }
        if (v8) {
            fsOperations.markChunk(false, true, kotlinDirtyFilesHolder.getAllDirtyFiles());
        }
        for (ModuleBuildTarget target : targets) {
            v10 = kotlinContext.getHasKotlinMarker();
            Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
            v10.set(target, true);
            kotlinContext.getRebuildAfterCacheVersionChanged().clean(target);
        }
        $this$forEach$iv = kotlinChunk.getTargets();
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            it = (KotlinModuleBuildTarget)element$iv;
            $i$a$-forEach-KotlinBuilder$doBuild$5 = false;
            it.doAfterBuild();
        }
        representativeTarget.updateChunkMappings(context, chunk, kotlinDirtyFilesHolder, generatedFiles, incrementalCaches);
        if (!representativeTarget.isIncrementalCompilationEnabled()) {
            return ModuleLevelBuilder.ExitCode.OK;
        }
        context.checkCanceled();
        $this$withProgressReporter$iv = environment;
        $i$f$withProgressReporter = false;
        try {
            progress = $this$withProgressReporter$iv.getProgressReporter();
            $i$a$-withProgressReporter-KotlinBuilder$doBuild$6 = false;
            progress.progress("performing incremental compilation analysis");
            changesCollector = new ChangesCollector();
            for (Map.Entry<ModuleBuildTarget, List<GeneratedFile>> var31_45 : generatedFiles.entrySet()) {
                target = var31_45.getKey();
                files = var31_45.getValue();
                Intrinsics.checkNotNull(kotlinContext.getTargetsBinding().get(target));
                v11 = incrementalCaches.get(kotlinModuleBuilderTarget);
                Intrinsics.checkNotNull(v11);
                kotlinModuleBuilderTarget.updateCaches(kotlinDirtyFilesHolder, (JpsIncrementalCache)v11, files, changesCollector, (JpsCompilerEnvironment)environment);
            }
            this.updateLookupStorage(lookupTracker, kotlinContext.getLookupStorageManager(), kotlinDirtyFilesHolder);
            if (!isChunkRebuilding) {
                KotlinBuilderKt.access$processChangesUsingLookups(changesCollector, kotlinDirtyFilesHolder.getAllDirtyFiles(), kotlinContext.getLookupStorageManager(), fsOperations, incrementalCaches.values());
            }
            var35_49 = Unit.INSTANCE;
        }
        finally {
            $this$withProgressReporter$iv.getProgressReporter().clearProgress();
        }
        return ModuleLevelBuilder.ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollector doCompileModuleChunk(KotlinChunk kotlinChunk, KotlinModuleBuildTarget<?> representativeTarget, CommonCompilerArguments commonArguments, CompileContext context, KotlinDirtySourceFilesHolder dirtyFilesHolder2, FSOperationsHelper fsOperations, JpsCompilerEnvironment environment, Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches) {
        boolean isDoneSomething;
        Iterable $this$forEach$iv = kotlinChunk.getTargets();
        boolean bl = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv;
            boolean bl2 = false;
            it.nextRound(context);
        }
        if (representativeTarget.isIncrementalCompilationEnabled()) {
            for (KotlinModuleBuildTarget kotlinModuleBuildTarget : kotlinChunk.getTargets()) {
                JpsIncrementalCache cache2 = incrementalCaches.get(kotlinModuleBuildTarget);
                ModuleBuildTarget jpsTarget = kotlinModuleBuildTarget.getJpsModuleBuildTarget();
                KotlinDirtySourceFilesHolder.TargetFiles targetDirtyFiles2 = dirtyFilesHolder2.getByTarget().get(jpsTarget);
                if (cache2 == null || targetDirtyFiles2 == null) continue;
                Set dirtyFiles = SetsKt.plus(targetDirtyFiles2.getDirty().keySet(), (Iterable)targetDirtyFiles2.getRemoved());
                Collection complementaryFiles = cache2.getComplementaryFilesRecursive(dirtyFiles);
                Collection dirtyMultifileClassFiles = CollectionsKt.emptyList();
                if (cache2 instanceof IncrementalJvmCache) {
                    Iterable list$iv$iv;
                    Iterable $this$flatMapTo$iv$iv;
                    Iterable $this$flatMap$iv;
                    boolean bl3;
                    Object it;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Iterable iterable = ((IncrementalJvmCache)cache2).classesBySources((Iterable)dirtyFiles);
                    boolean $i$f$filter = false;
                    void var19_22 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (JvmClassName)element$iv$iv;
                        bl3 = false;
                        if (!((IncrementalJvmCache)cache2).isMultifileFacade((JvmClassName)it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$flatMap = false;
                    $this$filterTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        it = (JvmClassName)element$iv$iv;
                        bl3 = false;
                        Collection collection = ((IncrementalJvmCache)cache2).getAllPartsOfMultifileFacade((JvmClassName)it);
                        list$iv$iv = collection == null ? (Collection)CollectionsKt.emptyList() : collection;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    $this$flatMap$iv = (List)destination$iv$iv;
                    $i$f$flatMap = false;
                    $this$flatMapTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        it = (String)element$iv$iv;
                        bl3 = false;
                        list$iv$iv = ((IncrementalJvmCache)cache2).sourcesByInternalName((String)it);
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    $this$flatMap$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                    $i$f$filter = false;
                    $this$flatMapTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (File)element$iv$iv;
                        bl3 = false;
                        if (!(!dirtyFiles.contains(it))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    dirtyMultifileClassFiles = (List)destination$iv$iv;
                }
                fsOperations.markFilesForCurrentRound(jpsTarget, CollectionsKt.plus((Collection)complementaryFiles, (Iterable)dirtyMultifileClassFiles));
                cache2.markDirty(SetsKt.plus(targetDirtyFiles2.getDirty().keySet(), (Iterable)targetDirtyFiles2.getRemoved()));
            }
        }
        return (isDoneSomething = representativeTarget.compileModuleChunk(commonArguments, dirtyFilesHolder2, environment)) ? (OutputItemsCollector)environment.getOutputItemsCollector() : null;
    }

    private final JpsCompilerEnvironment createCompileEnvironment(CompileContext context, KotlinModuleBuildTarget<?> kotlinModuleBuilderTarget, Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches, LookupTracker lookupTracker, ExpectActualTracker exceptActualTracer, ModuleChunk chunk, MessageCollectorAdapter messageCollector) {
        Object object = new Services.Builder();
        Services.Builder $this$createCompileEnvironment_u24lambda_u2d20 = object;
        boolean bl = false;
        kotlinModuleBuilderTarget.makeServices($this$createCompileEnvironment_u24lambda_u2d20, incrementalCaches, lookupTracker, exceptActualTracer);
        Services compilerServices = $this$createCompileEnvironment_u24lambda_u2d20.build();
        object = this.computeKotlinPathsForJpsPlugin(messageCollector);
        if (object == null) {
            return null;
        }
        return new JpsCompilerEnvironment((KotlinPaths)object, compilerServices, Companion.getClassesToLoadByParent(), messageCollector, new OutputItemsCollectorImpl(), new ProgressReporterImpl(context, chunk));
    }

    private final KotlinPaths computeKotlinPathsForJpsPlugin(MessageCollectorAdapter messageCollector) {
        KotlinPaths kotlinPaths;
        File file;
        if (StringsKt.equals((String)System.getProperty("kotlin.jps.tests"), (String)"true", (boolean)true)) {
            return PathUtil.getKotlinPathsForDistDirectory();
        }
        String string = System.getProperty(JPS_KOTLIN_HOME_PROPERTY);
        if (string == null) {
            file = null;
        } else {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            file = new File(it);
        }
        File jpsKotlinHome = file;
        if (jpsKotlinHome == null) {
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Make sure that 'jps.kotlin.home' system property is set in JPS process", null, 4, null);
            kotlinPaths = null;
        } else if (jpsKotlinHome.exists()) {
            kotlinPaths = new KotlinPathsFromHomeDir(jpsKotlinHome);
        } else {
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, Intrinsics.stringPlus((String)"Cannot find kotlinc home at ", (Object)jpsKotlinHome), null, 4, null);
            kotlinPaths = null;
        }
        return kotlinPaths;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ModuleBuildTarget, List<GeneratedFile>> getGeneratedFiles(CompileContext context, ModuleChunk chunk, OutputItemsCollectorImpl outputItemCollector) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Iterable $this$sortedBy$iv;
        Collection<File> collection;
        Iterable target2;
        HashMap<File, ModuleBuildTarget> sourceToTarget = new HashMap<File, ModuleBuildTarget>();
        if (chunk.getTargets().size() > 1) {
            for (Iterable target2 : chunk.getTargets()) {
                KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = KotlinCompileContextKt.getKotlin(context).getTargetsBinding().get(target2);
                if (kotlinModuleBuildTarget == null) continue;
                collection = kotlinModuleBuildTarget.getSourceFiles();
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    Map map = sourceToTarget;
                    Intrinsics.checkNotNullExpressionValue((Object)target2, (String)"target");
                    Iterable iterable = target2;
                    map.put(it, iterable);
                }
            }
        }
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        target2 = outputItemCollector.getOutputs();
        Intrinsics.checkNotNullExpressionValue((Object)target2, (String)"outputItemCollector.outputs");
        target2 = target2;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SimpleOutputItem it = (SimpleOutputItem)a;
                boolean bl = false;
                Comparable comparable = it.getOutputFile();
                it = (SimpleOutputItem)b;
                Comparable comparable2 = comparable;
                bl = false;
                File file = it.getOutputFile();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)file);
            }
        });
        boolean $i$f$groupBy = false;
        collection = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            SimpleOutputItem p0 = (SimpleOutputItem)element$iv$iv;
            boolean bl = false;
            ModuleBuildTarget key$iv$iv = KotlinBuilder.getGeneratedFiles$target(p0, chunk, representativeTarget, sourceToTarget);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            p0 = (SimpleOutputItem)element$iv$iv;
            List list = list$iv$iv;
            boolean bl3 = false;
            GeneratedFile generatedFile = SimpleOutputItemKt.toGeneratedFile((SimpleOutputItem)p0);
            list.add(generatedFile);
        }
        return destination$iv$iv;
    }

    private final void updateLookupStorage(LookupTracker lookupTracker, JpsLookupStorageManager lookupStorageManager, KotlinDirtySourceFilesHolder dirtyFilesHolder2) {
        if (!(lookupTracker instanceof LookupTrackerImpl)) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Lookup tracker is expected to be LookupTrackerImpl, got ", lookupTracker.getClass()));
        }
        lookupStorageManager.withLookupStorage((Function1)new Function1<LookupStorage, Unit>(dirtyFilesHolder2, lookupTracker){
            final /* synthetic */ KotlinDirtySourceFilesHolder $dirtyFilesHolder;
            final /* synthetic */ LookupTracker $lookupTracker;
            {
                this.$dirtyFilesHolder = $dirtyFilesHolder;
                this.$lookupTracker = $lookupTracker;
                super(1);
            }

            public final void invoke(@NotNull LookupStorage lookupStorage) {
                Intrinsics.checkNotNullParameter((Object)lookupStorage, (String)"lookupStorage");
                lookupStorage.removeLookupsFrom(SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)this.$dirtyFilesHolder.getAllDirtyFiles()), (Sequence)CollectionsKt.asSequence((Iterable)this.$dirtyFilesHolder.getAllRemovedFilesFiles())));
                MultiMap multiMap = ((LookupTrackerImpl)this.$lookupTracker).getLookups();
                Set set = ((LookupTrackerImpl)this.$lookupTracker).getPathInterner().getValues();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"lookupTracker.pathInterner.values");
                lookupStorage.addAll(multiMap, set);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void markDirtyComplementaryMultifileClasses(Map<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> generatedFiles, KotlinCompileContext kotlinContext, Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches, FSOperationsHelper fsOperations) {
        for (Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> entry : generatedFiles.entrySet()) {
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Object object;
            Object object2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$filterTo$iv$iv;
            void $this$flatMapTo$iv$iv2;
            void $this$filterTo$iv$iv2;
            Object element$iv$iv2;
            void $this$filterIsInstanceTo$iv$iv;
            IncrementalJvmCache incrementalJvmCache;
            ModuleBuildTarget target = entry.getKey();
            List<? extends GeneratedFile> files = entry.getValue();
            KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = kotlinContext.getTargetsBinding().get(target);
            if (kotlinModuleBuildTarget == null) continue;
            KotlinModuleBuildTarget<?> kotlinModuleBuilderTarget = kotlinModuleBuildTarget;
            JpsIncrementalCache jpsIncrementalCache = incrementalCaches.get(kotlinModuleBuilderTarget);
            IncrementalJvmCache incrementalJvmCache2 = incrementalJvmCache = jpsIncrementalCache instanceof IncrementalJvmCache ? (IncrementalJvmCache)jpsIncrementalCache : null;
            if (incrementalJvmCache == null) continue;
            IncrementalJvmCache cache2 = incrementalJvmCache;
            Iterable $this$filterIsInstance$iv = files;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof GeneratedJvmClass)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List generated = (List)destination$iv$iv;
            Iterable $this$filter$iv = generated;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            element$iv$iv2 = $this$filterTo$iv$iv2.iterator();
            while (element$iv$iv2.hasNext()) {
                Object element$iv$iv3 = element$iv$iv2.next();
                GeneratedJvmClass it = (GeneratedJvmClass)element$iv$iv3;
                boolean bl = false;
                if (!(it.getOutputClass().getClassHeader().getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS)) continue;
                destination$iv$iv2.add(element$iv$iv3);
            }
            List multifileClasses = (List)destination$iv$iv2;
            Iterable $this$flatMap$iv2 = multifileClasses;
            boolean $i$f$flatMap = false;
            destination$iv$iv2 = $this$flatMap$iv2;
            Iterable destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv4 : $this$flatMapTo$iv$iv2) {
                GeneratedJvmClass it = (GeneratedJvmClass)element$iv$iv4;
                boolean bl = false;
                Collection collection = cache2.getAllPartsOfMultifileFacade(it.getOutputClass().getClassName());
                Iterable list$iv$iv = collection == null ? (Collection)CollectionsKt.emptyList() : collection;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            List expectedAllParts = (List)destination$iv$iv3;
            if (multifileClasses.isEmpty()) continue;
            Iterable $this$filter$iv2 = generated;
            boolean $i$f$filter2 = false;
            destination$iv$iv3 = $this$filter$iv2;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv5 : $this$filterTo$iv$iv) {
                GeneratedJvmClass it = (GeneratedJvmClass)element$iv$iv5;
                boolean bl = false;
                if (!(it.getOutputClass().getClassHeader().getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS_PART)) continue;
                destination$iv$iv4.add(element$iv$iv5);
            }
            $this$filter$iv2 = (List)destination$iv$iv4;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                GeneratedJvmClass it = (GeneratedJvmClass)item$iv$iv;
                object2 = destination$iv$iv4;
                boolean bl = false;
                object = it.getOutputClass().getClassName().toString();
                object2.add(object);
            }
            List actualParts = (List)destination$iv$iv4;
            if (actualParts.containsAll(expectedAllParts)) continue;
            $this$map$iv = expectedAllParts;
            object2 = fsOperations;
            boolean $i$f$flatMap2 = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv4 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv6 : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv6;
                boolean bl = false;
                Iterable list$iv$iv = cache2.sourcesByInternalName(it);
                CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
            }
            object = (List)destination$iv$iv4;
            $this$flatMap$iv = multifileClasses;
            object = (Collection)object;
            $i$f$flatMap2 = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv4 = new ArrayList();
            $i$f$flatMapTo2 = false;
            for (Object element$iv$iv7 : $this$flatMapTo$iv$iv) {
                GeneratedJvmClass it = (GeneratedJvmClass)element$iv$iv7;
                boolean bl = false;
                Iterable list$iv$iv = it.getSourceFiles();
                CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv4;
            ((FSOperationsHelper)object2).markFiles(CollectionsKt.plus((Collection)object, (Iterable)list));
        }
    }

    private static final ModuleBuildTarget getGeneratedFiles$target(SimpleOutputItem $this$getGeneratedFiles_u24target, ModuleChunk $chunk, ModuleBuildTarget representativeTarget, HashMap<File, ModuleBuildTarget> sourceToTarget) {
        Object object;
        Object object2;
        ModuleBuildTarget moduleBuildTarget;
        File file = (File)CollectionsKt.firstOrNull((Iterable)$this$getGeneratedFiles_u24target.getSourceFiles());
        if (file == null) {
            moduleBuildTarget = null;
        } else {
            object2 = file;
            File it = object2;
            boolean bl = false;
            moduleBuildTarget = sourceToTarget.get(it);
        }
        ModuleBuildTarget moduleBuildTarget2 = moduleBuildTarget;
        if (moduleBuildTarget2 == null) {
            Object v2;
            block8: {
                object2 = $chunk.getTargets();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"chunk.targets");
                Iterable $this$singleOrNull$iv = (Iterable)object2;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    boolean bl;
                    ModuleBuildTarget target = (ModuleBuildTarget)element$iv;
                    boolean bl2 = false;
                    File file2 = target.getOutputDir();
                    if (file2 == null) {
                        bl = false;
                    } else {
                        File file3;
                        File outputDir2 = file3 = file2;
                        boolean bl3 = false;
                        bl = FilesKt.startsWith((File)$this$getGeneratedFiles_u24target.getOutputFile(), (File)outputDir2);
                    }
                    if (!bl) continue;
                    if (found$iv) {
                        v2 = null;
                        break block8;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            file = v2;
            object = file == null ? representativeTarget : file;
        } else {
            object = moduleBuildTarget2;
        }
        return object;
    }

    static {
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.jps.build.KotlinBuilder");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"#org.jetbra\u2026jps.build.KotlinBuilder\")");
        LOG = logger;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$Companion;", "", "()V", "JPS_KOTLIN_HOME_PROPERTY", "", "KOTLIN_BUILDER_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "SKIP_CACHE_VERSION_CHECK_PROPERTY", "classesToLoadByParent", "Lorg/jetbrains/kotlin/preloading/ClassCondition;", "getClassesToLoadByParent", "()Lorg/jetbrains/kotlin/preloading/ClassCondition;", "jps-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final ClassCondition getClassesToLoadByParent() {
            return Companion::_get_classesToLoadByParent_$lambda-0;
        }

        private static final boolean _get_classesToLoadByParent_$lambda-0(String className) {
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"className");
            return StringsKt.startsWith$default((String)className, (String)"org.jetbrains.kotlin.load.kotlin.incremental.components.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"org.jetbrains.kotlin.incremental.components.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"org.jetbrains.kotlin.incremental.js", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)className, (Object)"org.jetbrains.kotlin.config.Services") || StringsKt.startsWith$default((String)className, (String)"org.apache.log4j.", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)className, (Object)"org.jetbrains.kotlin.progress.CompilationCanceledStatus") || Intrinsics.areEqual((Object)className, (Object)"org.jetbrains.kotlin.progress.CompilationCanceledException") || Intrinsics.areEqual((Object)className, (Object)"org.jetbrains.kotlin.modules.TargetId") || Intrinsics.areEqual((Object)className, (Object)"org.jetbrains.kotlin.cli.common.ExitCode");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

