/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preloading;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.preloading.ClassCondition;
import org.jetbrains.kotlin.preloading.ClassHandler;
import org.jetbrains.kotlin.preloading.ResourceData;

public class MemoryBasedClassLoader
extends ClassLoader {
    private final ClassCondition classesToLoadByParent;
    private final ClassLoader parent;
    private final Map<String, Object> preloadedResources;
    private final ClassHandler handler;
    private final ClassLoader fallbackResourceLoader;

    public MemoryBasedClassLoader(ClassCondition classesToLoadByParent, ClassLoader parent, Map<String, Object> preloadedResources, ClassHandler handler, ClassLoader fallbackResourceLoader) {
        super(null);
        this.classesToLoadByParent = classesToLoadByParent;
        this.parent = parent;
        this.preloadedResources = preloadedResources;
        this.handler = handler;
        this.fallbackResourceLoader = fallbackResourceLoader;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve2) throws ClassNotFoundException {
        if (this.classesToLoadByParent != null && this.classesToLoadByParent.accept(name)) {
            if (this.parent == null) {
                return super.loadClass(name, resolve2);
            }
            try {
                return this.parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return super.loadClass(name, resolve2);
            }
        }
        Class<?> aClass = super.loadClass(name, resolve2);
        if (aClass == null) {
            if (this.parent == null) {
                throw new ClassNotFoundException("Class not available in preloader: " + name);
            }
            return this.parent.loadClass(name);
        }
        return aClass;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String internalName = name.replace('.', '/').concat(".class");
        Object resources = this.preloadedResources.get(internalName);
        if (resources == null) {
            return null;
        }
        this.preloadedResources.remove(internalName);
        ResourceData resourceData = resources instanceof ResourceData ? (ResourceData)resources : (ResourceData)((List)resources).get(0);
        int sizeInBytes = resourceData.bytes.length;
        if (this.handler != null) {
            this.handler.beforeDefineClass(name, sizeInBytes);
        }
        Class<?> definedClass = this.defineClass(name, resourceData.bytes, 0, sizeInBytes);
        if (this.handler != null) {
            this.handler.afterDefineClass(name);
        }
        return definedClass;
    }

    @Override
    public URL getResource(String name) {
        URL resource = super.getResource(name);
        if (resource == null) {
            resource = this.fallbackResourceLoader.getResource(name);
        }
        if (resource == null && this.parent != null) {
            return this.parent.getResource(name);
        }
        return resource;
    }

    @Override
    protected URL findResource(String name) {
        Enumeration<URL> resources = this.findResources(name);
        return resources.hasMoreElements() ? resources.nextElement() : null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> own = super.getResources(name);
        if (!own.hasMoreElements()) {
            own = this.fallbackResourceLoader.getResources(name);
        }
        if (this.parent == null) {
            return own;
        }
        Enumeration<URL> fromParent = this.parent.getResources(name);
        if (!own.hasMoreElements()) {
            return fromParent;
        }
        ArrayList<URL> result = new ArrayList<URL>();
        while (own.hasMoreElements()) {
            result.add(own.nextElement());
        }
        while (fromParent.hasMoreElements()) {
            result.add(fromParent.nextElement());
        }
        return Collections.enumeration(result);
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        Object resources = this.preloadedResources.get(name);
        if (resources == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        if (resources instanceof ResourceData) {
            return Collections.enumeration(Collections.singletonList(((ResourceData)resources).getURL()));
        }
        assert (resources instanceof ArrayList) : "Resource map should contain ResourceData or ArrayList<ResourceData>: " + name;
        ArrayList resourceDatas = (ArrayList)resources;
        ArrayList<URL> urls = new ArrayList<URL>(resourceDatas.size());
        for (ResourceData data : resourceDatas) {
            urls.add(data.getURL());
        }
        return Collections.enumeration(urls);
    }
}

