/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypeBoundsChecker;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.CapturedArguments;
import org.jetbrains.kotlin.types.checker.IntersectionTypeKt;
import org.jetbrains.kotlin.types.checker.KotlinTypePreparator;
import org.jetbrains.kotlin.types.checker.NewCapturedType;
import org.jetbrains.kotlin.types.model.CaptureStatus;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a \u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\tH\u0002\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0004\u001a\u001a\u0010\u000f\u001a\u00020\u000b*\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u00a8\u0006\u0011"}, d2={"captureArguments", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "type", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "status", "Lorg/jetbrains/kotlin/types/model/CaptureStatus;", "captureArgumentsForIntersectionType", "Lorg/jetbrains/kotlin/types/checker/CapturedArguments;", "Lorg/jetbrains/kotlin/types/KotlinType;", "captureFromArguments", "Lorg/jetbrains/kotlin/types/SimpleType;", "captureFromExpression", "prepareArgumentTypeRegardingCaptureTypes", "argumentType", "replaceArguments", "arguments", "descriptors"})
public final class NewCapturedTypeKt {
    @Nullable
    public static final UnwrappedType prepareArgumentTypeRegardingCaptureTypes(@NotNull UnwrappedType argumentType) {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        return argumentType instanceof NewCapturedType ? null : NewCapturedTypeKt.captureFromExpression(argumentType);
    }

    @Nullable
    public static final UnwrappedType captureFromExpression(@NotNull UnwrappedType type2) {
        UnwrappedType unwrappedType;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        TypeConstructor typeConstructor2 = type2.getConstructor();
        if (!(typeConstructor2 instanceof IntersectionTypeConstructor)) {
            return NewCapturedTypeKt.captureFromArguments(type2, CaptureStatus.FROM_EXPRESSION);
        }
        List<CapturedArguments> list = NewCapturedTypeKt.captureArgumentsForIntersectionType(type2);
        if (list == null) {
            return null;
        }
        List<CapturedArguments> capturedArgumentsByComponents = list;
        if (type2 instanceof FlexibleType) {
            SimpleType lowerIntersectedType = IntersectionTypeKt.intersectTypes(NewCapturedTypeKt.captureFromExpression$replaceArgumentsWithCapturedArgumentsByIntersectionComponents(capturedArgumentsByComponents, ((FlexibleType)type2).getLowerBound())).makeNullableAsSpecified(((FlexibleType)type2).getLowerBound().isMarkedNullable());
            SimpleType upperIntersectedType = IntersectionTypeKt.intersectTypes(NewCapturedTypeKt.captureFromExpression$replaceArgumentsWithCapturedArgumentsByIntersectionComponents(capturedArgumentsByComponents, ((FlexibleType)type2).getUpperBound())).makeNullableAsSpecified(((FlexibleType)type2).getUpperBound().isMarkedNullable());
            unwrappedType = KotlinTypeFactory.flexibleType(lowerIntersectedType, upperIntersectedType);
        } else {
            unwrappedType = IntersectionTypeKt.intersectTypes(NewCapturedTypeKt.captureFromExpression$replaceArgumentsWithCapturedArgumentsByIntersectionComponents(capturedArgumentsByComponents, type2)).makeNullableAsSpecified(type2.isMarkedNullable());
        }
        return unwrappedType;
    }

    @Nullable
    public static final SimpleType captureFromArguments(@NotNull SimpleType type2, @NotNull CaptureStatus status) {
        SimpleType simpleType2;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        List<TypeProjection> list = NewCapturedTypeKt.captureArguments(type2, status);
        if (list == null) {
            simpleType2 = null;
        } else {
            List<TypeProjection> list2;
            List<TypeProjection> it = list2 = list;
            boolean bl = false;
            simpleType2 = NewCapturedTypeKt.replaceArguments(type2, it);
        }
        return simpleType2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<CapturedArguments> captureArgumentsForIntersectionType(KotlinType type2) {
        void $this$mapNotNullTo$iv$iv;
        Collection collection;
        HashSet<Pair> set$iv;
        if (type2 instanceof FlexibleType) {
            List typesToCapture = CollectionsKt.plus(NewCapturedTypeKt.captureArgumentsForIntersectionType$getTypesToCapture(((FlexibleType)type2).getLowerBound()), (Iterable)NewCapturedTypeKt.captureArgumentsForIntersectionType$getTypesToCapture(((FlexibleType)type2).getUpperBound()));
            Iterable $this$distinctBy$iv = typesToCapture;
            boolean $i$f$distinctBy = false;
            set$iv = new HashSet<Pair>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                KotlinType it = (KotlinType)e$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                FqName fqName2 = FlexibleTypeBoundsChecker.INSTANCE.getBaseBoundFqNameByMutability(it);
                Pair key$iv = TuplesKt.to((Object)(fqName2 == null ? it.getConstructor() : fqName2), it.getArguments());
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            collection = list$iv;
        } else {
            collection = type2.getConstructor().getSupertypes();
        }
        Collection collection2 = collection;
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"if (type is FlexibleType\u2026pe.constructor.supertypes");
        Collection filteredTypesToCapture = collection2;
        boolean changed = false;
        HashSet<Pair> $this$mapNotNull$iv = (HashSet<Pair>)filteredTypesToCapture;
        boolean $i$f$mapNotNull = false;
        set$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CapturedArguments capturedArguments;
            CapturedArguments capturedArguments2;
            CapturedArguments capturedArguments3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinType typeToCapture = (KotlinType)element$iv$iv;
            boolean bl2 = false;
            List<TypeProjection> list = NewCapturedTypeKt.captureArguments(typeToCapture.unwrap(), CaptureStatus.FROM_EXPRESSION);
            if (list == null) {
                capturedArguments3 = null;
            } else {
                List<TypeProjection> capturedArguments4 = list;
                changed = true;
                Intrinsics.checkNotNullExpressionValue((Object)typeToCapture, (String)"typeToCapture");
                capturedArguments3 = capturedArguments2 = new CapturedArguments(capturedArguments4, typeToCapture);
            }
            if (capturedArguments2 == null) continue;
            CapturedArguments it$iv$iv = capturedArguments = capturedArguments2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List capturedArgumentsByTypes = (List)destination$iv$iv;
        if (!changed) {
            return null;
        }
        return capturedArgumentsByTypes;
    }

    private static final UnwrappedType captureFromArguments(UnwrappedType type2, CaptureStatus status) {
        List<TypeProjection> list = NewCapturedTypeKt.captureArguments(type2, status);
        if (list == null) {
            return null;
        }
        List<TypeProjection> capturedArguments = list;
        return type2 instanceof FlexibleType ? KotlinTypeFactory.flexibleType(NewCapturedTypeKt.replaceArguments(((FlexibleType)type2).getLowerBound(), capturedArguments), NewCapturedTypeKt.replaceArguments(((FlexibleType)type2).getUpperBound(), capturedArguments)) : (UnwrappedType)NewCapturedTypeKt.replaceArguments(type2, capturedArguments);
    }

    private static final SimpleType replaceArguments(UnwrappedType $this$replaceArguments, List<? extends TypeProjection> arguments) {
        return KotlinTypeFactory.simpleType$default($this$replaceArguments.getAnnotations(), $this$replaceArguments.getConstructor(), arguments, $this$replaceArguments.isMarkedNullable(), null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<TypeProjection> captureArguments(UnwrappedType type2, CaptureStatus status) {
        Object object;
        Iterable<KotlinType> $dstr$projection$parameter;
        Collection collection;
        void $this$mapTo$iv$iv;
        Object element$iv2;
        boolean bl;
        List<TypeProjection> arguments;
        block11: {
            if (type2.getArguments().size() != type2.getConstructor().getParameters().size()) {
                return null;
            }
            arguments = type2.getArguments();
            Iterable $this$all$iv = arguments;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    TypeProjection it = (TypeProjection)element$iv2;
                    boolean bl2 = false;
                    if (it.getProjectionKind() == Variance.INVARIANT) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        Iterable iterable = arguments;
        List<TypeParameterDescriptor> $i$f$all = type2.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue($i$f$all, (String)"type.constructor.parameters");
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)iterable, (Iterable)$i$f$all);
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TypeProjection typeProjection;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            TypeProjection projection = (TypeProjection)$dstr$projection$parameter.component1();
            TypeParameterDescriptor parameter = (TypeParameterDescriptor)$dstr$projection$parameter.component2();
            if (projection.getProjectionKind() == Variance.INVARIANT) {
                typeProjection = projection;
            } else {
                UnwrappedType lowerType = !projection.isStarProjection() && projection.getProjectionKind() == Variance.IN_VARIANCE ? projection.getType().unwrap() : (UnwrappedType)null;
                Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
                typeProjection = TypeUtilsKt.asTypeProjection(new NewCapturedType(status, lowerType, projection, parameter));
            }
            object = typeProjection;
            collection.add(object);
        }
        List capturedArguments = (List)destination$iv$iv;
        TypeSubstitutor substitutor = TypeConstructorSubstitution.Companion.create(type2.getConstructor(), capturedArguments).buildSubstitutor();
        int n = 0;
        int n2 = arguments.size();
        while (n < n2) {
            void destination$iv;
            void $this$mapTo$iv;
            int index = n++;
            TypeProjection oldProjection = arguments.get(index);
            TypeProjection newProjection = (TypeProjection)capturedArguments.get(index);
            if (oldProjection.getProjectionKind() == Variance.INVARIANT) continue;
            $dstr$projection$parameter = type2.getConstructor().getParameters().get(index).getUpperBounds();
            Intrinsics.checkNotNullExpressionValue($dstr$projection$parameter, (String)"type.constructor.parameters[index].upperBounds");
            $dstr$projection$parameter = $dstr$projection$parameter;
            Collection bl3 = new ArrayList();
            boolean $i$f$mapTo2 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv;
                collection = destination$iv;
                boolean bl4 = false;
                object = KotlinTypePreparator.Default.INSTANCE.prepareType(substitutor.safeSubstitute((KotlinType)it, Variance.INVARIANT).unwrap());
                collection.add(object);
            }
            List capturedTypeSupertypes = (List)destination$iv;
            if (!oldProjection.isStarProjection() && oldProjection.getProjectionKind() == Variance.OUT_VARIANCE) {
                ((Collection)capturedTypeSupertypes).add(KotlinTypePreparator.Default.INSTANCE.prepareType(oldProjection.getType().unwrap()));
            }
            NewCapturedType capturedType = (NewCapturedType)newProjection.getType();
            capturedType.getConstructor().initializeSupertypes(capturedTypeSupertypes);
        }
        return capturedArguments;
    }

    private static final List<TypeProjection> captureFromExpression$findCorrespondingCapturedArgumentsForType(List<CapturedArguments> capturedArgumentsByComponents, KotlinType type2) {
        Object v0;
        block1: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)capturedArgumentsByComponents;
            for (Object t : iterable2) {
                CapturedArguments typeToCapture = (CapturedArguments)t;
                boolean bl = false;
                if (!typeToCapture.isSuitableForType(type2)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        CapturedArguments capturedArguments = v0;
        return capturedArguments == null ? null : capturedArguments.getCapturedArguments();
    }

    /*
     * WARNING - void declaration
     */
    private static final List<SimpleType> captureFromExpression$replaceArgumentsWithCapturedArgumentsByIntersectionComponents(List<CapturedArguments> capturedArgumentsByComponents, UnwrappedType typeToReplace) {
        List list;
        if (typeToReplace.getConstructor() instanceof IntersectionTypeConstructor) {
            void $this$mapTo$iv$iv;
            Collection<KotlinType> collection = typeToReplace.getConstructor().getSupertypes();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"typeToReplace.constructor.supertypes");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                SimpleType simpleType2;
                void componentType;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)componentType, (String)"componentType");
                List<TypeProjection> list2 = NewCapturedTypeKt.captureFromExpression$findCorrespondingCapturedArgumentsForType(capturedArgumentsByComponents, (KotlinType)componentType);
                if (list2 == null) {
                    simpleType2 = TypeSubstitutionKt.asSimpleType((KotlinType)componentType);
                } else {
                    List<TypeProjection> capturedArguments = list2;
                    simpleType2 = NewCapturedTypeKt.replaceArguments(componentType.unwrap(), capturedArguments);
                }
                SimpleType simpleType3 = simpleType2;
                collection2.add(simpleType3);
            }
            list = (List)destination$iv$iv;
        } else {
            List<TypeProjection> list3 = NewCapturedTypeKt.captureFromExpression$findCorrespondingCapturedArgumentsForType(capturedArgumentsByComponents, typeToReplace);
            if (list3 == null) {
                return CollectionsKt.listOf((Object)TypeSubstitutionKt.asSimpleType(typeToReplace));
            }
            List<TypeProjection> capturedArguments = list3;
            list = CollectionsKt.listOf((Object)NewCapturedTypeKt.replaceArguments(typeToReplace.unwrap(), capturedArguments));
        }
        return list;
    }

    private static final Collection<KotlinType> captureArgumentsForIntersectionType$getTypesToCapture(KotlinType type2) {
        Collection<KotlinType> collection;
        if (type2.getConstructor() instanceof IntersectionTypeConstructor) {
            Collection<KotlinType> collection2 = type2.getConstructor().getSupertypes();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"type.constructor.supertypes");
            collection = collection2;
        } else {
            collection = CollectionsKt.listOf((Object)type2);
        }
        return collection;
    }
}

