/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.typesApproximation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.types.typesApproximation.ApproximationBounds;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;
import org.jetbrains.kotlin.types.typesApproximation.TypeArgument;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\r\u001a\u00020\u0002*\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002\u001a\u0014\u0010\u0010\u001a\u00020\n*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0005*\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"approximateCapturedTypes", "Lorg/jetbrains/kotlin/types/typesApproximation/ApproximationBounds;", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "approximateCapturedTypesIfNecessary", "Lorg/jetbrains/kotlin/types/TypeProjection;", "typeProjection", "approximateContravariant", "", "approximateProjection", "Lorg/jetbrains/kotlin/types/typesApproximation/TypeArgument;", "typeArgument", "substituteCapturedTypesWithProjections", "replaceTypeArguments", "newTypeArguments", "", "toTypeArgument", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "toTypeProjection", "descriptors"})
public final class CapturedTypeApproximationKt {
    private static final TypeProjection toTypeProjection(TypeArgument $this$toTypeProjection) {
        boolean bl = $this$toTypeProjection.isConsistent();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            DescriptorRenderer descriptorRenderer2 = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)toTypeProjection.1.descriptorRenderer.1.INSTANCE));
            String string = "Only consistent enhanced type projection can be converted to type projection, but [" + descriptorRenderer2.render($this$toTypeProjection.getTypeParameter()) + ": <" + descriptorRenderer2.renderType($this$toTypeProjection.getInProjection()) + ", " + descriptorRenderer2.renderType($this$toTypeProjection.getOutProjection()) + ">] was found";
            throw new AssertionError((Object)string);
        }
        return Intrinsics.areEqual((Object)$this$toTypeProjection.getInProjection(), (Object)$this$toTypeProjection.getOutProjection()) || $this$toTypeProjection.getTypeParameter().getVariance() == Variance.IN_VARIANCE ? (TypeProjection)new TypeProjectionImpl($this$toTypeProjection.getInProjection()) : (KotlinBuiltIns.isNothing($this$toTypeProjection.getInProjection()) && $this$toTypeProjection.getTypeParameter().getVariance() != Variance.IN_VARIANCE ? (TypeProjection)new TypeProjectionImpl(CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant($this$toTypeProjection, Variance.OUT_VARIANCE), $this$toTypeProjection.getOutProjection()) : (KotlinBuiltIns.isNullableAny($this$toTypeProjection.getOutProjection()) ? (TypeProjection)new TypeProjectionImpl(CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant($this$toTypeProjection, Variance.IN_VARIANCE), $this$toTypeProjection.getInProjection()) : (TypeProjection)new TypeProjectionImpl(CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant($this$toTypeProjection, Variance.OUT_VARIANCE), $this$toTypeProjection.getOutProjection())));
    }

    private static final TypeArgument toTypeArgument(TypeProjection $this$toTypeArgument, TypeParameterDescriptor typeParameter) {
        TypeArgument typeArgument;
        Variance variance = TypeSubstitutor.combine(typeParameter.getVariance(), $this$toTypeArgument);
        int n = WhenMappings.$EnumSwitchMapping$0[variance.ordinal()];
        switch (n) {
            case 1: {
                KotlinType kotlinType = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type");
                KotlinType kotlinType2 = kotlinType;
                kotlinType = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type");
                TypeArgument typeArgument2 = new TypeArgument(typeParameter, kotlinType2, kotlinType);
                typeArgument = typeArgument2;
                break;
            }
            case 2: {
                KotlinType kotlinType = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type");
                KotlinType kotlinType3 = kotlinType;
                kotlinType = DescriptorUtilsKt.getBuiltIns(typeParameter).getNullableAnyType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"typeParameter.builtIns.nullableAnyType");
                TypeArgument typeArgument3 = new TypeArgument(typeParameter, kotlinType3, kotlinType);
                typeArgument = typeArgument3;
                break;
            }
            case 3: {
                KotlinType kotlinType = DescriptorUtilsKt.getBuiltIns(typeParameter).getNothingType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"typeParameter.builtIns.nothingType");
                KotlinType kotlinType4 = kotlinType;
                kotlinType = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type");
                TypeArgument typeArgument4 = new TypeArgument(typeParameter, kotlinType4, kotlinType);
                typeArgument = typeArgument4;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeArgument;
    }

    @Nullable
    public static final TypeProjection approximateCapturedTypesIfNecessary(@Nullable TypeProjection typeProjection, boolean approximateContravariant) {
        Object approximation;
        if (typeProjection == null) {
            return null;
        }
        if (typeProjection.isStarProjection()) {
            return typeProjection;
        }
        KotlinType kotlinType = typeProjection.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"typeProjection.type");
        KotlinType type2 = kotlinType;
        if (!TypeUtils.contains(type2, (Function1<UnwrappedType, Boolean>)((Function1)approximateCapturedTypesIfNecessary.1.INSTANCE))) {
            return typeProjection;
        }
        Variance variance = typeProjection.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"typeProjection.projectionKind");
        Variance howThisTypeIsUsed = variance;
        if (howThisTypeIsUsed == Variance.OUT_VARIANCE) {
            approximation = CapturedTypeApproximationKt.approximateCapturedTypes(type2);
            return new TypeProjectionImpl(howThisTypeIsUsed, (KotlinType)((ApproximationBounds)approximation).getUpper());
        }
        if (approximateContravariant) {
            approximation = CapturedTypeApproximationKt.approximateCapturedTypes(type2).getLower();
            return new TypeProjectionImpl(howThisTypeIsUsed, (KotlinType)approximation);
        }
        return CapturedTypeApproximationKt.substituteCapturedTypesWithProjections(typeProjection);
    }

    private static final TypeProjection substituteCapturedTypesWithProjections(TypeProjection typeProjection) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new TypeConstructorSubstitution(){

            @Nullable
            public TypeProjection get(@NotNull TypeConstructor key) {
                CapturedTypeConstructor capturedTypeConstructor;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                CapturedTypeConstructor capturedTypeConstructor2 = capturedTypeConstructor = key instanceof CapturedTypeConstructor ? (CapturedTypeConstructor)key : null;
                if (capturedTypeConstructor == null) {
                    return null;
                }
                CapturedTypeConstructor capturedTypeConstructor3 = capturedTypeConstructor;
                if (capturedTypeConstructor3.getProjection().isStarProjection()) {
                    return new TypeProjectionImpl(Variance.OUT_VARIANCE, capturedTypeConstructor3.getProjection().getType());
                }
                return capturedTypeConstructor3.getProjection();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(object : TypeCons\u2026ojection\n        }\n    })");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        return typeSubstitutor3.substituteWithoutApproximation(typeProjection);
    }

    @NotNull
    public static final ApproximationBounds<KotlinType> approximateCapturedTypes(@NotNull KotlinType type2) {
        KotlinType kotlinType;
        boolean lowerBoundIsTrivial;
        Object object3;
        ArrayList<TypeArgument> upperBoundArguments;
        ArrayList<TypeArgument> lowerBoundArguments;
        block14: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            if (FlexibleTypesKt.isFlexible(type2)) {
                ApproximationBounds<KotlinType> boundsForFlexibleLower = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.lowerIfFlexible(type2));
                ApproximationBounds<KotlinType> boundsForFlexibleUpper = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.upperIfFlexible(type2));
                return new ApproximationBounds<KotlinType>(TypeWithEnhancementKt.inheritEnhancement(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible(boundsForFlexibleLower.getLower()), FlexibleTypesKt.upperIfFlexible(boundsForFlexibleUpper.getLower())), type2), TypeWithEnhancementKt.inheritEnhancement(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible(boundsForFlexibleLower.getUpper()), FlexibleTypesKt.upperIfFlexible(boundsForFlexibleUpper.getUpper())), type2));
            }
            TypeConstructor typeConstructor2 = type2.getConstructor();
            if (CapturedTypeConstructorKt.isCaptured(type2)) {
                ApproximationBounds<KotlinType> approximationBounds;
                TypeProjection typeProjection = ((CapturedTypeConstructor)typeConstructor2).getProjection();
                Object object2 = typeProjection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"typeProjection.type");
                KotlinType bound = CapturedTypeApproximationKt.approximateCapturedTypes$makeNullableIfNeeded((KotlinType)object2, type2);
                object2 = typeProjection.getProjectionKind();
                int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object2).ordinal()];
                switch (n) {
                    case 2: {
                        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(type2).getNullableAnyType();
                        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"type.builtIns.nullableAnyType");
                        ApproximationBounds<KotlinType> approximationBounds2 = new ApproximationBounds<KotlinType>(bound, simpleType2);
                        approximationBounds = approximationBounds2;
                        break;
                    }
                    case 3: {
                        SimpleType simpleType3 = TypeUtilsKt.getBuiltIns(type2).getNothingType();
                        Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"type.builtIns.nothingType");
                        ApproximationBounds<KotlinType> approximationBounds3 = new ApproximationBounds<KotlinType>(CapturedTypeApproximationKt.approximateCapturedTypes$makeNullableIfNeeded(simpleType3, type2), bound);
                        approximationBounds = approximationBounds3;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)Intrinsics.stringPlus((String)"Only nontrivial projections should have been captured, not: ", (Object)typeProjection));
                    }
                }
                return approximationBounds;
            }
            if (type2.getArguments().isEmpty() || type2.getArguments().size() != typeConstructor2.getParameters().size()) {
                return new ApproximationBounds<KotlinType>(type2, type2);
            }
            lowerBoundArguments = new ArrayList<TypeArgument>();
            upperBoundArguments = new ArrayList<TypeArgument>();
            Iterable iterable = type2.getArguments();
            object3 = typeConstructor2.getParameters();
            Intrinsics.checkNotNullExpressionValue(object3, (String)"typeConstructor.parameters");
            for (Object object3 : CollectionsKt.zip((Iterable)iterable, (Iterable)((Iterable)object3))) {
                TypeProjection typeProjection = (TypeProjection)object3.component1();
                TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)object3.component2();
                Intrinsics.checkNotNullExpressionValue((Object)typeParameter, (String)"typeParameter");
                TypeArgument typeArgument = CapturedTypeApproximationKt.toTypeArgument(typeProjection, typeParameter);
                if (typeProjection.isStarProjection()) {
                    lowerBoundArguments.add(typeArgument);
                    upperBoundArguments.add(typeArgument);
                    continue;
                }
                ApproximationBounds<TypeArgument> approximationBounds = CapturedTypeApproximationKt.approximateProjection(typeArgument);
                TypeArgument lower = approximationBounds.component1();
                TypeArgument upper = approximationBounds.component2();
                lowerBoundArguments.add(lower);
                upperBoundArguments.add(upper);
            }
            Iterable $this$any$iv = lowerBoundArguments;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeArgument it = (TypeArgument)element$iv;
                    boolean bl2 = false;
                    if (!(!it.isConsistent())) continue;
                    bl = true;
                    break block14;
                }
                bl = lowerBoundIsTrivial = false;
            }
        }
        if (lowerBoundIsTrivial) {
            object3 = TypeUtilsKt.getBuiltIns(type2).getNothingType();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"type.builtIns.nothingType");
            kotlinType = (KotlinType)object3;
        } else {
            kotlinType = CapturedTypeApproximationKt.replaceTypeArguments(type2, (List<TypeArgument>)lowerBoundArguments);
        }
        return new ApproximationBounds<KotlinType>(kotlinType, CapturedTypeApproximationKt.replaceTypeArguments(type2, (List<TypeArgument>)upperBoundArguments));
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinType replaceTypeArguments(KotlinType $this$replaceTypeArguments, List<TypeArgument> newTypeArguments) {
        Collection<TypeProjection> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl;
        boolean bl2 = bl = $this$replaceTypeArguments.getArguments().size() == newTypeArguments.size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CapturedTypeApproximationKt$replaceTypeArguments$22 = false;
            String $i$a$-assert-CapturedTypeApproximationKt$replaceTypeArguments$22 = Intrinsics.stringPlus((String)"Incorrect type arguments ", newTypeArguments);
            throw new AssertionError((Object)$i$a$-assert-CapturedTypeApproximationKt$replaceTypeArguments$22);
        }
        Iterable iterable = newTypeArguments;
        KotlinType kotlinType = $this$replaceTypeArguments;
        boolean $i$f$map = false;
        void var4_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeArgument typeArgument = (TypeArgument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            TypeProjection typeProjection = CapturedTypeApproximationKt.toTypeProjection((TypeArgument)it);
            collection.add(typeProjection);
        }
        collection = (List)destination$iv$iv;
        return TypeSubstitutionKt.replace$default(kotlinType, (List)collection, null, null, 6, null);
    }

    private static final ApproximationBounds<TypeArgument> approximateProjection(TypeArgument typeArgument) {
        ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getInProjection());
        KotlinType inLower = approximationBounds.component1();
        KotlinType inUpper = approximationBounds.component2();
        ApproximationBounds<KotlinType> approximationBounds2 = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getOutProjection());
        KotlinType outLower = approximationBounds2.component1();
        KotlinType outUpper = approximationBounds2.component2();
        return new ApproximationBounds<TypeArgument>(new TypeArgument(typeArgument.getTypeParameter(), inUpper, outLower), new TypeArgument(typeArgument.getTypeParameter(), inLower, outUpper));
    }

    private static final Variance toTypeProjection$removeProjectionIfRedundant(TypeArgument $this_toTypeProjection, Variance variance) {
        return variance == $this_toTypeProjection.getTypeParameter().getVariance() ? Variance.INVARIANT : variance;
    }

    private static final KotlinType approximateCapturedTypes$makeNullableIfNeeded(KotlinType $this$approximateCapturedTypes_u24makeNullableIfNeeded, KotlinType $type) {
        KotlinType kotlinType = TypeUtils.makeNullableIfNeeded($this$approximateCapturedTypes_u24makeNullableIfNeeded, $type.isMarkedNullable());
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"makeNullableIfNeeded(this, type.isMarkedNullable)");
        return kotlinType;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            nArray[Variance.INVARIANT.ordinal()] = 1;
            nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

